/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.ui;

import ModernDocking.Dockable;
import ModernDocking.DockableStyle;
import ModernDocking.event.DockingEvent;
import ModernDocking.event.DockingListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class DefaultDockingPanel
extends JPanel
implements Dockable,
DockingListener {
    private String persistentID;
    private int type;
    private String tabText = "";
    private Icon icon;
    private boolean floatingAllowed;
    private boolean limitToRoot;
    private DockableStyle style;
    private boolean canBeClosed;
    private boolean allowPinning;
    private boolean allowMinMax;
    private List<JMenu> moreOptions = new ArrayList<JMenu>();
    private final List<DockingListener> listeners = new ArrayList<DockingListener>();

    public DefaultDockingPanel() {
    }

    public DefaultDockingPanel(String persistentID, String text) {
        this.persistentID = persistentID;
        this.tabText = text;
    }

    @Override
    public String getPersistentID() {
        return this.persistentID;
    }

    public void setPersistentID(String persistentID) {
        this.persistentID = persistentID;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public String getTabText() {
        return this.tabText;
    }

    public void setTabText(String tabText) {
        this.tabText = tabText;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public boolean isFloatingAllowed() {
        return this.floatingAllowed;
    }

    public void setFloatingAllowed(boolean isFloatingAllowed) {
        this.floatingAllowed = isFloatingAllowed;
    }

    @Override
    public boolean isLimitedToRoot() {
        return this.limitToRoot;
    }

    public void setLimitedToRoot(boolean limitToRoot) {
        this.limitToRoot = limitToRoot;
    }

    @Override
    public DockableStyle getStyle() {
        return this.style;
    }

    public void setStyle(DockableStyle style) {
        this.style = style;
    }

    @Override
    public boolean isClosable() {
        return this.canBeClosed;
    }

    public void setClosable(boolean canBeClosed) {
        this.canBeClosed = canBeClosed;
    }

    @Override
    public boolean isPinningAllowed() {
        return this.allowPinning;
    }

    public void setPinningAllowed(boolean allowPinning) {
        this.allowPinning = allowPinning;
    }

    @Override
    public boolean isMinMaxAllowed() {
        return this.allowMinMax;
    }

    public void setMinMaxAllowed(boolean allowMinMax) {
        this.allowMinMax = allowMinMax;
    }

    @Override
    public boolean getHasMoreOptions() {
        return this.moreOptions.size() > 0;
    }

    public void setMoreOptions(List<JMenu> options) {
        this.moreOptions = options;
    }

    @Override
    public void addMoreOptions(JPopupMenu menu) {
        for (JMenu option : this.moreOptions) {
            menu.add(option);
        }
    }

    public void addDockingListener(DockingListener listener) {
        this.listeners.add(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void dockingChange(DockingEvent e) {
        if (e.getDockable() == this) {
            this.listeners.forEach(listener -> listener.dockingChange(e));
        }
    }
}

