/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.ui;

import ModernDocking.ui.DockingHeaderUI;
import ModernDocking.ui.DockingSettings;
import ModernDocking.ui.HeaderController;
import ModernDocking.ui.HeaderModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class DefaultHeaderUI
extends JPanel
implements DockingHeaderUI,
AncestorListener {
    private final HeaderController headerController;
    private final HeaderModel headerModel;
    protected final JLabel titleLabel = new JLabel();
    protected final JButton settings = new JButton();
    protected final JButton close = new JButton();
    protected final JLabel maximizedIndicator = new JLabel("Maximized");
    private final JPopupMenu settingsMenu = new JPopupMenu();
    private final JMenuItem pinned = new JMenuItem("Pinned");
    private final JMenuItem unpinned = new JMenuItem("Unpinned");
    private final JMenuItem window = new JMenuItem("Window");
    private final JCheckBoxMenuItem maximizeOption = new JCheckBoxMenuItem("Maximize");
    protected boolean initialized = false;
    private Color backgroundOverride = null;
    private Color foregroundOverride = null;

    public DefaultHeaderUI(HeaderController headerController, HeaderModel headerModel) {
        this.headerController = headerController;
        this.headerModel = headerModel;
        this.setOpaque(true);
        JComponent component = (JComponent)((Object)headerModel.dockable);
        component.addAncestorListener(this);
    }

    @Override
    public void displaySettingsMenu(JButton settings) {
        this.settingsMenu.show(settings, settings.getWidth(), settings.getHeight());
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            this.settings.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/api_icons/settings.png"))));
            this.close.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/api_icons/close.png"))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.settings.addActionListener(e -> this.displaySettingsMenu(this.settings));
        this.settings.addActionListener(e -> this.settingsMenu.show(this.settings, this.settings.getWidth(), this.settings.getHeight()));
        this.close.addActionListener(e -> this.headerController.close());
        this.setupButton(this.settings);
        this.setupButton(this.close);
        this.configureColors();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 6, 1, 2);
        JLabel iconLabel = new JLabel(this.headerModel.icon());
        this.add((Component)iconLabel, gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.titleLabel.setText(this.headerModel.titleText());
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.titleLabel.setMinimumSize(new Dimension(0, 28));
        this.titleLabel.setPreferredSize(new Dimension(0, 28));
        this.add((Component)this.titleLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.2;
        this.maximizedIndicator.setVisible(false);
        this.maximizedIndicator.setFont(this.maximizedIndicator.getFont().deriveFont(1));
        this.add((Component)this.maximizedIndicator, gbc);
        ++gbc.gridx;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        if (this.headerModel.hasMoreOptions() || this.headerModel.isMaximizeAllowed() || this.headerModel.isPinnedAllowed() || this.headerModel.isFloatingAllowed()) {
            this.addOptions();
            this.add((Component)this.settings, gbc);
            ++gbc.gridx;
        }
        if (this.headerModel.isCloseAllowed()) {
            this.add((Component)this.close, gbc);
            ++gbc.gridx;
        }
    }

    protected void configureColors() {
        Color color = DockingSettings.getHeaderBackground();
        this.setBackground(color);
        this.setForeground(DockingSettings.getHeaderForeground());
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, DockingSettings.getHighlighterNotSelectedBorder()));
        UIManager.addPropertyChangeListener(e -> {
            if ("lookAndFeel".equals(e.getPropertyName())) {
                Color bg = DockingSettings.getHeaderBackground();
                SwingUtilities.invokeLater(() -> {
                    this.setBackground(bg);
                    this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, DockingSettings.getHighlighterNotSelectedBorder()));
                });
                SwingUtilities.updateComponentTreeUI(this.settingsMenu);
            } else if (e.getPropertyName().equals("ModernDocking.titlebar.background")) {
                Color bg = DockingSettings.getHeaderBackground();
                SwingUtilities.invokeLater(() -> this.setBackground(bg));
            }
        });
    }

    private void addOptions() {
        this.headerModel.addMoreOptions(this.settingsMenu);
        if (this.settingsMenu.getComponentCount() > 0) {
            this.settingsMenu.addSeparator();
        }
        this.window.setEnabled(this.headerModel.isFloatingAllowed());
        this.pinned.addActionListener(e -> this.headerController.pinDockable());
        this.unpinned.addActionListener(e -> this.headerController.unpinDockable());
        this.window.addActionListener(e -> this.headerController.newWindow());
        JMenu viewMode = new JMenu("View Mode");
        viewMode.add(this.pinned);
        viewMode.add(this.unpinned);
        viewMode.add(this.window);
        this.settingsMenu.add(viewMode);
        this.settingsMenu.addSeparator();
        this.settingsMenu.add(this.maximizeOption);
        this.maximizeOption.addActionListener(e -> {
            boolean maxed = this.headerModel.isMaximized();
            this.maximizeOption.setSelected(!maxed);
            this.maximizedIndicator.setVisible(!maxed);
            if (maxed) {
                this.headerController.minimize();
            } else {
                this.headerController.maximize();
            }
        });
    }

    private void setupButton(final JButton button) {
        button.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        button.setFocusable(false);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setContentAreaFilled(true);
                button.setOpaque(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setContentAreaFilled(false);
                button.setOpaque(false);
            }
        });
    }

    @Override
    public void setBackgroundOverride(Color color) {
        this.backgroundOverride = color;
    }

    @Override
    public void setForegroundOverride(Color color) {
        this.foregroundOverride = color;
    }

    @Override
    public void setBackground(Color bg) {
        if (this.backgroundOverride != null) {
            bg = this.backgroundOverride;
        }
        super.setBackground(bg);
        if (this.close != null) {
            this.close.setBackground(bg);
        }
        if (this.settings != null) {
            this.settings.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        if (this.foregroundOverride != null) {
            fg = this.foregroundOverride;
        }
        super.setForeground(fg);
        if (this.titleLabel != null) {
            this.titleLabel.setForeground(fg);
        }
        if (this.close != null) {
            this.close.setForeground(fg);
        }
        if (this.settings != null) {
            this.settings.setForeground(fg);
        }
    }

    @Override
    public void update() {
        this.titleLabel.setText(this.headerModel.titleText());
        this.maximizedIndicator.setVisible(this.headerModel.isMaximized());
        this.maximizeOption.setSelected(this.headerModel.isMaximized());
        this.maximizeOption.setEnabled(this.headerModel.isMaximizeAllowed());
        this.pinned.setEnabled(this.headerModel.isPinnedAllowed() && this.headerModel.isUnpinned());
        this.unpinned.setEnabled(this.headerModel.isPinnedAllowed() && !this.headerModel.isUnpinned());
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.init();
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }
}

