/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.util;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;

public class UnselectableButtonGroup
extends ButtonGroup {
    protected final Vector<AbstractButton> buttons = new Vector();
    ButtonModel selection = null;

    @Override
    public void add(AbstractButton b) {
        if (b == null) {
            return;
        }
        this.buttons.addElement(b);
        if (b.isSelected()) {
            if (this.selection == null) {
                this.selection = b.getModel();
            } else {
                b.setSelected(false);
            }
        }
        b.getModel().setGroup(this);
    }

    @Override
    public void remove(AbstractButton b) {
        if (b == null) {
            return;
        }
        this.buttons.removeElement(b);
        if (b.getModel() == this.selection) {
            this.selection = null;
        }
        b.getModel().setGroup(null);
    }

    @Override
    public void clearSelection() {
        if (this.selection != null) {
            ButtonModel oldSelection = this.selection;
            this.selection = null;
            oldSelection.setSelected(false);
        }
    }

    @Override
    public Enumeration<AbstractButton> getElements() {
        return this.buttons.elements();
    }

    @Override
    public ButtonModel getSelection() {
        return this.selection;
    }

    @Override
    public void setSelected(ButtonModel model, boolean selected) {
        if (selected) {
            if (model != this.selection) {
                ButtonModel oldSelection = this.selection;
                this.selection = model;
                if (oldSelection != null) {
                    oldSelection.setSelected(false);
                }
                model.setSelected(true);
            }
        } else if (this.selection != null) {
            ButtonModel oldSelection = this.selection;
            this.selection = null;
            oldSelection.setSelected(false);
        }
    }

    @Override
    public boolean isSelected(ButtonModel model) {
        return model == this.selection;
    }

    @Override
    public int getButtonCount() {
        return this.buttons.size();
    }
}

