/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.api;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import ModernDocking.exception.DockingLayoutException;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockingInternal;
import ModernDocking.layouts.ApplicationLayout;
import ModernDocking.layouts.DockingLayouts;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Timer;

public class AppStateAPI {
    private static final Logger logger = Logger.getLogger(AppStateAPI.class.getPackageName());
    private static final int PERSIST_TIMER_DELAY_MS = 500;
    private static boolean autoPersist = false;
    private static final Map<DockingAPI, File> autoPersistFiles = new HashMap<DockingAPI, File>();
    private static ApplicationLayout defaultAppLayout = null;
    private static boolean paused = false;
    private static Timer persistTimer = null;
    private final DockingAPI docking;

    protected AppStateAPI(DockingAPI docking) {
        this.docking = docking;
    }

    public void setAutoPersist(boolean autoPersist) {
        AppStateAPI.autoPersist = autoPersist;
    }

    public boolean isAutoPersist() {
        return autoPersist;
    }

    public void setPersistFile(File file) {
        autoPersistFiles.put(this.docking, file);
    }

    public File getPersistFile() {
        return autoPersistFiles.get(this.docking);
    }

    public void setPaused(boolean paused) {
        AppStateAPI.paused = paused;
    }

    public boolean isPaused() {
        return paused;
    }

    public void persist() {
        if (!autoPersist || paused) {
            return;
        }
        if (persistTimer == null) {
            persistTimer = new Timer(500, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!paused) {
                        ApplicationLayout layout = AppStateAPI.this.docking.getDockingState().getApplicationLayout();
                        try {
                            AppStateAPI.this.docking.getLayoutPersistence().saveLayoutToFile((File)autoPersistFiles.get(AppStateAPI.this.docking), layout);
                            DockingLayouts.layoutPersisted(layout);
                            logger.log(Level.INFO, "ModernDocking: Persisted Layout Successfully");
                        }
                        catch (DockingLayoutException ex) {
                            logger.log(Level.INFO, ex.getMessage(), ex);
                        }
                    }
                    persistTimer = null;
                }
            });
            persistTimer.setRepeats(false);
            persistTimer.setCoalesce(false);
            persistTimer.start();
        } else {
            persistTimer.restart();
        }
    }

    public boolean restore() throws DockingLayoutException {
        if (!autoPersistFiles.containsKey(this.docking) || !autoPersistFiles.get(this.docking).exists()) {
            if (defaultAppLayout != null) {
                this.docking.getDockingState().restoreApplicationLayout(defaultAppLayout);
            }
            return false;
        }
        try {
            this.setPaused(true);
            ApplicationLayout layout = this.docking.getLayoutPersistence().loadApplicationLayoutFromFile(autoPersistFiles.get(this.docking));
            this.docking.getDockingState().restoreApplicationLayout(layout);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (defaultAppLayout != null) {
                this.docking.getDockingState().restoreApplicationLayout(defaultAppLayout);
            }
            if (e instanceof DockingLayoutException) {
                throw e;
            }
            throw new DockingLayoutException(e);
        }
        finally {
            this.setPaused(false);
        }
    }

    public void setDefaultApplicationLayout(ApplicationLayout layout) {
        defaultAppLayout = layout;
    }

    public String getProperty(Dockable dockable, String propertyName) {
        DockableWrapper wrapper = DockingInternal.get(this.docking).getWrapper(dockable);
        return wrapper.getProperty(propertyName);
    }

    public void setProperty(Dockable dockable, String propertyName, String value) {
        DockableWrapper wrapper = DockingInternal.get(this.docking).getWrapper(dockable);
        wrapper.setProperty(propertyName, value);
    }

    public void removeProperty(Dockable dockable, String propertyName) {
        DockableWrapper wrapper = DockingInternal.get(this.docking).getWrapper(dockable);
        wrapper.removeProperty(propertyName);
    }
}

