/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.api;

import ModernDocking.Dockable;
import ModernDocking.DockableStyle;
import ModernDocking.DockingRegion;
import ModernDocking.api.AppStateAPI;
import ModernDocking.api.DockingStateAPI;
import ModernDocking.api.LayoutPersistenceAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.event.DockingListener;
import ModernDocking.event.MaximizeListener;
import ModernDocking.exception.DockableRegistrationFailureException;
import ModernDocking.exception.NotDockedException;
import ModernDocking.floating.FloatListener;
import ModernDocking.internal.ActiveDockableHighlighter;
import ModernDocking.internal.AppStatePersister;
import ModernDocking.internal.DisplayPanel;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.internal.DockingComponentUtils;
import ModernDocking.internal.DockingInternal;
import ModernDocking.internal.DockingListeners;
import ModernDocking.internal.DockingPanel;
import ModernDocking.internal.FloatingFrame;
import ModernDocking.layouts.WindowLayout;
import ModernDocking.ui.ToolbarLocation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DockingAPI {
    private final DockingInternal internals = new DockingInternal(this);
    private Window mainWindow;
    private final ActiveDockableHighlighter activeDockableHighlighter = new ActiveDockableHighlighter(this);
    private final AppStatePersister appStatePersister = new AppStatePersister(this);
    private final Map<Window, RootDockingPanelAPI> rootPanels = new HashMap<Window, RootDockingPanelAPI>();
    private final AppStateAPI appState = new AppStateAPI(this);
    private final DockingStateAPI dockingState = new DockingStateAPI(this);
    private final LayoutPersistenceAPI layoutPersistence = new LayoutPersistenceAPI(this);
    private final PropertyChangeListener propertyChangeListener = e -> {
        if ("lookAndFeel".equals(e.getPropertyName())) {
            SwingUtilities.invokeLater(this.internals::updateLAF);
        }
    };
    private boolean deregistering = false;

    public AppStateAPI getAppState() {
        return this.appState;
    }

    public DockingStateAPI getDockingState() {
        return this.dockingState;
    }

    public LayoutPersistenceAPI getLayoutPersistence() {
        return this.layoutPersistence;
    }

    protected DockingAPI(Window mainWindow) {
        this.mainWindow = mainWindow;
        UIManager.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void uninitialize() {
        this.deregisterAllDockables();
        this.deregisterAllDockingPanels();
        this.mainWindow = null;
        this.activeDockableHighlighter.removeListeners();
        UIManager.removePropertyChangeListener(this.propertyChangeListener);
        DockingInternal.remove(this);
    }

    public Map<Window, RootDockingPanelAPI> getRootPanels() {
        return this.rootPanels;
    }

    public Window getMainWindow() {
        return this.mainWindow;
    }

    public void registerDockable(Dockable dockable) {
        this.internals.registerDockable(dockable);
    }

    public boolean isDockableRegistered(String persistentID) {
        return this.getDockables().stream().anyMatch(dockable -> Objects.equals(persistentID, dockable.getPersistentID()));
    }

    public void deregisterDockable(Dockable dockable) {
        this.deregistering = true;
        try {
            this.undock(dockable);
            this.internals.deregisterDockable(dockable);
        }
        finally {
            this.deregistering = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAllDockables() {
        this.deregistering = true;
        try {
            HashSet<Window> windows = new HashSet<Window>(this.getRootPanels().keySet());
            for (Window window : windows) {
                DockingComponentUtils.undockComponents(this, window);
                if (!(window instanceof FloatingFrame)) continue;
                window.dispose();
            }
            for (Dockable dockable : this.internals.getDockables()) {
                this.deregisterDockable(dockable);
            }
        }
        finally {
            this.deregistering = false;
        }
    }

    public List<Dockable> getDockables() {
        return this.internals.getDockables();
    }

    public void registerDockingPanel(RootDockingPanelAPI panel, JFrame parent) {
        if (this.rootPanels.containsKey(parent)) {
            throw new DockableRegistrationFailureException("RootDockingPanel already registered for frame: " + parent);
        }
        if (this.rootPanels.containsValue(panel)) {
            Window window = this.rootPanels.entrySet().stream().filter(entry -> entry.getValue() == panel).findFirst().map(Map.Entry::getKey).get();
            throw new DockableRegistrationFailureException("RootDockingPanel already registered for window: " + window);
        }
        this.rootPanels.put(parent, panel);
        FloatListener.registerDockingWindow(this, parent, panel);
        this.appStatePersister.addWindow(parent);
    }

    public void registerDockingPanel(RootDockingPanelAPI panel, JDialog parent) {
        if (this.rootPanels.containsKey(parent)) {
            throw new DockableRegistrationFailureException("RootDockingPanel already registered for frame: " + parent);
        }
        if (this.rootPanels.containsValue(panel)) {
            Window window = this.rootPanels.entrySet().stream().filter(entry -> entry.getValue() == panel).findFirst().map(Map.Entry::getKey).get();
            throw new DockableRegistrationFailureException("RootDockingPanel already registered for window: " + window);
        }
        this.rootPanels.put(parent, panel);
        FloatListener.registerDockingWindow(this, parent, panel);
        this.appStatePersister.addWindow(parent);
    }

    public void deregisterDockingPanel(Window parent) {
        if (this.rootPanels.containsKey(parent)) {
            RootDockingPanelAPI root = this.rootPanels.get(parent);
            DockingComponentUtils.undockComponents(this, root);
        }
        this.rootPanels.remove(parent);
        FloatListener.deregisterDockingWindow(parent);
        this.appStatePersister.removeWindow(parent);
    }

    public void deregisterAllDockingPanels() {
        HashSet<Window> windows = new HashSet<Window>(this.getRootPanels().keySet());
        for (Window window : windows) {
            this.deregisterDockingPanel(window);
            if (!(window instanceof FloatingFrame)) continue;
            window.dispose();
        }
    }

    public void configurePinning(Window window, int layer, boolean allow) {
        if (!this.rootPanels.containsKey(window)) {
            throw new DockableRegistrationFailureException("No root panel for window has been registered.");
        }
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(this, window);
        root.setPinningSupported(allow);
        root.setPinningLayer(layer);
    }

    public boolean pinningAllowed(Dockable dockable) {
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(this, DockingComponentUtils.findWindowForDockable(this, dockable));
        return dockable.isPinningAllowed() && root.isPinningSupported();
    }

    public void dock(String persistentID, Window window) {
        this.dock(this.internals.getDockable(persistentID), window, DockingRegion.CENTER);
    }

    public void dock(Dockable dockable, Window window) {
        this.dock(dockable, window, DockingRegion.CENTER);
    }

    public void dock(String persistentID, Window window, DockingRegion region) {
        this.dock(this.internals.getDockable(persistentID), window, region, 0.25);
    }

    public void dock(Dockable dockable, Window window, DockingRegion region) {
        RootDockingPanelAPI root = this.rootPanels.get(window);
        if (root == null) {
            throw new DockableRegistrationFailureException("Window does not have a RootDockingPanel: " + window);
        }
        if (!root.isEmpty() && region == DockingRegion.CENTER) {
            return;
        }
        this.dock(dockable, window, region, 0.25);
    }

    public void dock(String persistentID, Window window, DockingRegion region, double dividerProportion) {
        this.dock(this.internals.getDockable(persistentID), window, region, dividerProportion);
    }

    public void dock(Dockable dockable, Window window, DockingRegion region, double dividerProportion) {
        RootDockingPanelAPI root = this.rootPanels.get(window);
        if (root == null) {
            throw new DockableRegistrationFailureException("Window does not have a RootDockingPanel: " + window);
        }
        if (this.isDocked(dockable)) {
            DockableWrapper wrapper = this.internals.getWrapper(dockable);
            wrapper.getParent().undock(dockable);
        }
        root.dock(dockable, region, dividerProportion);
        this.internals.getWrapper(dockable).setWindow(window);
        DockingListeners.fireDockedEvent(dockable);
        this.appState.persist();
    }

    public void dock(String sourcePersistentID, String targetPersistentID, DockingRegion region) {
        this.dock(this.internals.getDockable(sourcePersistentID), this.internals.getDockable(targetPersistentID), region, 0.5);
    }

    public void dock(String sourcePersistentID, Dockable target, DockingRegion region) {
        this.dock(this.internals.getDockable(sourcePersistentID), target, region, 0.5);
    }

    public void dock(Dockable source, String targetPersistentID, DockingRegion region) {
        this.dock(source, this.internals.getDockable(targetPersistentID), region, 0.5);
    }

    public void dock(Dockable source, Dockable target, DockingRegion region) {
        this.dock(source, target, region, 0.5);
    }

    public void dock(String sourcePersistentID, String targetPersistentID, DockingRegion region, double dividerProportion) {
        this.dock(this.internals.getDockable(sourcePersistentID), this.internals.getDockable(targetPersistentID), region, dividerProportion);
    }

    public void dock(Dockable source, Dockable target, DockingRegion region, double dividerProportion) {
        DockableWrapper wrapper;
        if (!this.isDocked(target)) {
            throw new NotDockedException(target);
        }
        if (this.isDocked(source)) {
            wrapper = this.internals.getWrapper(source);
            wrapper.getParent().undock(source);
        }
        wrapper = this.internals.getWrapper(target);
        wrapper.getParent().dock(source, region, dividerProportion);
        this.internals.getWrapper(source).setWindow(wrapper.getWindow());
        DockingListeners.fireDockedEvent(source);
        this.appState.persist();
    }

    public void newWindow(String persistentID) {
        this.newWindow(this.internals.getDockable(persistentID));
    }

    public void newWindow(Dockable dockable) {
        DisplayPanel displayPanel = this.internals.getWrapper(dockable).getDisplayPanel();
        if (this.isDocked(dockable)) {
            Point location = displayPanel.getLocationOnScreen();
            Dimension size = displayPanel.getSize();
            this.newWindow(dockable, location, size);
        } else {
            FloatingFrame frame = new FloatingFrame(this);
            this.dock(dockable, (Window)frame);
            frame.pack();
            frame.setLocationRelativeTo(this.mainWindow);
        }
    }

    public void newWindow(String persistentID, Dimension size) {
        this.newWindow(this.internals.getDockable(persistentID), size);
    }

    public void newWindow(Dockable dockable, Dimension size) {
        FloatingFrame frame = new FloatingFrame(this, dockable, new Point(0, 0), size, 0);
        this.undock(dockable);
        this.dock(dockable, (Window)frame);
        SwingUtilities.invokeLater(() -> {
            frame.setLocationRelativeTo(this.mainWindow);
            this.bringToFront(dockable);
        });
    }

    public void newWindow(String persistentID, Point location, Dimension size) {
        this.newWindow(this.internals.getDockable(persistentID), location, size);
    }

    public void newWindow(Dockable dockable, Point location, Dimension size) {
        FloatingFrame frame = new FloatingFrame(this, dockable, location, size, 0);
        this.undock(dockable);
        this.dock(dockable, (Window)frame);
        SwingUtilities.invokeLater(() -> this.bringToFront(dockable));
    }

    public void bringToFront(Dockable dockable) {
        if (!this.isDocked(dockable)) {
            throw new NotDockedException(dockable);
        }
        Window window = DockingComponentUtils.findWindowForDockable(this, dockable);
        if (window instanceof JFrame && ((JFrame)window).getState() == 1) {
            ((JFrame)window).setState(0);
        }
        window.setAlwaysOnTop(true);
        window.setAlwaysOnTop(false);
        if (this.internals.getWrapper(dockable).getParent() instanceof DockedTabbedPanel) {
            DockedTabbedPanel tabbedPanel = (DockedTabbedPanel)this.internals.getWrapper(dockable).getParent();
            tabbedPanel.bringToFront(dockable);
        }
    }

    public void undock(String persistentID) {
        this.undock(this.internals.getDockable(persistentID));
    }

    public void undock(Dockable dockable) {
        if (!this.isDocked(dockable)) {
            return;
        }
        Window window = DockingComponentUtils.findWindowForDockable(this, dockable);
        Objects.requireNonNull(window);
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(this, window);
        Objects.requireNonNull(root);
        DockableWrapper wrapper = this.internals.getWrapper(dockable);
        wrapper.setRoot(root);
        if (this.isUnpinned(dockable)) {
            root.undock(dockable);
            wrapper.setParent(null);
            wrapper.setUnpinned(false);
        } else {
            wrapper.getParent().undock(dockable);
        }
        wrapper.setWindow(null);
        DockingListeners.fireUndockedEvent(dockable);
        if (this.canDisposeWindow(window) && root.isEmpty() && !FloatListener.isFloating()) {
            this.deregisterDockingPanel(window);
            window.dispose();
        }
        this.appState.persist();
        if (!(dockable.isClosable() || FloatListener.isFloating() || this.deregistering)) {
            this.dock(dockable, this.mainWindow);
        }
    }

    public boolean isDocked(String persistentID) {
        return this.isDocked(this.internals.getDockable(persistentID));
    }

    public boolean isDocked(Dockable dockable) {
        return this.internals.getWrapper(dockable).getParent() != null;
    }

    public boolean isUnpinned(String persistentID) {
        return this.isUnpinned(this.internals.getDockable(persistentID));
    }

    public boolean isUnpinned(Dockable dockable) {
        return this.internals.getWrapper(dockable).isUnpinned();
    }

    public boolean canDisposeWindow(Window window) {
        if (window instanceof JDialog) {
            return false;
        }
        if (this.dockingState.maximizeRestoreLayout.containsKey(window)) {
            return false;
        }
        return window instanceof FloatingFrame;
    }

    public boolean isMaximized(Dockable dockable) {
        return this.internals.getWrapper(dockable).isMaximized();
    }

    public void maximize(Dockable dockable) {
        Window window = DockingComponentUtils.findWindowForDockable(this, dockable);
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(this, window);
        if (!this.dockingState.maximizeRestoreLayout.containsKey(window) && root != null) {
            this.internals.getWrapper(dockable).setMaximized(true);
            DockingListeners.fireMaximizeEvent(dockable, true);
            WindowLayout layout = this.dockingState.getWindowLayout(window);
            layout.setMaximizedDockable(dockable.getPersistentID());
            this.dockingState.maximizeRestoreLayout.put(window, layout);
            DockingComponentUtils.undockComponents(this, root);
            this.dock(dockable, window);
        }
    }

    public void minimize(Dockable dockable) {
        Window window = DockingComponentUtils.findWindowForDockable(this, dockable);
        if (this.dockingState.maximizeRestoreLayout.containsKey(window)) {
            this.internals.getWrapper(dockable).setMaximized(false);
            DockingListeners.fireMaximizeEvent(dockable, false);
            this.dockingState.restoreWindowLayout(window, this.dockingState.maximizeRestoreLayout.get(window));
            this.dockingState.maximizeRestoreLayout.remove(window);
            this.internals.fireDockedEventForFrame(window);
        }
    }

    public void pinDockable(Dockable dockable) {
        Window window = DockingComponentUtils.findWindowForDockable(this, dockable);
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(this, window);
        if (this.internals.getWrapper(dockable).isUnpinned()) {
            root.setDockablePinned(dockable);
            this.internals.getWrapper(dockable).setUnpinned(false);
            DockingListeners.firePinnedEvent(dockable);
        }
    }

    public void unpinDockable(Dockable dockable) {
        boolean south;
        if (this.isUnpinned(dockable)) {
            return;
        }
        Window window = DockingComponentUtils.findWindowForDockable(this, dockable);
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(this, window);
        Component component = (Component)((Object)dockable);
        Point posInFrame = component.getLocation();
        SwingUtilities.convertPointToScreen(posInFrame, component.getParent());
        SwingUtilities.convertPointFromScreen(posInFrame, root);
        posInFrame.x += component.getWidth() / 2;
        posInFrame.y += component.getHeight() / 2;
        boolean allowedSouth = dockable.getPinningStyle() == DockableStyle.BOTH || dockable.getPinningStyle() == DockableStyle.HORIZONTAL;
        int westDist = posInFrame.x;
        int eastDist = window.getWidth() - posInFrame.x;
        int southDist = window.getHeight() - posInFrame.y;
        boolean east = eastDist <= westDist;
        boolean bl = south = southDist < westDist && southDist < eastDist;
        ToolbarLocation location = south && allowedSouth ? ToolbarLocation.SOUTH : (east ? ToolbarLocation.EAST : ToolbarLocation.WEST);
        this.unpinDockable(dockable, location);
    }

    public void unpinDockable(Dockable dockable, ToolbarLocation location) {
        Window window = DockingComponentUtils.findWindowForDockable(this, dockable);
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(this, window);
        this.unpinDockable(dockable, location, window, root);
    }

    public void unpinDockable(Dockable dockable, ToolbarLocation location, Window window, RootDockingPanelAPI root) {
        if (this.isUnpinned(dockable)) {
            return;
        }
        Component component = (Component)((Object)dockable);
        Point posInFrame = component.getLocation();
        SwingUtilities.convertPointToScreen(posInFrame, component.getParent());
        SwingUtilities.convertPointFromScreen(posInFrame, root);
        posInFrame.x += component.getWidth() / 2;
        posInFrame.y += component.getHeight() / 2;
        if (!root.isPinningSupported()) {
            return;
        }
        this.undock(dockable);
        this.internals.getWrapper(dockable).setWindow(window);
        this.internals.getWrapper(dockable).setUnpinned(true);
        root.setDockableUnpinned(dockable, location);
        DockingListeners.fireUnpinnedEvent(dockable);
        DockingListeners.fireHiddenEvent(dockable);
    }

    public void display(String persistentID) {
        this.display(this.internals.getDockable(persistentID));
    }

    public void display(Dockable dockable) {
        if (this.isDocked(dockable)) {
            this.bringToFront(dockable);
        } else {
            Optional<Dockable> firstOfType = DockingComponentUtils.findFirstDockableOfType(this, dockable.getType());
            if (firstOfType.isPresent()) {
                this.dock(dockable, firstOfType.get(), DockingRegion.CENTER);
            } else {
                this.dock(dockable, this.mainWindow, DockingRegion.NORTH);
            }
        }
    }

    public void updateTabInfo(String persistentID) {
        this.updateTabInfo(this.internals.getDockable(persistentID));
    }

    public void updateTabInfo(Dockable dockable) {
        if (!this.isDocked(dockable)) {
            return;
        }
        DockableWrapper wrapper = this.internals.getWrapper(dockable);
        wrapper.getHeaderUI().update();
        DockingPanel parent = wrapper.getParent();
        if (parent instanceof DockedTabbedPanel) {
            ((DockedTabbedPanel)parent).updateTabInfo(dockable);
        }
    }

    public void addMaximizeListener(MaximizeListener listener) {
        DockingListeners.addMaximizeListener(listener);
    }

    public void removeMaximizeListener(MaximizeListener listener) {
        DockingListeners.removeMaximizeListener(listener);
    }

    public void addDockingListener(DockingListener listener) {
        DockingListeners.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        DockingListeners.removeDockingListener(listener);
    }
}

