/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.api;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.exception.DockableNotFoundException;
import ModernDocking.exception.DockableRegistrationFailureException;
import ModernDocking.internal.DockableProperties;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockedSimplePanel;
import ModernDocking.internal.DockedSplitPanel;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.internal.DockingComponentUtils;
import ModernDocking.internal.DockingInternal;
import ModernDocking.internal.DockingPanel;
import ModernDocking.internal.FailedDockable;
import ModernDocking.internal.FloatingFrame;
import ModernDocking.layouts.ApplicationLayout;
import ModernDocking.layouts.DockingLayoutNode;
import ModernDocking.layouts.DockingLayouts;
import ModernDocking.layouts.DockingSimplePanelNode;
import ModernDocking.layouts.DockingSplitPanelNode;
import ModernDocking.layouts.DockingTabPanelNode;
import ModernDocking.layouts.WindowLayout;
import ModernDocking.persist.DockableState;
import ModernDocking.persist.PanelState;
import ModernDocking.persist.RootDockState;
import ModernDocking.persist.SplitState;
import ModernDocking.persist.TabState;
import ModernDocking.ui.ToolbarLocation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class DockingStateAPI {
    private static final Logger logger = Logger.getLogger(DockingStateAPI.class.getPackageName());
    public final Map<Window, WindowLayout> maximizeRestoreLayout = new HashMap<Window, WindowLayout>();
    private final DockingAPI docking;

    protected DockingStateAPI(DockingAPI docking) {
        this.docking = docking;
    }

    public RootDockState getRootState(Window window) {
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(this.docking, window);
        if (root == null) {
            throw new RuntimeException("Root for window does not exist: " + window);
        }
        return new RootDockState(root);
    }

    public WindowLayout getWindowLayout(Window window) {
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(this.docking, window);
        if (root == null) {
            throw new RuntimeException("Root for frame does not exist: " + window);
        }
        WindowLayout maxLayout = this.maximizeRestoreLayout.get(window);
        if (maxLayout != null) {
            return maxLayout;
        }
        return DockingLayouts.layoutFromRoot(this.docking, root);
    }

    public ApplicationLayout getApplicationLayout() {
        ApplicationLayout layout = new ApplicationLayout();
        layout.setMainFrame(this.getWindowLayout(this.docking.getMainWindow()));
        for (Window frame : this.docking.getRootPanels().keySet()) {
            if (frame == this.docking.getMainWindow()) continue;
            layout.addFrame(this.getWindowLayout(frame));
        }
        return layout;
    }

    public void restoreApplicationLayout(ApplicationLayout layout) {
        HashSet<Window> windows = new HashSet<Window>(this.docking.getRootPanels().keySet());
        for (Window window : windows) {
            DockingComponentUtils.undockComponents(this.docking, window);
            if (!(window instanceof FloatingFrame)) continue;
            window.dispose();
        }
        this.docking.getAppState().setPaused(true);
        this.restoreWindowLayout(this.docking.getMainWindow(), layout.getMainFrameLayout());
        for (WindowLayout frameLayout : layout.getFloatingFrameLayouts()) {
            FloatingFrame frame = new FloatingFrame(this.docking, frameLayout.getLocation(), frameLayout.getSize(), frameLayout.getState());
            this.restoreWindowLayout(frame, frameLayout);
        }
        this.docking.getAppState().setPaused(false);
        this.docking.getAppState().persist();
        DockingInternal.fireDockedEventForAll(this.docking);
        DockingLayouts.layoutRestored(layout);
    }

    public void restoreWindowLayout(Window window, WindowLayout layout) {
        Dockable dockable;
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(this.docking, window);
        if (root == null) {
            throw new RuntimeException("Root for window does not exist: " + window);
        }
        if (layout.hasSizeAndLocationInformation()) {
            window.setLocation(layout.getLocation());
            window.setSize(layout.getSize());
            if (window instanceof JFrame) {
                ((JFrame)window).setExtendedState(layout.getState());
            }
        }
        DockingComponentUtils.undockComponents(this.docking, root);
        root.setPanel(this.restoreState(this.docking, layout.getRootNode(), window));
        this.undockFailedComponents(this.docking, root);
        this.restoreProperSplitLocations(root);
        for (String id : layout.getWestUnpinnedToolbarIDs()) {
            dockable = this.getDockable(this.docking, id);
            root.setDockableUnpinned(dockable, ToolbarLocation.WEST);
            root.hideUnpinnedPanels();
            this.getWrapper(dockable).setUnpinned(true);
        }
        for (String id : layout.getEastUnpinnedToolbarIDs()) {
            dockable = this.getDockable(this.docking, id);
            root.setDockableUnpinned(dockable, ToolbarLocation.EAST);
            root.hideUnpinnedPanels();
            this.getWrapper(dockable).setUnpinned(true);
        }
        for (String id : layout.getSouthUnpinnedToolbarIDs()) {
            dockable = this.getDockable(this.docking, id);
            root.setDockableUnpinned(dockable, ToolbarLocation.SOUTH);
            root.hideUnpinnedPanels();
            this.getWrapper(dockable).setUnpinned(true);
        }
        if (layout.getMaximizedDockable() != null) {
            this.docking.maximize(this.getDockable(this.docking, layout.getMaximizedDockable()));
        }
    }

    private void findSplitPanels(Container container, List<DockedSplitPanel> panels) {
        for (Component component : container.getComponents()) {
            if (component instanceof DockedSplitPanel) {
                panels.add((DockedSplitPanel)component);
            }
            if (!(component instanceof Container)) continue;
            this.findSplitPanels((Container)component, panels);
        }
    }

    public void restoreWindowLayout_PreserveSizeAndPos(Window window, WindowLayout layout) {
        Point location = window.getLocation();
        Dimension size = window.getSize();
        this.restoreWindowLayout(window, layout);
        window.setLocation(location);
        window.setSize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState(Window window, RootDockState state) {
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(this.docking, window);
        if (root == null) {
            throw new RuntimeException("Root for window does not exist: " + window);
        }
        DockingComponentUtils.undockComponents(this.docking, root);
        boolean paused = this.docking.getAppState().isPaused();
        this.docking.getAppState().setPaused(true);
        try {
            root.setPanel(this.restoreState(this.docking, state.getState(), window));
            this.restoreProperSplitLocations(root);
        }
        finally {
            this.docking.getAppState().setPaused(paused);
        }
        if (!paused) {
            this.docking.getAppState().persist();
        }
    }

    private DockingPanel restoreState(DockingAPI docking, DockableState state, Window window) {
        if (state instanceof PanelState) {
            return this.restoreSimple(docking, (PanelState)state, window);
        }
        if (state instanceof SplitState) {
            return this.restoreSplit(docking, (SplitState)state, window);
        }
        if (state instanceof TabState) {
            return this.restoreTabbed(docking, (TabState)state, window);
        }
        throw new RuntimeException("Unknown state type");
    }

    private DockedSplitPanel restoreSplit(DockingAPI docking, SplitState state, Window window) {
        DockedSplitPanel panel = new DockedSplitPanel(docking, window);
        panel.setLeft(this.restoreState(docking, state.getLeft(), window));
        panel.setRight(this.restoreState(docking, state.getRight(), window));
        panel.setOrientation(state.getOrientation());
        panel.setDividerLocation(state.getDividerProprtion());
        return panel;
    }

    private DockedTabbedPanel restoreTabbed(DockingAPI docking, TabState state, Window window) {
        DockedTabbedPanel panel = null;
        for (String persistentID : state.getPersistentIDs()) {
            Dockable dockable = this.getDockable(docking, persistentID);
            if (dockable == null) {
                throw new DockableNotFoundException(persistentID);
            }
            docking.undock(dockable);
            DockableWrapper wrapper = DockingInternal.get(docking).getWrapper(dockable);
            wrapper.setWindow(window);
            if (panel == null) {
                panel = new DockedTabbedPanel(docking, wrapper);
                continue;
            }
            panel.addPanel(wrapper);
        }
        if (panel == null) {
            throw new RuntimeException("DockedTabbedPanel has no tabs");
        }
        return panel;
    }

    private DockedSimplePanel restoreSimple(DockingAPI docking, PanelState state, Window window) {
        Dockable dockable = this.getDockable(docking, state.getPersistentID());
        if (dockable instanceof FailedDockable) {
            try {
                Class<?> aClass = Class.forName(state.getClassName());
                Constructor<?> constructor = aClass.getConstructor(String.class, String.class);
                docking.deregisterDockable(dockable);
                constructor.newInstance(state.getPersistentID(), state.getPersistentID());
                dockable = this.getDockable(docking, state.getPersistentID());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.log(Level.INFO, e.getMessage(), e);
            }
        }
        if (dockable == null) {
            throw new DockableNotFoundException(state.getPersistentID());
        }
        docking.undock(dockable);
        DockableWrapper wrapper = DockingInternal.get(docking).getWrapper(dockable);
        wrapper.setWindow(window);
        return new DockedSimplePanel(docking, wrapper);
    }

    private DockingPanel restoreState(DockingAPI docking, DockingLayoutNode node, Window window) {
        if (node instanceof DockingSimplePanelNode) {
            return this.restoreSimple(docking, (DockingSimplePanelNode)node, window);
        }
        if (node instanceof DockingSplitPanelNode) {
            return this.restoreSplit(docking, (DockingSplitPanelNode)node, window);
        }
        if (node instanceof DockingTabPanelNode) {
            return this.restoreTabbed(docking, (DockingTabPanelNode)node, window);
        }
        if (node == null) {
            return null;
        }
        throw new RuntimeException("Unknown state type");
    }

    private DockedSplitPanel restoreSplit(DockingAPI docking, DockingSplitPanelNode node, Window window) {
        DockedSplitPanel panel = new DockedSplitPanel(docking, window);
        panel.setLeft(this.restoreState(docking, node.getLeft(), window));
        panel.setRight(this.restoreState(docking, node.getRight(), window));
        panel.setOrientation(node.getOrientation());
        panel.setDividerLocation(node.getDividerProportion());
        return panel;
    }

    private DockedTabbedPanel restoreTabbed(DockingAPI docking, DockingTabPanelNode node, Window window) {
        DockedTabbedPanel panel = null;
        for (DockingSimplePanelNode simpleNode : node.getPersistentIDs()) {
            Dockable dockable = this.getDockable(docking, simpleNode.getPersistentID());
            if (dockable == null) {
                throw new DockableNotFoundException(simpleNode.getPersistentID());
            }
            DockableWrapper wrapper = DockingInternal.get(docking).getWrapper(dockable);
            DockableProperties.configureProperties(wrapper, simpleNode.getProperties());
            docking.undock(dockable);
            wrapper.setWindow(window);
            if (panel == null) {
                panel = new DockedTabbedPanel(docking, wrapper);
                continue;
            }
            panel.addPanel(wrapper);
        }
        if (panel == null) {
            throw new RuntimeException("DockedTabbedPanel has no tabs");
        }
        if (!node.getSelectedTabID().isEmpty()) {
            panel.bringToFront(this.getDockable(docking, node.getSelectedTabID()));
        }
        return panel;
    }

    private DockedSimplePanel restoreSimple(DockingAPI docking, DockingSimplePanelNode node, Window window) {
        Dockable dockable = this.getDockable(docking, node.getPersistentID());
        if (dockable instanceof FailedDockable) {
            try {
                Class<?> aClass = Class.forName(node.getClassName());
                Constructor<?> constructor = aClass.getConstructor(String.class, String.class);
                docking.deregisterDockable(dockable);
                constructor.newInstance(node.getPersistentID(), node.getPersistentID());
                dockable = this.getDockable(docking, node.getPersistentID());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.log(Level.INFO, e.getMessage(), e);
            }
        }
        if (dockable == null) {
            throw new DockableNotFoundException(node.getPersistentID());
        }
        DockableWrapper wrapper = DockingInternal.get(docking).getWrapper(dockable);
        DockableProperties.configureProperties(wrapper, node.getProperties());
        docking.undock(dockable);
        wrapper.setWindow(window);
        return new DockedSimplePanel(docking, wrapper);
    }

    private Dockable getDockable(DockingAPI docking, String persistentID) {
        try {
            return DockingInternal.get(docking).getDockable(persistentID);
        }
        catch (DockableRegistrationFailureException dockableRegistrationFailureException) {
            return new FailedDockable(docking, persistentID);
        }
    }

    private DockableWrapper getWrapper(Dockable dockable) {
        return DockingInternal.get(this.docking).getWrapper(dockable);
    }

    private void undockFailedComponents(DockingAPI docking, Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof FailedDockable) {
                FailedDockable dockable = (FailedDockable)component;
                docking.undock(this.getDockable(docking, dockable.getPersistentID()));
                dockable.destroy();
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.undockFailedComponents(docking, (Container)component);
        }
    }

    private void restoreProperSplitLocations(RootDockingPanelAPI root) {
        SwingUtilities.invokeLater(() -> {
            ArrayList<DockedSplitPanel> splitPanels = new ArrayList<DockedSplitPanel>();
            this.findSplitPanels(root, splitPanels);
            ArrayList<JSplitPane> splits = new ArrayList<JSplitPane>();
            ArrayList<Double> proportions = new ArrayList<Double>();
            for (DockedSplitPanel splitPanel : splitPanels) {
                splits.add(splitPanel.getSplitPane());
                proportions.add(splitPanel.getLastRequestedDividerProportion());
            }
            this.restoreSplits(splits, proportions);
        });
    }

    private void restoreSplits(List<JSplitPane> splits, List<Double> proportions) {
        if (splits.size() != proportions.size()) {
            return;
        }
        if (splits.isEmpty()) {
            return;
        }
        JSplitPane splitPane = splits.get(0);
        double proportion = proportions.get(0);
        splits.remove(0);
        proportions.remove(0);
        this.restoreSplit(splitPane, proportion, splits, proportions);
    }

    private void restoreSplit(final JSplitPane splitPane, final double proportion, final List<JSplitPane> splits, final List<Double> proportions) {
        if (splitPane.isShowing()) {
            if (splitPane.getWidth() > 0 && splitPane.getHeight() > 0) {
                splitPane.setDividerLocation(proportion);
                if (!splits.isEmpty()) {
                    SwingUtilities.invokeLater(() -> {
                        JSplitPane nextSplit = (JSplitPane)splits.get(0);
                        double nextProportion = (Double)proportions.get(0);
                        splits.remove(0);
                        proportions.remove(0);
                        this.restoreSplit(nextSplit, nextProportion, splits, proportions);
                    });
                }
            } else {
                splitPane.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        splitPane.removeComponentListener(this);
                        DockingStateAPI.this.restoreSplit(splitPane, proportion, splits, proportions);
                    }
                });
            }
        } else {
            splitPane.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    boolean isShowingChangeEvent;
                    boolean bl = isShowingChangeEvent = (e.getChangeFlags() & 4L) != 0L;
                    if (isShowingChangeEvent && splitPane.isShowing()) {
                        splitPane.removeHierarchyListener(this);
                        DockingStateAPI.this.restoreSplit(splitPane, proportion, splits, proportions);
                    }
                }
            });
        }
    }
}

