/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.floating;

import ModernDocking.DockingRegion;
import ModernDocking.ui.DockingSettings;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JLabel;

public class DockingHandle
extends JLabel {
    public static final int HANDLE_ICON_SIZE = 32;
    private final DockingRegion region;
    private final boolean isRoot;
    private final boolean isPin;

    public DockingHandle(DockingRegion region, boolean isRoot) {
        this.region = region;
        this.isRoot = isRoot;
        this.isPin = false;
        this.setBounds(0, 0, 32, 32);
        this.setVisible(false);
    }

    public DockingHandle(DockingRegion region) {
        this.region = region;
        this.isRoot = false;
        this.isPin = true;
        this.setBounds(0, 0, 32, 32);
        this.setVisible(false);
    }

    public DockingRegion getRegion() {
        return this.region;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isPin() {
        return this.isPin;
    }

    public void paintHandle(Graphics g, Graphics2D g2, boolean mouseOver) {
        int x1;
        int quarterWidth;
        Rectangle bounds = this.getBounds();
        Color background = DockingSettings.getHandleBackground();
        Color hover = DockingSettings.getHandleForeground();
        Color outline = DockingSettings.getHandleForeground();
        if (this.isRoot || this.isPin) {
            g.setColor(background);
            this.drawBackground(g);
        }
        if (mouseOver && this.isPin) {
            quarterWidth = bounds.width / 4;
            x1 = this.getX() + quarterWidth;
            g.fillRect(x1, bounds.y, bounds.width / 2, bounds.height / 2);
        } else if (mouseOver) {
            g.setColor(hover);
            this.fillMouseOverRegion(g);
        }
        g.setColor(outline);
        g2.setColor(outline);
        if (this.region != DockingRegion.CENTER && !this.isRoot && !this.isPin) {
            this.drawDashedLine(g2);
        }
        if (this.isRoot && this.region != DockingRegion.CENTER) {
            this.drawRootOutline(g);
        } else if (this.isPin) {
            quarterWidth = bounds.width / 4;
            x1 = this.getX() + quarterWidth;
            g.drawLine(x1, bounds.y, x1 + bounds.width / 2, bounds.y);
            g.drawLine(x1, bounds.y + bounds.height / 2, x1 + bounds.width / 2, bounds.y + bounds.height / 2);
            g.drawLine(x1, bounds.y, x1, bounds.y + bounds.height / 2);
            g.drawLine(x1 + bounds.width / 2, bounds.y, x1 + bounds.width / 2, bounds.y + bounds.height / 2);
            g.drawLine(x1 + quarterWidth, bounds.y + bounds.height / 2, x1 + quarterWidth, bounds.y + bounds.height);
        } else {
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    private void drawBackground(Graphics g) {
        int spacing = 8;
        int x = this.getX() - spacing;
        int y = this.getY() - spacing;
        int width = this.getWidth() + spacing * 2;
        int height = this.getHeight() + spacing * 2;
        g.fillRect(x, y, width, height);
        Color border = DockingSettings.getHandleForeground();
        g.setColor(border);
        g.drawRect(x, y, width, height);
    }

    private void drawRootOutline(Graphics g) {
        int height;
        Rectangle bounds = this.getBounds();
        boolean north = this.region == DockingRegion.NORTH;
        boolean south = this.region == DockingRegion.SOUTH;
        boolean east = this.region == DockingRegion.EAST;
        int halfWidth = bounds.width / 2;
        int x = east ? bounds.x + halfWidth : bounds.x;
        int y = south ? bounds.y + halfWidth : bounds.y;
        int width = north || south ? bounds.width : halfWidth;
        int n = height = north || south ? halfWidth : bounds.height;
        if (this.region == DockingRegion.CENTER) {
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        } else {
            g.drawRect(x, y, width, height);
        }
    }

    private void fillMouseOverRegion(Graphics g) {
        int height;
        Rectangle bounds = this.getBounds();
        boolean north = this.region == DockingRegion.NORTH;
        boolean south = this.region == DockingRegion.SOUTH;
        boolean east = this.region == DockingRegion.EAST;
        int halfWidth = bounds.width / 2;
        int x = east ? bounds.x + halfWidth : bounds.x;
        int y = south ? bounds.y + halfWidth : bounds.y;
        int width = north || south ? bounds.width : halfWidth;
        int n = height = north || south ? halfWidth : bounds.height;
        if (this.region == DockingRegion.CENTER) {
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        } else {
            g.fillRect(x, y, width, height);
        }
    }

    private void drawDashedLine(Graphics2D g2) {
        int y2;
        Rectangle bounds = this.getBounds();
        boolean north = this.region == DockingRegion.NORTH;
        boolean south = this.region == DockingRegion.SOUTH;
        int halfWidth = bounds.width / 2;
        int x = north || south ? bounds.x : bounds.x + halfWidth;
        int y = north || south ? bounds.y + halfWidth : bounds.y;
        int x2 = north || south ? bounds.x + bounds.width : bounds.x + halfWidth;
        int n = y2 = north || south ? bounds.y + halfWidth : bounds.y + bounds.height;
        if (this.region == DockingRegion.CENTER) {
            g2.drawLine(bounds.x, bounds.y, bounds.width, bounds.height);
        } else {
            g2.drawLine(x, y, x2, y2);
        }
    }
}

