/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.floating;

import ModernDocking.Dockable;
import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.floating.DockingHandles;
import ModernDocking.floating.DockingOverlay;
import ModernDocking.ui.ToolbarLocation;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DockingUtilsFrame
extends JFrame
implements ComponentListener,
WindowListener {
    private final DockingHandles handles;
    private final DockingOverlay overlay;
    private final Window referenceDockingWindow;
    private boolean overTab = false;

    public DockingUtilsFrame(DockingAPI docking, Window referenceDockingWindow, RootDockingPanelAPI root) {
        this.setLayout(null);
        this.setUndecorated(true);
        this.setType(Window.Type.UTILITY);
        this.setDefaultCloseOperation(2);
        this.setBackground(new Color(0, 0, 0, 0));
        this.getRootPane().setBackground(new Color(0, 0, 0, 0));
        this.getContentPane().setBackground(new Color(0, 0, 0, 0));
        try {
            if (this.getContentPane() instanceof JComponent) {
                ((JComponent)this.getContentPane()).setOpaque(false);
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.referenceDockingWindow = referenceDockingWindow;
        this.handles = new DockingHandles(this, root);
        this.overlay = new DockingOverlay(docking, this, root);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.referenceDockingWindow.addComponentListener(this);
        this.referenceDockingWindow.addWindowListener(this);
        SwingUtilities.invokeLater(this::setSizeAndLocation);
    }

    @Override
    public void removeNotify() {
        this.referenceDockingWindow.removeComponentListener(this);
        this.referenceDockingWindow.removeWindowListener(this);
        super.removeNotify();
    }

    public void setTargetDockable(Dockable target) {
        if (!this.handles.isMouseOverHandle()) {
            this.handles.setTarget(target);
            this.overlay.setTargetDockable(target);
        }
        this.overlay.setTargetRootRegion(this.handles.getRootRegion());
        this.overlay.setTargetDockableRegion(this.handles.getDockableRegion());
        this.overlay.setTargetPinRegion(this.handles.getPinningRegion());
    }

    public void setFloating(JPanel floating) {
        this.handles.setFloating(floating);
        this.overlay.setFloating(floating);
    }

    public void setOverTab(boolean overTab, Rectangle rect, boolean last) {
        this.overTab = overTab;
        this.overlay.setTargetDockableRegion(overTab ? DockingRegion.CENTER : null);
        this.handles.overTab = overTab;
        this.overlay.setOverTab(overTab);
        this.overlay.targetTab = rect;
        this.overlay.beforeTab = !last;
    }

    public void update(Point screenPos) {
        this.handles.update(screenPos);
        this.overlay.update(screenPos);
    }

    public void setActive(boolean active) {
        this.handles.setActive(active);
        this.overlay.setActive(active);
    }

    public DockingRegion getRegion(Point screenPos) {
        return this.overlay.getRegion(screenPos);
    }

    public ToolbarLocation getToolbarLocation() {
        return this.overlay.getToolbarLocation();
    }

    public boolean isDockingToRoot() {
        return this.overlay.isDockingToRoot();
    }

    public boolean isDockingToPin() {
        return this.overlay.isDockingToPin();
    }

    public boolean isDockingToDockable() {
        return this.overlay.isDockingToDockable();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        SwingUtilities.invokeLater(this::setSizeAndLocation);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        SwingUtilities.invokeLater(this::setSizeAndLocation);
    }

    @Override
    public void componentShown(ComponentEvent e) {
        SwingUtilities.invokeLater(this::setSizeAndLocation);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.overTab) {
            this.handles.paint(g);
        }
        this.overlay.paint(g);
    }

    private void setSizeAndLocation() {
        int padding = 56;
        Point location = new Point(this.referenceDockingWindow.getLocationOnScreen());
        Dimension size = new Dimension(this.referenceDockingWindow.getSize());
        location.x -= padding;
        location.y -= padding;
        size.width += padding * 2;
        size.height += padding * 2;
        this.setLocation(location);
        this.setSize(size);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

