/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.exception.DockableRegistrationFailureException;
import ModernDocking.internal.DockedSimplePanel;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.internal.DockingComponentUtils;
import ModernDocking.internal.DockingInternal;
import ModernDocking.internal.DockingPanel;
import ModernDocking.ui.DockingSettings;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ActiveDockableHighlighter {
    private final AWTEventListener awtEventListener = e -> {
        Dockable dockable;
        if (e.getID() == 504 || e.getID() == 505) {
            DockingPanel dockable2 = DockingComponentUtils.findDockingPanelAtScreenPos(docking, ((MouseEvent)e).getLocationOnScreen());
            if (this.activePanel != null && dockable2 == null) {
                ActiveDockableHighlighter.setNotSelectedBorder(this.activePanel);
                this.activePanel = null;
            }
            if (this.activePanel != dockable2 && (dockable2 instanceof DockedSimplePanel || dockable2 instanceof DockedTabbedPanel)) {
                if (this.activePanel != null) {
                    ActiveDockableHighlighter.setNotSelectedBorder(this.activePanel);
                }
                this.activePanel = dockable2;
                this.setSelectedBorder();
            }
        } else if (e.getID() == 501 && (dockable = DockingComponentUtils.findDockableAtScreenPos(docking, ((MouseEvent)e).getLocationOnScreen())) != null) {
            Window window = DockingComponentUtils.findWindowForDockable(docking, dockable);
            if (!DockingInternal.get(docking).getWrapper(dockable).isUnpinned()) {
                try {
                    RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(docking, window);
                    root.hideUnpinnedPanels();
                }
                catch (DockableRegistrationFailureException dockableRegistrationFailureException) {
                    // empty catch block
                }
            }
        }
    };
    private final PropertyChangeListener propertyChangeListener;
    private DockingPanel activePanel = null;

    public ActiveDockableHighlighter(DockingAPI docking) {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListener, 16L);
        this.propertyChangeListener = e -> {
            if ("lookAndFeel".equals(e.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.activePanel != null) {
                        this.setSelectedBorder();
                    }
                });
            }
        };
        UIManager.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void removeListeners() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
        UIManager.removePropertyChangeListener(this.propertyChangeListener);
    }

    private void setSelectedBorder() {
        Color color = DockingSettings.getHighlighterSelectedBorder();
        this.activePanel.setBorder(BorderFactory.createLineBorder(color, 2));
    }

    public static void setNotSelectedBorder(DockingPanel panel) {
        Color color = DockingSettings.getHighlighterNotSelectedBorder();
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(color, 1)));
    }
}

