/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.settings.Settings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DisplayPanel
extends JPanel {
    private final DockableWrapper wrapper;

    public DisplayPanel(DockableWrapper wrapper) {
        this.wrapper = wrapper;
        this.setLayout(new GridBagLayout());
        this.buildUI();
    }

    private void buildUI() {
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        if (!(Settings.alwaysDisplayTabsMode(this.wrapper.getDockable()) && !this.wrapper.isUnpinned() || this.wrapper.getParent() instanceof DockedTabbedPanel && !((DockedTabbedPanel)this.wrapper.getParent()).isUsingBottomTabs())) {
            this.add((Component)((Object)this.wrapper.getHeaderUI()), gbc);
            ++gbc.gridy;
        }
        gbc.weighty = 1.0;
        gbc.fill = 1;
        if (this.wrapper.getDockable().isWrappableInScrollpane()) {
            this.add((Component)new JScrollPane((Component)((Object)this.wrapper.getDockable())), gbc);
        } else {
            this.add((Component)((Object)this.wrapper.getDockable()), gbc);
        }
    }

    public DockableWrapper getWrapper() {
        return this.wrapper;
    }

    public void parentChanged() {
        this.buildUI();
    }
}

