/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.internal.DockedUnpinnedPanel;
import ModernDocking.internal.DockingInternal;
import ModernDocking.internal.DockingListeners;
import ModernDocking.ui.DockingSettings;
import ModernDocking.ui.ToolbarLocation;
import ModernDocking.util.CombinedIcon;
import ModernDocking.util.RotatedIcon;
import ModernDocking.util.TextIcon;
import ModernDocking.util.UnselectableButtonGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class DockableToolbar
extends JPanel
implements ComponentListener {
    private final DockingAPI docking;
    private final Window window;
    private final RootDockingPanelAPI root;
    private final ToolbarLocation location;
    private final List<Entry> dockables = new ArrayList<Entry>();
    private final UnselectableButtonGroup buttonGroup = new UnselectableButtonGroup();

    public DockableToolbar(DockingAPI docking, Window window, RootDockingPanelAPI root, ToolbarLocation location) {
        super(new GridBagLayout());
        this.docking = docking;
        assert (window instanceof JFrame || window instanceof JDialog);
        this.window = window;
        this.root = root;
        this.location = location;
        this.addComponentListener(this);
    }

    public ToolbarLocation getDockedLocation() {
        return this.location;
    }

    public boolean isVertical() {
        return this.location == ToolbarLocation.EAST || this.location == ToolbarLocation.WEST;
    }

    private void createContents() {
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        for (Entry dockable : this.dockables) {
            this.add((Component)dockable.button, gbc);
            if (this.isVertical()) {
                ++gbc.gridy;
                continue;
            }
            ++gbc.gridx;
        }
        if (this.isVertical()) {
            gbc.weighty = 1.0;
        } else {
            gbc.weightx = 1.0;
        }
        this.add((Component)new JLabel(""), gbc);
    }

    private void updateButtons() {
        for (Entry entry : this.dockables) {
            boolean isSelected;
            boolean bl = isSelected = this.buttonGroup.getSelection() == entry.button.getModel();
            if (entry.panel.isVisible() && !isSelected) {
                DockingListeners.fireHiddenEvent(entry.dockable);
            } else if (!entry.panel.isVisible() && isSelected) {
                DockingListeners.fireShownEvent(entry.dockable);
            } else if (isSelected) {
                DockingListeners.fireShownEvent(entry.dockable);
            }
            entry.panel.setVisible(isSelected);
            if (!isSelected) continue;
            Color color = DockingSettings.getHighlighterSelectedBorder();
            entry.panel.setBorder(BorderFactory.createLineBorder(color, 2));
        }
    }

    public void addDockable(Dockable dockable) {
        if (!this.hasDockable(dockable)) {
            JToggleButton button = new JToggleButton();
            button.setIcon(dockable.getIcon());
            if (this.isVertical()) {
                TextIcon textIcon = new TextIcon(button, dockable.getTabText(), TextIcon.Layout.HORIZONTAL);
                RotatedIcon rotatedIcon = new RotatedIcon((Icon)textIcon, this.location == ToolbarLocation.WEST ? RotatedIcon.Rotate.UP : RotatedIcon.Rotate.DOWN);
                if (dockable.getIcon() != null) {
                    button.setIcon(new CombinedIcon(dockable.getIcon(), rotatedIcon));
                } else {
                    button.setIcon(rotatedIcon);
                }
                Insets insets = UIManager.getInsets("Button.margin");
                Insets margin = new Insets(insets.left, insets.top, insets.left, insets.top);
                button.setMargin(margin);
            } else {
                button.setText(dockable.getTabText());
            }
            DockedUnpinnedPanel panel = new DockedUnpinnedPanel(this.docking, dockable, this.root, this);
            DockingInternal.get(this.docking).getWrapper(dockable).setWindow(this.window);
            button.addActionListener(e -> this.updateButtons());
            this.buttonGroup.add(button);
            this.dockables.add(new Entry(dockable, button, panel));
            JLayeredPane layeredPane = this.window instanceof JFrame ? ((JFrame)this.window).getLayeredPane() : ((JDialog)this.window).getLayeredPane();
            layeredPane.add((Component)panel, this.root.getPinningLayer());
            this.createContents();
        }
    }

    public void removeDockable(Dockable dockable) {
        for (Entry entry : this.dockables) {
            if (entry.dockable != dockable) continue;
            JLayeredPane layeredPane = this.window instanceof JFrame ? ((JFrame)this.window).getLayeredPane() : ((JDialog)this.window).getLayeredPane();
            layeredPane.remove(entry.panel);
            break;
        }
        if (this.dockables.removeIf(panel -> ((Entry)panel).dockable.equals(dockable))) {
            this.createContents();
        }
    }

    public boolean hasDockable(Dockable dockable) {
        return this.dockables.stream().anyMatch(panel -> ((Entry)panel).dockable.equals(dockable));
    }

    public boolean shouldDisplay() {
        return this.dockables.size() > 0;
    }

    public void hideAll() {
        this.buttonGroup.setSelected(this.buttonGroup.getSelection(), false);
        this.updateButtons();
    }

    public List<String> getPersistentIDs() {
        return this.dockables.stream().map(entry -> ((Entry)entry).dockable.getPersistentID()).collect(Collectors.toList());
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.dockables.forEach(dockable -> ((Entry)dockable).panel.componentResized(e));
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private static class Entry {
        private final Dockable dockable;
        private final JToggleButton button;
        private final DockedUnpinnedPanel panel;

        private Entry(Dockable dockable, JToggleButton button, DockedUnpinnedPanel panel) {
            this.dockable = dockable;
            this.button = button;
            this.panel = panel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry panel = (Entry)o;
            return Objects.equals(this.dockable, panel.dockable);
        }

        public int hashCode() {
            return Objects.hash(this.dockable);
        }
    }
}

