/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockedSimplePanel;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.internal.DockingInternal;
import ModernDocking.internal.DockingPanel;
import ModernDocking.settings.Settings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class DockedSplitPanel
extends DockingPanel
implements MouseListener,
PropertyChangeListener {
    private DockingPanel left = null;
    private DockingPanel right = null;
    private final JSplitPane splitPane = new JSplitPane();
    private DockingPanel parent;
    private final DockingAPI docking;
    private final Window window;
    private double lastRequestedDividerProportion;

    public DockedSplitPanel(DockingAPI docking, Window window) {
        this.docking = docking;
        this.window = window;
        this.setLayout(new BorderLayout());
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setBorder(null);
        this.splitPane.addPropertyChangeListener("dividerLocation", this);
        this.setDividerLocation(this.splitPane.getResizeWeight());
        this.lastRequestedDividerProportion = this.splitPane.getResizeWeight();
        if (this.splitPane.getUI() instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider().addMouseListener(this);
        }
        this.add((Component)this.splitPane, "Center");
    }

    public double getLastRequestedDividerProportion() {
        return this.lastRequestedDividerProportion;
    }

    public void setDividerLocation(final double proportion) {
        this.lastRequestedDividerProportion = proportion;
        if (this.splitPane.isShowing()) {
            if (this.splitPane.getWidth() > 0 && this.splitPane.getHeight() > 0) {
                this.splitPane.setDividerLocation(proportion);
            } else {
                this.splitPane.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        DockedSplitPanel.this.splitPane.removeComponentListener(this);
                        DockedSplitPanel.this.setDividerLocation(proportion);
                    }
                });
            }
        } else {
            this.splitPane.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    boolean isShowingChangeEvent;
                    boolean bl = isShowingChangeEvent = (e.getChangeFlags() & 4L) != 0L;
                    if (isShowingChangeEvent && DockedSplitPanel.this.splitPane.isShowing()) {
                        DockedSplitPanel.this.splitPane.removeHierarchyListener(this);
                        DockedSplitPanel.this.setDividerLocation(proportion);
                    }
                }
            });
        }
    }

    public void setDividerLocation(final int location) {
        if (this.splitPane.isShowing()) {
            if (this.splitPane.getWidth() > 0 && this.splitPane.getHeight() > 0) {
                this.splitPane.setDividerLocation(location);
                this.docking.getAppState().persist();
            } else {
                this.splitPane.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        DockedSplitPanel.this.splitPane.removeComponentListener(this);
                        DockedSplitPanel.this.setDividerLocation(location);
                    }
                });
            }
        } else {
            this.splitPane.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    boolean isShowingChangeEvent;
                    boolean bl = isShowingChangeEvent = (e.getChangeFlags() & 4L) != 0L;
                    if (isShowingChangeEvent && DockedSplitPanel.this.splitPane.isShowing()) {
                        DockedSplitPanel.this.splitPane.removeHierarchyListener(this);
                        DockedSplitPanel.this.setDividerLocation(location);
                    }
                }
            });
        }
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public DockingPanel getLeft() {
        return this.left;
    }

    public void setLeft(DockingPanel panel) {
        this.left = panel;
        this.left.setParent(this);
        int dividerLocation = this.splitPane.getDividerLocation();
        this.splitPane.setLeftComponent(panel);
        this.splitPane.setDividerLocation(dividerLocation);
    }

    public DockingPanel getRight() {
        return this.right;
    }

    public void setRight(DockingPanel panel) {
        this.right = panel;
        this.right.setParent(this);
        int dividerLocation = this.splitPane.getDividerLocation();
        this.splitPane.setRightComponent(panel);
        this.splitPane.setDividerLocation(dividerLocation);
    }

    public void setOrientation(int orientation) {
        BasicSplitPaneDivider divider;
        this.splitPane.setOrientation(orientation);
        if (this.splitPane.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider()) != null && divider.getBorder() != null) {
            divider.setBorder(null);
        }
    }

    @Override
    public void setParent(DockingPanel parent) {
        this.parent = parent;
    }

    @Override
    public void dock(Dockable dockable, DockingRegion region, double dividerProportion) {
        DockableWrapper wrapper = DockingInternal.get(this.docking).getWrapper(dockable);
        if (region == DockingRegion.CENTER) {
            region = this.splitPane.getOrientation() == 1 ? DockingRegion.WEST : DockingRegion.NORTH;
        }
        wrapper.setWindow(this.window);
        DockedSplitPanel split = new DockedSplitPanel(this.docking, this.window);
        this.parent.replaceChild(this, split);
        DockingPanel newPanel = Settings.alwaysDisplayTabsMode(wrapper.getDockable()) ? new DockedTabbedPanel(this.docking, wrapper) : new DockedSimplePanel(this.docking, wrapper);
        if (region == DockingRegion.EAST || region == DockingRegion.SOUTH) {
            split.setLeft(this);
            split.setRight(newPanel);
            dividerProportion = 1.0 - dividerProportion;
        } else {
            split.setLeft(newPanel);
            split.setRight(this);
        }
        if (region == DockingRegion.EAST || region == DockingRegion.WEST) {
            split.setOrientation(1);
        } else {
            split.setOrientation(0);
        }
        split.setDividerLocation(dividerProportion);
    }

    @Override
    public void undock(Dockable dockable) {
    }

    @Override
    public void replaceChild(DockingPanel child, DockingPanel newChild) {
        if (this.left == child) {
            this.setLeft(newChild);
        } else if (this.right == child) {
            this.setRight(newChild);
        }
    }

    @Override
    public void removeChild(DockingPanel child) {
        if (this.parent == null) {
            return;
        }
        if (this.left == child) {
            this.parent.replaceChild(this, this.right);
        } else if (this.right == child) {
            this.parent.replaceChild(this, this.left);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            this.setDividerLocation(this.splitPane.getResizeWeight());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.docking.getAppState().persist();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.docking.getAppState().persist();
    }
}

