/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.floating.FloatListener;
import ModernDocking.internal.CustomTabbedPane;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockedSimplePanel;
import ModernDocking.internal.DockedSplitPanel;
import ModernDocking.internal.DockingInternal;
import ModernDocking.internal.DockingListeners;
import ModernDocking.internal.DockingPanel;
import ModernDocking.settings.Settings;
import ModernDocking.ui.DockingSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DockedTabbedPanel
extends DockingPanel
implements ChangeListener {
    private final List<DockableWrapper> panels = new ArrayList<DockableWrapper>();
    private FloatListener floatListener;
    private final CustomTabbedPane tabs = new CustomTabbedPane();
    private final DockingAPI docking;
    private DockingPanel parent;
    private int selectedTab = -1;
    private static Icon settingsIcon = new ImageIcon(Objects.requireNonNull(DockedTabbedPanel.class.getResource("/api_icons/settings.png")));

    public DockedTabbedPanel(DockingAPI docking, DockableWrapper dockable) {
        this.docking = docking;
        this.setLayout(new BorderLayout());
        this.setNotSelectedBorder();
        boolean usingFlatLaf = this.tabs.getUI().getClass().getPackageName().startsWith("com.formdev.flatlaf");
        if (Settings.alwaysDisplayTabsMode(dockable.getDockable()) && usingFlatLaf) {
            this.tabs.setTabPlacement(1);
        } else {
            this.tabs.setTabPlacement(3);
        }
        this.tabs.setTabLayoutPolicy(Settings.getTabLayoutPolicy());
        if (Settings.alwaysDisplayTabsMode(dockable.getDockable())) {
            this.configureTrailingComponent();
        }
        this.add((Component)this.tabs, "Center");
        this.addPanel(dockable);
    }

    public static void setSettingsIcon(Icon icon) {
        settingsIcon = icon;
    }

    private void configureTrailingComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        JButton menu = new JButton(settingsIcon);
        this.setupButton(menu);
        menu.addActionListener(e -> {
            DockableWrapper dockable = this.panels.get(this.tabs.getSelectedIndex());
            dockable.getHeaderUI().displaySettingsMenu(menu);
        });
        panel.add((Component)menu, gbc);
        this.tabs.putClientProperty("JTabbedPane.trailingComponent", panel);
        this.tabs.putClientProperty("JTabbedPane.tabCloseCallback", tabIndex -> this.docking.undock(this.panels.get(tabIndex).getDockable()));
    }

    private void setupButton(final JButton button) {
        Color color = DockingSettings.getHeaderBackground();
        button.setBackground(color);
        button.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        button.setFocusable(false);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setContentAreaFilled(true);
                button.setOpaque(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setContentAreaFilled(false);
                button.setOpaque(false);
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tabs.addChangeListener(this);
        this.floatListener = new FloatListener(this.docking, this, (JComponent)this.tabs);
    }

    @Override
    public void removeNotify() {
        this.tabs.removeChangeListener(this);
        super.removeNotify();
    }

    public void addPanel(DockableWrapper dockable) {
        this.panels.add(dockable);
        this.tabs.add(dockable.getDockable().getTabText(), dockable.getDisplayPanel());
        if (this.tabs.getTabPlacement() != 1 && dockable.getDockable().getTabPosition() == 1) {
            this.tabs.setTabPlacement(1);
        }
        this.tabs.setToolTipTextAt(this.tabs.getTabCount() - 1, dockable.getDockable().getTabTooltip());
        this.tabs.setIconAt(this.tabs.getTabCount() - 1, dockable.getDockable().getIcon());
        this.tabs.setSelectedIndex(this.tabs.getTabCount() - 1);
        this.selectedTab = this.tabs.getSelectedIndex();
        if (Settings.alwaysDisplayTabsMode(dockable.getDockable()) && dockable.getDockable().isClosable()) {
            dockable.getDisplayPanel().putClientProperty("JTabbedPane.tabClosable", true);
        }
        dockable.setParent(this);
    }

    public void removePanel(DockableWrapper dockable) {
        if (this.panels.contains(dockable)) {
            this.panels.indexOf(dockable);
            this.tabs.remove(dockable.getDisplayPanel());
            this.panels.remove(dockable);
            dockable.setParent(null);
        }
    }

    public List<DockableWrapper> getDockables() {
        return Collections.unmodifiableList(this.panels);
    }

    @Override
    public void setParent(DockingPanel parent) {
        this.parent = parent;
    }

    @Override
    public void dock(Dockable dockable, DockingRegion region, double dividerProportion) {
        DockableWrapper wrapper = DockingInternal.get(this.docking).getWrapper(dockable);
        wrapper.setWindow(this.panels.get(0).getWindow());
        if (region == DockingRegion.CENTER) {
            this.addPanel(wrapper);
        } else {
            DockedSplitPanel split = new DockedSplitPanel(this.docking, this.panels.get(0).getWindow());
            this.parent.replaceChild(this, split);
            DockingPanel newPanel = Settings.alwaysDisplayTabsMode(wrapper.getDockable()) ? new DockedTabbedPanel(this.docking, wrapper) : new DockedSimplePanel(this.docking, wrapper);
            if (region == DockingRegion.EAST || region == DockingRegion.SOUTH) {
                split.setLeft(this);
                split.setRight(newPanel);
                dividerProportion = 1.0 - dividerProportion;
            } else {
                split.setLeft(newPanel);
                split.setRight(this);
            }
            if (region == DockingRegion.EAST || region == DockingRegion.WEST) {
                split.setOrientation(1);
            } else {
                split.setOrientation(0);
            }
            split.setDividerLocation(dividerProportion);
        }
        this.revalidate();
        this.repaint();
    }

    public void dockAtIndex(Dockable dockable, int index) {
        DockableWrapper wrapper = DockingInternal.get(this.docking).getWrapper(dockable);
        wrapper.setWindow(this.panels.get(0).getWindow());
        this.addPanel(DockingInternal.get(this.docking).getWrapper(dockable));
        if (index != -1) {
            int lastIndex = this.tabs.getTabCount() - 1;
            for (int i = index; i < lastIndex; ++i) {
                DockableWrapper panel = this.panels.get(index);
                this.removePanel(panel);
                this.addPanel(panel);
            }
            this.tabs.setSelectedIndex(index);
        }
    }

    @Override
    public void undock(Dockable dockable) {
        this.removePanel(DockingInternal.get(this.docking).getWrapper(dockable));
        if (!Settings.alwaysDisplayTabsMode(dockable) && this.tabs.getTabCount() == 1 && this.parent != null) {
            this.parent.replaceChild(this, new DockedSimplePanel(this.docking, this.panels.get(0)));
        }
        if (this.tabs.getTabCount() == 0) {
            this.parent.removeChild(this);
        }
    }

    @Override
    public void replaceChild(DockingPanel child, DockingPanel newChild) {
    }

    @Override
    public void removeChild(DockingPanel child) {
    }

    private void setNotSelectedBorder() {
        Color color = UIManager.getColor("Component.borderColor");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(color, 1)));
    }

    public void bringToFront(Dockable dockable) {
        for (int i = 0; i < this.panels.size(); ++i) {
            DockableWrapper panel = this.panels.get(i);
            if (panel.getDockable() != dockable) continue;
            if (this.tabs.getSelectedIndex() != i) {
                if (this.tabs.getSelectedIndex() != -1) {
                    DockingListeners.fireHiddenEvent(this.panels.get(this.tabs.getSelectedIndex()).getDockable());
                }
                DockingListeners.fireShownEvent(this.panels.get(i).getDockable());
            }
            this.tabs.setSelectedIndex(i);
            this.selectedTab = this.tabs.getSelectedIndex();
        }
    }

    public String getSelectedTabID() {
        return this.panels.get(this.tabs.getSelectedIndex()).getDockable().getPersistentID();
    }

    public int getSelectedTabIndex() {
        return this.tabs.getSelectedIndex();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.docking.getAppState().persist();
        if (this.tabs.getSelectedIndex() == -1) {
            return;
        }
        if (this.selectedTab != -1 && !FloatListener.isFloating()) {
            DockingListeners.fireHiddenEvent(this.panels.get(this.selectedTab).getDockable());
        }
        this.selectedTab = this.tabs.getSelectedIndex();
        if (this.selectedTab != -1) {
            DockingListeners.fireShownEvent(this.panels.get(this.selectedTab).getDockable());
        }
    }

    public boolean isUsingTopTabs() {
        return this.tabs.getTabPlacement() == 1;
    }

    public boolean isUsingBottomTabs() {
        return this.tabs.getTabPlacement() == 3;
    }

    public Component getTabForDockable(DockableWrapper wrapper) {
        for (int i = 0; i < this.panels.size(); ++i) {
            DockableWrapper panel = this.panels.get(i);
            if (panel.getDockable() != wrapper.getDockable()) continue;
            return this.tabs.getTabComponentAt(i);
        }
        return null;
    }

    public void updateTabInfo(Dockable dockable) {
        for (int i = 0; i < this.panels.size(); ++i) {
            DockableWrapper panel = this.panels.get(i);
            if (panel.getDockable() != dockable) continue;
            this.tabs.setTitleAt(i, dockable.getTabText());
            this.tabs.setToolTipTextAt(i, dockable.getTabTooltip());
            Component tabComponent = this.tabs.getTabComponentAt(i);
            if (!(tabComponent instanceof JLabel)) continue;
            ((JLabel)tabComponent).setText(dockable.getTabText());
            ((JLabel)tabComponent).setToolTipText(dockable.getTabTooltip());
        }
    }

    public int getTargetTabIndex(Point point) {
        return this.tabs.getTargetTabIndex(point, false);
    }

    public boolean isDraggingFromTabGutter(Point point) {
        Rectangle boundsAt = this.tabs.getBoundsAt(0);
        return boundsAt.y <= point.y && boundsAt.y + boundsAt.height >= point.y;
    }
}

