/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.internal.DockableToolbar;
import ModernDocking.internal.DockedSimplePanel;
import ModernDocking.internal.DockingInternal;
import ModernDocking.ui.ToolbarLocation;
import ModernDocking.util.SlideBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DockedUnpinnedPanel
extends JPanel
implements ComponentListener,
MouseMotionListener {
    private final RootDockingPanelAPI root;
    private final DockableToolbar toolbar;
    private boolean configured = false;

    public DockedUnpinnedPanel(DockingAPI docking, Dockable dockable, RootDockingPanelAPI root, DockableToolbar toolbar) {
        this.root = root;
        this.toolbar = toolbar;
        root.addComponentListener(this);
        this.addComponentListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        DockedSimplePanel panel = new DockedSimplePanel(docking, DockingInternal.get(docking).getWrapper(dockable));
        SlideBorder slideBorder = new SlideBorder(toolbar.getDockedLocation());
        if (toolbar.getDockedLocation() == ToolbarLocation.SOUTH) {
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add((Component)slideBorder, gbc);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            ++gbc.gridy;
            this.add((Component)panel, gbc);
        } else if (toolbar.getDockedLocation() == ToolbarLocation.EAST) {
            gbc.weighty = 1.0;
            gbc.fill = 3;
            this.add((Component)slideBorder, gbc);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            ++gbc.gridx;
            this.add((Component)panel, gbc);
        } else {
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            this.add((Component)panel, gbc);
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbc.fill = 3;
            ++gbc.gridx;
            this.add((Component)slideBorder, gbc);
        }
        slideBorder.addMouseMotionListener(this);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setLocationAndSize(0);
        if (!this.configured) {
            this.configured = true;
        }
    }

    private void setLocationAndSize(int widthDifference) {
        Point toolbarLocation = this.toolbar.getLocation();
        SwingUtilities.convertPointToScreen(toolbarLocation, this.toolbar.getParent());
        Dimension toolbarSize = this.toolbar.getSize();
        if (this.toolbar.isVertical()) {
            int width = (int)((double)this.root.getWidth() / 4.0);
            int height = toolbarSize.height;
            if (this.configured) {
                width = this.getWidth() + widthDifference;
            }
            width = Math.max(100, width);
            width = Math.min(width, this.getParent().getWidth() - 100);
            Point location = new Point(toolbarLocation.x + toolbarSize.width, toolbarLocation.y);
            Dimension size = new Dimension(width, height);
            if (this.toolbar.getDockedLocation() == ToolbarLocation.EAST) {
                location.x = toolbarLocation.x - width;
            }
            SwingUtilities.convertPointFromScreen(location, this.getParent());
            this.setLocation(location);
            this.setSize(size);
        } else {
            int width = toolbarSize.width;
            int height = (int)((double)this.root.getHeight() / 4.0);
            if (this.configured) {
                height = this.getHeight() + widthDifference;
            }
            height = Math.max(100, height);
            height = Math.min(height, this.getParent().getHeight() - 100);
            Point location = new Point(toolbarLocation.x, toolbarLocation.y - height);
            Dimension size = new Dimension(width, height);
            SwingUtilities.convertPointFromScreen(location, this.getParent());
            this.setLocation(location);
            this.setSize(size);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getComponent() == this.root) {
            this.setLocationAndSize(0);
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.toolbar.getDockedLocation() == ToolbarLocation.SOUTH) {
            this.setLocationAndSize(-e.getY());
        } else if (this.toolbar.getDockedLocation() == ToolbarLocation.WEST) {
            this.setLocationAndSize(e.getX());
        } else {
            this.setLocationAndSize(-e.getX());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

