/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.exception.DockableRegistrationFailureException;
import ModernDocking.internal.CustomTabbedPane;
import ModernDocking.internal.DisplayPanel;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockingInternal;
import ModernDocking.internal.DockingListeners;
import ModernDocking.internal.DockingPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Optional;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DockingComponentUtils {
    public static void undockComponents(DockingAPI docking, Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof DisplayPanel) {
                docking.undock(((DisplayPanel)component).getWrapper().getDockable());
                continue;
            }
            if (!(component instanceof Container)) continue;
            DockingComponentUtils.undockComponents(docking, (Container)component);
        }
    }

    public static Window findRootAtScreenPos(DockingAPI docking, Point screenPos) {
        for (Window window : docking.getRootPanels().keySet()) {
            Rectangle bounds = new Rectangle(window.getX(), window.getY(), window.getWidth(), window.getHeight());
            if (!bounds.contains(screenPos) || !window.isVisible()) continue;
            return window;
        }
        return null;
    }

    public static Window findWindowForDockable(DockingAPI docking, Dockable dockable) {
        return DockingInternal.get(docking).getWrapper(dockable).getWindow();
    }

    public static RootDockingPanelAPI rootForWindow(DockingAPI docking, Window window) {
        if (docking.getRootPanels().containsKey(window)) {
            return docking.getRootPanels().get(window);
        }
        throw new DockableRegistrationFailureException("No root panel for window has been registered.");
    }

    public static Window windowForRoot(DockingAPI docking, RootDockingPanelAPI root) {
        Optional<Window> first = docking.getRootPanels().keySet().stream().filter(frame -> docking.getRootPanels().get(frame) == root).findFirst();
        return first.orElse(null);
    }

    public static Dockable findDockableAtScreenPos(DockingAPI docking, Point screenPos) {
        Window window = DockingComponentUtils.findRootAtScreenPos(docking, screenPos);
        if (window == null) {
            return null;
        }
        return DockingComponentUtils.findDockableAtScreenPos(screenPos, window);
    }

    public static Dockable findDockableAtScreenPos(Point screenPos, Window window) {
        if (window == null) {
            return null;
        }
        Point framePoint = new Point(screenPos);
        SwingUtilities.convertPointFromScreen(framePoint, window);
        Component component = SwingUtilities.getDeepestComponentAt(window, framePoint.x, framePoint.y);
        if (component == null) {
            return null;
        }
        while (!(component instanceof DisplayPanel) && component.getParent() != null) {
            component = component.getParent();
        }
        if (!(component instanceof DisplayPanel)) {
            return null;
        }
        return ((DisplayPanel)component).getWrapper().getDockable();
    }

    public static CustomTabbedPane findTabbedPaneAtPos(Point screenPos, Window window) {
        if (window == null) {
            return null;
        }
        Point framePoint = new Point(screenPos);
        SwingUtilities.convertPointFromScreen(framePoint, window);
        Component component = SwingUtilities.getDeepestComponentAt(window, framePoint.x, framePoint.y);
        if (component == null) {
            return null;
        }
        while (!(component instanceof CustomTabbedPane) && component.getParent() != null) {
            component = component.getParent();
        }
        if (!(component instanceof CustomTabbedPane)) {
            return null;
        }
        return (CustomTabbedPane)component;
    }

    public static DockingPanel findDockingPanelAtScreenPos(DockingAPI docking, Point screenPos) {
        Window window = DockingComponentUtils.findRootAtScreenPos(docking, screenPos);
        if (window == null) {
            return null;
        }
        return DockingComponentUtils.findDockingPanelAtScreenPos(screenPos, window);
    }

    public static DockingPanel findDockingPanelAtScreenPos(Point screenPos, Window window) {
        if (window == null) {
            return null;
        }
        Point framePoint = new Point(screenPos);
        SwingUtilities.convertPointFromScreen(framePoint, window);
        Component component = SwingUtilities.getDeepestComponentAt(window, framePoint.x, framePoint.y);
        if (component == null) {
            return null;
        }
        while (!(component instanceof DockingPanel) && component.getParent() != null) {
            component = component.getParent();
        }
        if (!(component instanceof DockingPanel)) {
            return null;
        }
        return (DockingPanel)component;
    }

    public static void removeIllegalFloats(DockingAPI docking, Window window) {
        if (window instanceof JDialog) {
            return;
        }
        RootDockingPanelAPI root = DockingComponentUtils.rootForWindow(docking, window);
        if (docking.canDisposeWindow(window) && root != null && DockingComponentUtils.shouldUndock(root)) {
            DockingComponentUtils.undockIllegalFloats(root);
        }
        docking.getAppState().persist();
    }

    private static boolean shouldUndock(Container container) {
        for (Component component : container.getComponents()) {
            DisplayPanel panel;
            if (!(component instanceof DisplayPanel ? (panel = (DisplayPanel)component).getWrapper().getDockable().isFloatingAllowed() : component instanceof Container && !DockingComponentUtils.shouldUndock((Container)component))) continue;
            return false;
        }
        return true;
    }

    private static void undockIllegalFloats(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof DisplayPanel) {
                DisplayPanel panel = (DisplayPanel)component;
                DockableWrapper wrapper = panel.getWrapper();
                Dockable dockable = wrapper.getDockable();
                wrapper.getParent().undock(dockable);
                DockingListeners.fireUndockedEvent(dockable);
                continue;
            }
            if (!(component instanceof Container)) continue;
            DockingComponentUtils.undockIllegalFloats((Container)component);
        }
    }

    public static Optional<Dockable> findFirstDockableOfType(DockingAPI docking, int type) {
        RootDockingPanelAPI mainRoot = DockingComponentUtils.rootForWindow(docking, docking.getMainWindow());
        Optional<Dockable> mainPanelDockable = DockingComponentUtils.findDockableOfType(type, mainRoot.getPanel());
        if (mainPanelDockable.isPresent()) {
            return mainPanelDockable;
        }
        for (RootDockingPanelAPI panel : docking.getRootPanels().values()) {
            Optional<Dockable> dockable = DockingComponentUtils.findDockableOfType(type, panel);
            if (!dockable.isPresent()) continue;
            return dockable;
        }
        return Optional.empty();
    }

    private static Optional<Dockable> findDockableOfType(int type, Container container) {
        if (container == null) {
            return Optional.empty();
        }
        for (Component component : container.getComponents()) {
            Optional<Dockable> dockableOfType;
            if (component instanceof DisplayPanel) {
                DisplayPanel panel = (DisplayPanel)component;
                DockableWrapper wrapper = panel.getWrapper();
                Dockable dockable = wrapper.getDockable();
                if (dockable.getType() != type) continue;
                return Optional.of(dockable);
            }
            if (!(component instanceof Container) || !(dockableOfType = DockingComponentUtils.findDockableOfType(type, (Container)component)).isPresent()) continue;
            return dockableOfType;
        }
        return Optional.empty();
    }
}

