/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.event.DockingEvent;
import ModernDocking.event.DockingListener;
import ModernDocking.event.MaximizeListener;
import java.util.ArrayList;
import java.util.List;

public class DockingListeners {
    private static final List<MaximizeListener> maximizeListeners = new ArrayList<MaximizeListener>();
    private static final List<DockingListener> dockingListeners = new ArrayList<DockingListener>();

    public static void addMaximizeListener(MaximizeListener listener) {
        if (!maximizeListeners.contains(listener)) {
            maximizeListeners.add(listener);
        }
    }

    public static void removeMaximizeListener(MaximizeListener listener) {
        maximizeListeners.remove(listener);
    }

    public static void fireMaximizeEvent(Dockable dockable, boolean maximized) {
        maximizeListeners.forEach(listener -> listener.maximized(dockable, maximized));
    }

    public static void addDockingListener(DockingListener listener) {
        if (!dockingListeners.contains(listener)) {
            dockingListeners.add(listener);
        }
    }

    public static void removeDockingListener(DockingListener listener) {
        dockingListeners.remove(listener);
    }

    public static void fireDockedEvent(Dockable dockable) {
        dockingListeners.forEach(listener -> listener.dockingChange(new DockingEvent(DockingEvent.ID.DOCKED, dockable)));
    }

    public static void fireUndockedEvent(Dockable dockable) {
        dockingListeners.forEach(listener -> listener.dockingChange(new DockingEvent(DockingEvent.ID.UNDOCKED, dockable)));
    }

    public static void firePinnedEvent(Dockable dockable) {
        dockingListeners.forEach(listener -> listener.dockingChange(new DockingEvent(DockingEvent.ID.PINNED, dockable)));
    }

    public static void fireUnpinnedEvent(Dockable dockable) {
        dockingListeners.forEach(listener -> listener.dockingChange(new DockingEvent(DockingEvent.ID.UNPINNED, dockable)));
    }

    public static void fireShownEvent(Dockable dockable) {
        dockingListeners.forEach(listener -> listener.dockingChange(new DockingEvent(DockingEvent.ID.SHOWN, dockable)));
    }

    public static void fireHiddenEvent(Dockable dockable) {
        dockingListeners.forEach(listener -> listener.dockingChange(new DockingEvent(DockingEvent.ID.HIDDEN, dockable)));
    }

    public static void fireDockingEvent(DockingEvent e) {
        dockingListeners.forEach(listener -> listener.dockingChange(e));
    }
}

