/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;

public class DockingProperties {
    private static final String handlesBackgroundColorKey = "ModernDocking.handles.background";
    private static final String handlesBackgroundBorderColorKey = "ModernDocking.handles.background.border";
    private static final String handlesOutlineColorKey = "ModernDocking.handles.outline";
    private static final String handlesFillColorKey = "ModernDocking.handles.fill";
    private static final String overlayBackgroundColorKey = "ModernDocking.overlay.color";
    private static final String overlayBorderColorKey = "ModernDocking.overlay.border.color";
    private static final String overlayAlphaKey = "ModernDocking.overlay.alpha";
    private static final String titlebarBackgroundEnabledKey = "ModernDocking.titlebar.border.enabled";
    private static final String titlebarBackgroundColorKey = "ModernDocking.titlebar.background.color";
    private static final String titlebarBorderColorKey = "ModernDocking.titlebar.border.color";
    private static final String titlebarBorderSizeKey = "ModernDocking.titlebar.border.size";
    private final Map<String, Color> lightColors = Map.ofEntries(Map.entry("ModernDocking.handles.background", new Color(0xF2F2F2)), Map.entry("ModernDocking.handles.background.border", new Color(0xC2C2C2)), Map.entry("ModernDocking.handles.outline", new Color(0)), Map.entry("ModernDocking.handles.fill", new Color(5152231)), Map.entry("ModernDocking.overlay.color", new Color(25556)), Map.entry("ModernDocking.overlay.border.color", new Color(0xC2C2C2)), Map.entry("ModernDocking.titlebar.background.color", new Color(0xFFFFFF)), Map.entry("ModernDocking.titlebar.border.color", new Color(0xC2C2C2)));
    private final Map<String, Color> darkColors = Map.ofEntries(Map.entry("ModernDocking.handles.background", new Color(3948353)), Map.entry("ModernDocking.handles.background.border", new Color(6382437)), Map.entry("ModernDocking.handles.outline", new Color(0x8C8C8C)), Map.entry("ModernDocking.handles.fill", new Color(5600148)), Map.entry("ModernDocking.overlay.color", new Color(4374783)), Map.entry("ModernDocking.overlay.border.color", new Color(0x111111)), Map.entry("ModernDocking.titlebar.background.color", new Color(4606283)), Map.entry("ModernDocking.titlebar.border.color", new Color(0x666666)));
    private final boolean defaultTitlebarBorderEnabled = true;
    private final int defaultTitlebarBorderSize = 1;
    private final int lightOverlayAlpha = 75;
    private final int darkOverlayAlpha = 85;
    private final Map<String, Color> currentColors = new HashMap<String, Color>(this.lightColors);
    private int overlayAlpha = 75;
    private boolean titlebarBorderEnabled = true;
    private int titlebarBorderSize = 1;
    private static final DockingProperties properties = new DockingProperties();

    private DockingProperties() {
        this.updateProperties();
        UIManager.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("lookAndFeel")) {
                this.updateProperties();
            }
        });
    }

    private void updateProperties() {
        boolean isDarkTheme = UIManager.getLookAndFeel().getName().toLowerCase().contains("dark");
        for (String key : this.currentColors.keySet()) {
            Color color = UIManager.getColor(key);
            if (color != null) {
                this.currentColors.put(key, color);
                continue;
            }
            if (isDarkTheme) {
                this.currentColors.put(key, this.darkColors.get(key));
                continue;
            }
            this.currentColors.put(key, this.lightColors.get(key));
        }
        this.overlayAlpha = UIManager.get(overlayAlphaKey) != null ? UIManager.getInt(overlayAlphaKey) : (isDarkTheme ? 85 : 75);
        this.titlebarBorderEnabled = UIManager.get(titlebarBackgroundEnabledKey) != null ? UIManager.getBoolean(titlebarBackgroundEnabledKey) : true;
        this.titlebarBorderSize = UIManager.get(titlebarBorderSizeKey) != null ? UIManager.getInt(this.titlebarBorderSize) : 1;
    }
}

