/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.layouts;

import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.internal.DockingInternal;
import ModernDocking.layouts.DockingLayoutNode;
import ModernDocking.layouts.DockingSimplePanelNode;
import ModernDocking.layouts.DockingTabPanelNode;
import ModernDocking.settings.Settings;

public class DockingLayoutRootNode
implements DockingLayoutNode {
    private final DockingAPI docking;
    private DockingLayoutNode node;

    public DockingLayoutRootNode(DockingAPI docking) {
        this.docking = docking;
    }

    @Override
    public DockingLayoutNode findNode(String persistentID) {
        return this.node.findNode(persistentID);
    }

    @Override
    public void dock(String persistentID, DockingRegion region, double dividerProportion) {
        if (this.node != null) {
            this.node.dock(persistentID, region, dividerProportion);
        } else if (Settings.alwaysDisplayTabsMode(DockingInternal.get(this.docking).getDockable(persistentID))) {
            this.node = new DockingTabPanelNode(this.docking, persistentID);
            this.node.setParent(this);
        } else {
            String className = DockingInternal.get(this.docking).getDockable(persistentID).getClass().getCanonicalName();
            this.node = new DockingSimplePanelNode(this.docking, persistentID, className);
            this.node.setParent(this);
        }
    }

    @Override
    public void replaceChild(DockingLayoutNode child, DockingLayoutNode newChild) {
        if (this.node == child) {
            this.node = newChild;
            this.node.setParent(this);
        }
    }

    @Override
    public DockingLayoutNode getParent() {
        return null;
    }

    @Override
    public void setParent(DockingLayoutNode parent) {
    }

    public DockingLayoutNode getNode() {
        return this.node;
    }
}

