/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.layouts;

import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.event.DockingLayoutEvent;
import ModernDocking.event.DockingLayoutListener;
import ModernDocking.internal.DockableProperties;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockedSimplePanel;
import ModernDocking.internal.DockedSplitPanel;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.internal.DockingComponentUtils;
import ModernDocking.internal.DockingInternal;
import ModernDocking.internal.DockingPanel;
import ModernDocking.layouts.ApplicationLayout;
import ModernDocking.layouts.DockingLayoutNode;
import ModernDocking.layouts.DockingSimplePanelNode;
import ModernDocking.layouts.DockingSplitPanelNode;
import ModernDocking.layouts.DockingTabPanelNode;
import ModernDocking.layouts.EmptyPanelNode;
import ModernDocking.layouts.WindowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JSplitPane;

public class DockingLayouts {
    private static final List<DockingLayoutListener> listeners = new ArrayList<DockingLayoutListener>();
    private static final Map<String, ApplicationLayout> layouts = new HashMap<String, ApplicationLayout>();

    public static void addLayoutsListener(DockingLayoutListener listener) {
        listeners.add(listener);
    }

    public static void removeLayoutsListener(DockingLayoutListener listener) {
        listeners.remove(listener);
    }

    public static void addLayout(String name, ApplicationLayout layout) {
        DockingLayouts.removeLayout(name);
        layouts.put(name, layout);
        listeners.forEach(l -> l.layoutChange(new DockingLayoutEvent(DockingLayoutEvent.ID.ADDED, name, layout)));
    }

    public static void removeLayout(String name) {
        ApplicationLayout layout = layouts.remove(name);
        if (layout != null) {
            listeners.forEach(l -> l.layoutChange(new DockingLayoutEvent(DockingLayoutEvent.ID.REMOVED, name, layout)));
        }
    }

    public static void layoutRestored(ApplicationLayout layout) {
        listeners.forEach(l -> l.layoutChange(new DockingLayoutEvent(DockingLayoutEvent.ID.RESTORED, "current", layout)));
    }

    public static void layoutPersisted(ApplicationLayout layout) {
        listeners.forEach(l -> l.layoutChange(new DockingLayoutEvent(DockingLayoutEvent.ID.PERSISTED, "current", layout)));
    }

    public static ApplicationLayout getLayout(String name) {
        return layouts.get(name);
    }

    public static List<String> getLayoutNames() {
        return new ArrayList<String>(layouts.keySet());
    }

    public static WindowLayout layoutFromRoot(DockingAPI docking, RootDockingPanelAPI root) {
        WindowLayout layout = new WindowLayout(DockingComponentUtils.windowForRoot(docking, root), DockingLayouts.panelToNode(docking, root.getPanel()));
        layout.setWestUnpinnedToolbarIDs(root.getWestUnpinnedToolbarIDs());
        layout.setEastUnpinnedToolbarIDs(root.getEastUnpinnedToolbarIDs());
        layout.setSouthUnpinnedToolbarIDs(root.getSouthUnpinnedToolbarIDs());
        return layout;
    }

    private static DockingLayoutNode panelToNode(DockingAPI docking, DockingPanel panel) {
        DockingLayoutNode node;
        if (panel instanceof DockedSimplePanel) {
            DockableWrapper wrapper = ((DockedSimplePanel)panel).getWrapper();
            Map<String, String> properties = DockableProperties.saveProperties(wrapper);
            node = new DockingSimplePanelNode(docking, wrapper.getDockable().getPersistentID(), wrapper.getDockable().getClass().getCanonicalName(), properties);
        } else if (panel instanceof DockedSplitPanel) {
            node = DockingLayouts.splitPanelToNode(docking, (DockedSplitPanel)panel);
        } else if (panel instanceof DockedTabbedPanel) {
            node = DockingLayouts.tabbedPanelToNode(docking, (DockedTabbedPanel)panel);
        } else if (panel == null) {
            node = new EmptyPanelNode();
        } else {
            throw new RuntimeException("Unknown panel");
        }
        return node;
    }

    private static DockingLayoutNode splitPanelToNode(DockingAPI docking, DockedSplitPanel panel) {
        JSplitPane splitPane = panel.getSplitPane();
        int orientation = splitPane.getOrientation();
        int height = splitPane.getHeight();
        int dividerSize = splitPane.getDividerSize();
        int dividerLocation = splitPane.getDividerLocation();
        int width = splitPane.getWidth();
        double dividerProportion = orientation == 0 ? (double)((float)dividerLocation / (float)(height - dividerSize)) : (double)((float)dividerLocation / (float)(width - dividerSize));
        return new DockingSplitPanelNode(docking, DockingLayouts.panelToNode(docking, panel.getLeft()), DockingLayouts.panelToNode(docking, panel.getRight()), splitPane.getOrientation(), dividerProportion);
    }

    private static DockingLayoutNode tabbedPanelToNode(DockingAPI docking, DockedTabbedPanel panel) {
        DockableWrapper wrapper = DockingInternal.get(docking).getWrapper(DockingInternal.get(docking).getDockable(panel.getSelectedTabID()));
        DockingTabPanelNode node = new DockingTabPanelNode(docking, panel.getSelectedTabID(), DockableProperties.saveProperties(wrapper));
        for (DockableWrapper dockable : panel.getDockables()) {
            node.addTab(dockable.getDockable().getPersistentID(), DockableProperties.saveProperties(dockable));
        }
        return node;
    }
}

