/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.layouts;

import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.internal.DockingInternal;
import ModernDocking.layouts.DockingLayoutNode;
import ModernDocking.layouts.DockingSplitPanelNode;
import ModernDocking.layouts.DockingTabPanelNode;
import ModernDocking.settings.Settings;
import java.util.HashMap;
import java.util.Map;

public class DockingSimplePanelNode
implements DockingLayoutNode {
    private final DockingAPI docking;
    private final String persistentID;
    private final String className;
    private Map<String, String> properties = new HashMap<String, String>();
    private DockingLayoutNode parent;

    public DockingSimplePanelNode(DockingAPI docking, String persistentID, String className) {
        this.docking = docking;
        this.persistentID = persistentID;
        this.className = className;
    }

    public DockingSimplePanelNode(DockingAPI docking, String persistentID, String className, Map<String, String> properties) {
        this.docking = docking;
        this.persistentID = persistentID;
        this.className = className;
        this.properties.putAll(properties);
    }

    @Override
    public DockingLayoutNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DockingLayoutNode parent) {
        this.parent = parent;
    }

    @Override
    public DockingLayoutNode findNode(String persistentID) {
        if (this.persistentID.equals(persistentID)) {
            return this;
        }
        return null;
    }

    @Override
    public void dock(String persistentID, DockingRegion region, double dividerProportion) {
        if (this.getParent() instanceof DockingTabPanelNode) {
            this.getParent().dock(persistentID, region, dividerProportion);
        } else if (region == DockingRegion.CENTER) {
            DockingTabPanelNode tab = new DockingTabPanelNode(this.docking, persistentID);
            tab.addTab(this.persistentID);
            tab.addTab(persistentID);
            this.parent.replaceChild(this, tab);
        } else {
            DockingLayoutNode right;
            DockingLayoutNode left;
            int orientation;
            int n = orientation = region == DockingRegion.EAST || region == DockingRegion.WEST ? 1 : 0;
            if (Settings.alwaysDisplayTabsMode(DockingInternal.get(this.docking).getDockable(persistentID))) {
                if (orientation == 1) {
                    left = region == DockingRegion.EAST ? this : new DockingTabPanelNode(this.docking, persistentID);
                    right = region == DockingRegion.EAST ? new DockingTabPanelNode(this.docking, persistentID) : this;
                } else {
                    left = region == DockingRegion.SOUTH ? this : new DockingTabPanelNode(this.docking, persistentID);
                    right = region == DockingRegion.SOUTH ? new DockingTabPanelNode(this.docking, persistentID) : this;
                }
            } else if (orientation == 1) {
                left = region == DockingRegion.EAST ? this : new DockingSimplePanelNode(this.docking, persistentID, this.className);
                right = region == DockingRegion.EAST ? new DockingSimplePanelNode(this.docking, persistentID, this.className) : this;
            } else {
                left = region == DockingRegion.SOUTH ? this : new DockingSimplePanelNode(this.docking, persistentID, this.className);
                DockingSimplePanelNode dockingSimplePanelNode = right = region == DockingRegion.SOUTH ? new DockingSimplePanelNode(this.docking, persistentID, this.className) : this;
            }
            if (region == DockingRegion.EAST || region == DockingRegion.SOUTH) {
                dividerProportion = 1.0 - dividerProportion;
            }
            DockingLayoutNode oldParent = this.parent;
            DockingSplitPanelNode split = new DockingSplitPanelNode(this.docking, left, right, orientation, dividerProportion);
            oldParent.replaceChild(this, split);
        }
    }

    @Override
    public void replaceChild(DockingLayoutNode child, DockingLayoutNode newChild) {
    }

    public String getPersistentID() {
        return this.persistentID;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
    }
}

