/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.layouts;

import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.internal.DockingInternal;
import ModernDocking.layouts.DockingLayoutNode;
import ModernDocking.layouts.DockingSimplePanelNode;
import ModernDocking.layouts.DockingTabPanelNode;
import ModernDocking.settings.Settings;

public class DockingSplitPanelNode
implements DockingLayoutNode {
    private final DockingAPI docking;
    private DockingLayoutNode left;
    private DockingLayoutNode right;
    private final int orientation;
    private final double dividerProportion;
    private DockingLayoutNode parent;

    public DockingSplitPanelNode(DockingAPI docking, DockingLayoutNode left, DockingLayoutNode right, int orientation, double dividerProportion) {
        this.docking = docking;
        this.left = left;
        this.right = right;
        this.orientation = orientation;
        this.dividerProportion = dividerProportion;
        if (this.left != null) {
            this.left.setParent(this);
        }
        if (this.right != null) {
            this.right.setParent(this);
        }
    }

    @Override
    public DockingLayoutNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DockingLayoutNode parent) {
        this.parent = parent;
    }

    @Override
    public DockingLayoutNode findNode(String persistentID) {
        DockingLayoutNode left;
        if (this.left != null && (left = this.left.findNode(persistentID)) != null) {
            return left;
        }
        if (this.right == null) {
            return null;
        }
        return this.right.findNode(persistentID);
    }

    @Override
    public void dock(String persistentID, DockingRegion region, double dividerProportion) {
        if (region != DockingRegion.CENTER) {
            DockingSplitPanelNode right;
            DockingLayoutNode left;
            int orientation;
            int n = orientation = region == DockingRegion.EAST || region == DockingRegion.WEST ? 1 : 0;
            if (Settings.alwaysDisplayTabsMode(DockingInternal.get(this.docking).getDockable(persistentID))) {
                left = region == DockingRegion.NORTH || region == DockingRegion.WEST ? new DockingTabPanelNode(this.docking, persistentID) : this;
                right = region == DockingRegion.NORTH || region == DockingRegion.WEST ? this : new DockingTabPanelNode(this.docking, persistentID);
            } else {
                String className = DockingInternal.get(this.docking).getDockable(persistentID).getClass().getCanonicalName();
                left = region == DockingRegion.NORTH || region == DockingRegion.WEST ? new DockingSimplePanelNode(this.docking, persistentID, className) : this;
                DockingLayoutNode dockingLayoutNode = right = region == DockingRegion.NORTH || region == DockingRegion.WEST ? this : new DockingSimplePanelNode(this.docking, persistentID, className);
            }
            if (region == DockingRegion.EAST || region == DockingRegion.SOUTH) {
                dividerProportion = 1.0 - dividerProportion;
            }
            DockingLayoutNode oldParent = this.parent;
            DockingSplitPanelNode split = new DockingSplitPanelNode(this.docking, left, right, orientation, dividerProportion);
            oldParent.replaceChild(this, split);
        }
    }

    @Override
    public void replaceChild(DockingLayoutNode child, DockingLayoutNode newChild) {
        if (this.left == child) {
            this.left = newChild;
            this.left.setParent(this);
        } else if (this.right == child) {
            this.right = newChild;
            this.right.setParent(this);
        }
    }

    public DockingLayoutNode getLeft() {
        return this.left;
    }

    public DockingLayoutNode getRight() {
        return this.right;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public double getDividerProportion() {
        return this.dividerProportion;
    }
}

