/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.layouts;

import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.internal.DockingInternal;
import ModernDocking.layouts.DockingLayoutNode;
import ModernDocking.layouts.DockingSimplePanelNode;
import ModernDocking.layouts.DockingSplitPanelNode;
import ModernDocking.settings.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DockingTabPanelNode
implements DockingLayoutNode {
    private final List<DockingSimplePanelNode> tabs = new ArrayList<DockingSimplePanelNode>();
    private final DockingAPI docking;
    private String selectedTabID;
    private DockingLayoutNode parent;

    public DockingTabPanelNode(DockingAPI docking, String selectedTabID) {
        this.docking = docking;
        this.addTab(selectedTabID);
        this.selectedTabID = selectedTabID;
    }

    public DockingTabPanelNode(DockingAPI docking, String selectedTabID, Map<String, String> properties) {
        this.docking = docking;
        this.addTab(selectedTabID, properties);
        this.selectedTabID = selectedTabID;
    }

    public void addTab(String persistentID) {
        if (this.findNode(persistentID) != null) {
            DockingSimplePanelNode node = null;
            for (DockingSimplePanelNode tab : this.tabs) {
                if (!persistentID.equals(tab.getPersistentID())) continue;
                node = tab;
            }
            if (node != null) {
                this.tabs.remove(node);
                this.tabs.add(node);
            }
            return;
        }
        String className = "";
        try {
            className = DockingInternal.get(this.docking).getDockable(persistentID).getClass().getCanonicalName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DockingSimplePanelNode tab = new DockingSimplePanelNode(this.docking, persistentID, className);
        tab.setParent(this);
        this.tabs.add(tab);
    }

    public void addTab(String persistentID, Map<String, String> properties) {
        if (this.findNode(persistentID) != null) {
            DockingSimplePanelNode node = null;
            for (DockingSimplePanelNode tab : this.tabs) {
                if (!persistentID.equals(tab.getPersistentID())) continue;
                node = tab;
            }
            if (node != null) {
                this.tabs.remove(node);
                this.tabs.add(node);
            }
            return;
        }
        String className = DockingInternal.get(this.docking).getDockable(persistentID).getClass().getCanonicalName();
        DockingSimplePanelNode tab = new DockingSimplePanelNode(this.docking, persistentID, className, properties);
        tab.setParent(this);
        this.tabs.add(tab);
    }

    public void setProperties(String persistentID, Map<String, String> properties) {
        Optional<DockingSimplePanelNode> first = this.tabs.stream().filter(dockingSimplePanelNode -> dockingSimplePanelNode.getPersistentID().equals(persistentID)).findFirst();
        first.ifPresent(dockingSimplePanelNode -> dockingSimplePanelNode.setProperties(properties));
    }

    public List<DockingSimplePanelNode> getPersistentIDs() {
        return new ArrayList<DockingSimplePanelNode>(this.tabs);
    }

    public String getSelectedTabID() {
        return this.selectedTabID;
    }

    @Override
    public DockingLayoutNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DockingLayoutNode parent) {
        this.parent = parent;
    }

    @Override
    public DockingLayoutNode findNode(String persistentID) {
        for (DockingSimplePanelNode tab : this.tabs) {
            if (!persistentID.equals(tab.getPersistentID())) continue;
            return tab;
        }
        return null;
    }

    @Override
    public void dock(String persistentID, DockingRegion region, double dividerProportion) {
        if (region == DockingRegion.CENTER) {
            this.addTab(persistentID);
        } else {
            DockingTabPanelNode right;
            DockingLayoutNode left;
            int orientation;
            int n = orientation = region == DockingRegion.EAST || region == DockingRegion.WEST ? 1 : 0;
            if (Settings.alwaysDisplayTabsMode(DockingInternal.get(this.docking).getDockable(persistentID))) {
                left = region == DockingRegion.NORTH || region == DockingRegion.WEST ? new DockingTabPanelNode(this.docking, persistentID) : this;
                right = region == DockingRegion.NORTH || region == DockingRegion.WEST ? this : new DockingTabPanelNode(this.docking, persistentID);
            } else {
                String className = DockingInternal.get(this.docking).getDockable(persistentID).getClass().getCanonicalName();
                left = region == DockingRegion.NORTH || region == DockingRegion.WEST ? new DockingSimplePanelNode(this.docking, persistentID, className) : this;
                DockingLayoutNode dockingLayoutNode = right = region == DockingRegion.NORTH || region == DockingRegion.WEST ? this : new DockingSimplePanelNode(this.docking, persistentID, className);
            }
            if (region == DockingRegion.EAST || region == DockingRegion.SOUTH) {
                dividerProportion = 1.0 - dividerProportion;
            }
            DockingLayoutNode oldParent = this.parent;
            DockingSplitPanelNode split = new DockingSplitPanelNode(this.docking, left, right, orientation, dividerProportion);
            oldParent.replaceChild(this, split);
        }
    }

    @Override
    public void replaceChild(DockingLayoutNode child, DockingLayoutNode newChild) {
    }

    public void bringToFront(DockingLayoutNode node) {
        for (DockingSimplePanelNode tab : this.tabs) {
            if (tab != node) continue;
            this.selectedTabID = tab.getPersistentID();
            break;
        }
    }
}

