/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.layouts;

import ModernDocking.layouts.DockingLayoutNode;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class WindowLayout {
    private boolean isMainFrame;
    private final Point location;
    private final boolean hasSizeAndLocationInformation;
    private final Dimension size;
    private final int state;
    private final Dialog.ModalityType modalityType;
    private final DockingLayoutNode rootNode;
    private String maximizedDockable = null;
    private final List<String> westUnpinnedToolbarIDs = new ArrayList<String>();
    private final List<String> eastUnpinnedToolbarIDs = new ArrayList<String>();
    private final List<String> southUnpinnedToolbarIDs = new ArrayList<String>();

    public WindowLayout(boolean isMainFrame, Point location, Dimension size, int state, DockingLayoutNode rootNode) {
        this.isMainFrame = isMainFrame;
        this.location = location;
        this.size = size;
        this.state = state;
        this.rootNode = rootNode;
        this.modalityType = Dialog.ModalityType.MODELESS;
        this.hasSizeAndLocationInformation = true;
    }

    public WindowLayout(DockingLayoutNode rootNode) {
        this.rootNode = rootNode;
        this.state = 0;
        this.hasSizeAndLocationInformation = false;
        this.location = new Point();
        this.size = new Dimension();
        this.modalityType = Dialog.ModalityType.MODELESS;
    }

    public WindowLayout(Window window, DockingLayoutNode rootNode) {
        this.rootNode = rootNode;
        this.location = window.getLocation();
        this.size = window.getSize();
        if (window instanceof JFrame) {
            this.state = ((JFrame)window).getExtendedState();
            this.modalityType = Dialog.ModalityType.MODELESS;
        } else {
            this.state = 0;
            this.modalityType = ((JDialog)window).getModalityType();
        }
        this.hasSizeAndLocationInformation = true;
    }

    public boolean isMainFrame() {
        return this.isMainFrame;
    }

    public Point getLocation() {
        return this.location;
    }

    public Dimension getSize() {
        return this.size;
    }

    public int getState() {
        return this.state;
    }

    public Dialog.ModalityType getModalityType() {
        return this.modalityType;
    }

    public DockingLayoutNode getRootNode() {
        return this.rootNode;
    }

    public void setMaximizedDockable(String persistentID) {
        this.maximizedDockable = persistentID;
    }

    public String getMaximizedDockable() {
        return this.maximizedDockable;
    }

    public void setWestUnpinnedToolbarIDs(List<String> ids) {
        this.westUnpinnedToolbarIDs.clear();
        this.westUnpinnedToolbarIDs.addAll(ids);
    }

    public List<String> getWestUnpinnedToolbarIDs() {
        return this.westUnpinnedToolbarIDs;
    }

    public void setEastUnpinnedToolbarIDs(List<String> ids) {
        this.eastUnpinnedToolbarIDs.clear();
        this.eastUnpinnedToolbarIDs.addAll(ids);
    }

    public List<String> getEastUnpinnedToolbarIDs() {
        return this.eastUnpinnedToolbarIDs;
    }

    public void setSouthUnpinnedToolbarIDs(List<String> ids) {
        this.southUnpinnedToolbarIDs.clear();
        this.southUnpinnedToolbarIDs.addAll(ids);
    }

    public List<String> getSouthUnpinnedToolbarIDs() {
        return this.southUnpinnedToolbarIDs;
    }

    public boolean hasSizeAndLocationInformation() {
        return this.hasSizeAndLocationInformation;
    }
}

