/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.ui;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class HeaderModel {
    public final Dockable dockable;
    private final DockingAPI docking;

    public HeaderModel(Dockable dockable, DockingAPI docking) {
        this.dockable = dockable;
        this.docking = docking;
    }

    public String titleText() {
        return this.dockable.getTabText();
    }

    public Icon icon() {
        return this.dockable.getIcon();
    }

    public boolean isPinnedAllowed() {
        return this.dockable.isPinningAllowed();
    }

    public boolean isUnpinned() {
        return this.docking.isUnpinned(this.dockable);
    }

    public boolean isMaximizeAllowed() {
        return this.dockable.isMinMaxAllowed();
    }

    public boolean isMaximized() {
        return this.docking.isMaximized(this.dockable);
    }

    public boolean isCloseAllowed() {
        return this.dockable.isClosable();
    }

    public boolean hasMoreOptions() {
        return this.dockable.getHasMoreOptions();
    }

    public boolean isFloatingAllowed() {
        return this.dockable.isFloatingAllowed();
    }

    public void addMoreOptions(JPopupMenu menu) {
        this.dockable.addMoreOptions(menu);
    }
}

