/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.floating;

import ModernDocking.Dockable;
import ModernDocking.DockableStyle;
import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.internal.DisplayPanel;
import ModernDocking.internal.DockingInternal;
import ModernDocking.ui.DockingSettings;
import ModernDocking.ui.ToolbarLocation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DockingOverlay {
    private static final double REGION_SENSITIVITY = 0.35;
    private final RootDockingPanelAPI targetRoot;
    private JPanel floating;
    private Dockable targetDockable;
    private DockingRegion dockableRegion;
    private DockingRegion rootRegion;
    private ToolbarLocation pinToolbarLocation;
    private Point location = new Point(0, 0);
    private Dimension size;
    private final DockingAPI docking;
    private final JFrame utilFrame;
    private boolean visible = false;
    private boolean visibleOverride = false;
    private boolean overTab = false;
    public Rectangle targetTab;
    public boolean beforeTab = true;

    public DockingOverlay(DockingAPI docking, JFrame utilFrame, RootDockingPanelAPI root) {
        this.docking = docking;
        this.utilFrame = utilFrame;
        this.targetRoot = root;
        this.size = utilFrame.getSize();
    }

    public void setActive(boolean active) {
        this.visible = active;
        this.floating = null;
        this.targetDockable = null;
        this.dockableRegion = null;
        this.rootRegion = null;
        this.size = new Dimension(0, 0);
    }

    public void setFloating(JPanel dockable) {
        this.floating = dockable;
    }

    public void setTargetDockable(Dockable dockable) {
        this.targetDockable = dockable;
    }

    private boolean isRegionAllowed(DockingRegion region) {
        if (this.floating instanceof DisplayPanel) {
            DisplayPanel panel = (DisplayPanel)this.floating;
            Dockable floating = panel.getWrapper().getDockable();
            if (floating.getStyle() == DockableStyle.BOTH) {
                return true;
            }
            if (region == DockingRegion.NORTH || region == DockingRegion.SOUTH) {
                return floating.getStyle() == DockableStyle.HORIZONTAL;
            }
            return floating.getStyle() == DockableStyle.VERTICAL;
        }
        return true;
    }

    public void update(Point screenPos) {
        if (this.targetRoot != null && this.rootRegion != null) {
            Point point = this.targetRoot.getLocation();
            Dimension size = this.targetRoot.getSize();
            point = SwingUtilities.convertPoint(this.targetRoot.getParent(), point, this.utilFrame);
            DockingRegion lastSelectedRegion = this.rootRegion;
            double DROP_SIZE = 4.0;
            switch (this.rootRegion) {
                case WEST: {
                    size = new Dimension((int)((double)size.width / 4.0), size.height);
                    break;
                }
                case NORTH: {
                    size = new Dimension(size.width, (int)((double)size.height / 4.0));
                    break;
                }
                case EAST: {
                    point.x = (int)((double)point.x + ((double)size.width - (double)size.width / 4.0));
                    size = new Dimension((int)((double)size.width / 4.0), size.height);
                    break;
                }
                case SOUTH: {
                    point.y = (int)((double)point.y + ((double)size.height - (double)size.height / 4.0));
                    size = new Dimension(size.width, (int)((double)size.height / 4.0));
                }
            }
            this.location = point;
            this.size = size;
        } else if (this.targetDockable != null && this.dockableRegion != null) {
            DisplayPanel component = DockingInternal.get(this.docking).getWrapper(this.targetDockable).getDisplayPanel();
            Point point = component.getLocation();
            Dimension size = component.getSize();
            point = SwingUtilities.convertPoint(component.getParent(), point, this.utilFrame);
            DockingRegion lastSelectedRegion = this.dockableRegion;
            double DROP_SIZE = 2.0;
            switch (this.dockableRegion) {
                case WEST: {
                    size = new Dimension((int)((double)size.width / 2.0), size.height);
                    break;
                }
                case NORTH: {
                    size = new Dimension(size.width, (int)((double)size.height / 2.0));
                    break;
                }
                case EAST: {
                    point.x = (int)((double)point.x + (double)size.width / 2.0);
                    size = new Dimension((int)((double)size.width / 2.0), size.height);
                    break;
                }
                case SOUTH: {
                    point.y = (int)((double)point.y + (double)size.height / 2.0);
                    size = new Dimension(size.width, (int)((double)size.height / 2.0));
                }
            }
            this.location = point;
            this.size = size;
        } else if (this.targetDockable != null) {
            double verticalEdgeDist;
            DisplayPanel component = DockingInternal.get(this.docking).getWrapper(this.targetDockable).getDisplayPanel();
            Point framePoint = new Point(screenPos);
            SwingUtilities.convertPointFromScreen(framePoint, this.utilFrame);
            Point point = component.getLocation();
            Dimension size = component.getSize();
            point = SwingUtilities.convertPoint(component.getParent(), point, this.utilFrame);
            double horizontalPct = (double)(framePoint.x - point.x) / (double)size.width;
            double verticalPct = (double)(framePoint.y - point.y) / (double)size.height;
            double horizontalEdgeDist = horizontalPct > 0.5 ? 1.0 - horizontalPct : horizontalPct;
            double d = verticalEdgeDist = verticalPct > 0.5 ? 1.0 - verticalPct : verticalPct;
            if (horizontalEdgeDist < verticalEdgeDist) {
                if (horizontalPct < 0.35 && this.isRegionAllowed(DockingRegion.WEST)) {
                    DockingRegion lastSelectedRegion = DockingRegion.WEST;
                    size = new Dimension(size.width / 2, size.height);
                } else if (horizontalPct > 0.65 && this.isRegionAllowed(DockingRegion.EAST)) {
                    DockingRegion lastSelectedRegion = DockingRegion.EAST;
                    point.x += size.width / 2;
                    size = new Dimension(size.width / 2, size.height);
                }
            } else if (verticalPct < 0.35 && this.isRegionAllowed(DockingRegion.NORTH)) {
                DockingRegion lastSelectedRegion = DockingRegion.NORTH;
                size = new Dimension(size.width, size.height / 2);
            } else if (verticalPct > 0.65 && this.isRegionAllowed(DockingRegion.SOUTH)) {
                DockingRegion lastSelectedRegion = DockingRegion.SOUTH;
                point.y += size.height / 2;
                size = new Dimension(size.width, size.height / 2);
            }
            this.location = point;
            this.size = size;
        } else if (this.targetRoot != null) {
            RootDockingPanelAPI component = this.targetRoot;
            Point point = component.getLocation();
            Dimension size = component.getSize();
            point = SwingUtilities.convertPoint(component.getParent(), point, this.utilFrame);
            DockingRegion lastSelectedRegion = DockingRegion.CENTER;
            this.location = point;
            this.size = size;
        }
        this.utilFrame.revalidate();
        this.utilFrame.repaint();
    }

    public DockingRegion getRegion(Point screenPos) {
        double verticalEdgeDist;
        if (this.rootRegion != null) {
            return this.rootRegion;
        }
        if (this.dockableRegion != null) {
            return this.dockableRegion;
        }
        if (this.targetRoot.getPanel() == null) {
            return DockingRegion.CENTER;
        }
        JPanel component = this.targetDockable != null ? DockingInternal.get(this.docking).getWrapper(this.targetDockable).getDisplayPanel() : this.targetRoot;
        Point framePoint = new Point(screenPos);
        SwingUtilities.convertPointFromScreen(framePoint, component.getParent());
        Point point = component.getLocation();
        Dimension size = component.getSize();
        double horizontalPct = (double)(framePoint.x - point.x) / (double)size.width;
        double verticalPct = (double)(framePoint.y - point.y) / (double)size.height;
        double horizontalEdgeDist = horizontalPct > 0.5 ? 1.0 - horizontalPct : horizontalPct;
        double d = verticalEdgeDist = verticalPct > 0.5 ? 1.0 - verticalPct : verticalPct;
        if (horizontalEdgeDist < verticalEdgeDist) {
            if (horizontalPct < 0.35 && this.isRegionAllowed(DockingRegion.WEST)) {
                return DockingRegion.WEST;
            }
            if (horizontalPct > 0.65 && this.isRegionAllowed(DockingRegion.EAST)) {
                return DockingRegion.EAST;
            }
        } else {
            if (verticalPct < 0.35 && this.isRegionAllowed(DockingRegion.NORTH)) {
                return DockingRegion.NORTH;
            }
            if (verticalPct > 0.65 && this.isRegionAllowed(DockingRegion.SOUTH)) {
                return DockingRegion.SOUTH;
            }
        }
        return DockingRegion.CENTER;
    }

    public ToolbarLocation getToolbarLocation() {
        return this.pinToolbarLocation;
    }

    public boolean isDockingToRoot() {
        if (this.targetRoot.getPanel() == null) {
            return true;
        }
        return this.rootRegion != null;
    }

    public boolean isDockingToDockable() {
        return this.dockableRegion != null || this.targetDockable != null;
    }

    public boolean isDockingToPin() {
        return this.pinToolbarLocation != null;
    }

    public void setTargetRootRegion(DockingRegion region) {
        this.rootRegion = region;
        this.visibleOverride = !this.isDockingToRoot() && !this.isDockingToDockable();
    }

    public void setTargetDockableRegion(DockingRegion region) {
        if (this.overTab) {
            return;
        }
        this.dockableRegion = region;
        this.visibleOverride = !this.isDockingToRoot() && !this.isDockingToDockable();
    }

    public void setOverTab(boolean overTab) {
        this.overTab = overTab;
        if (overTab) {
            this.dockableRegion = DockingRegion.CENTER;
        }
    }

    public void setTargetPinRegion(ToolbarLocation region) {
        this.pinToolbarLocation = region;
        this.visibleOverride = !this.isDockingToRoot() && !this.isDockingToDockable();
    }

    public void paint(Graphics g) {
        if (!this.isDockingToRoot() && !this.isDockingToDockable()) {
            return;
        }
        if (this.isDockingToPin()) {
            return;
        }
        if (this.visible) {
            g.setColor(DockingSettings.getOverlayBackground());
            g.fillRect(this.location.x, this.location.y, this.size.width, this.size.height);
            if (this.overTab) {
                g.fillRect(this.targetTab.x, this.targetTab.y, this.targetTab.width, this.targetTab.height);
            }
        }
    }
}

