/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.floating;

import ModernDocking.Dockable;
import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.floating.DockingUtilsFrame;
import ModernDocking.floating.TempFloatingFrame;
import ModernDocking.internal.CustomTabbedPane;
import ModernDocking.internal.DisplayPanel;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.internal.DockingComponentUtils;
import ModernDocking.internal.DockingPanel;
import ModernDocking.internal.FloatingFrame;
import ModernDocking.layouts.WindowLayout;
import ModernDocking.settings.Settings;
import ModernDocking.ui.DockingHeaderUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FloatListener
extends DragSourceAdapter
implements DragSourceListener,
DragSourceMotionListener {
    private static boolean isFloating = false;
    private static boolean isOverTab = false;
    private final JPanel source;
    private JPanel floatingPanel;
    private final DockingAPI docking;
    private final DragSource dragSource = new DragSource();
    private final Component draggedObject;
    private Point dragOffset = new Point(0, 0);
    private TempFloatingFrame floatingFrame;
    private static final Map<Window, DockingUtilsFrame> utilFrames = new HashMap<Window, DockingUtilsFrame>();
    private DockingUtilsFrame activeUtilsFrame = null;
    private static Window windowToDispose = null;
    private Window currentTopWindow = null;
    private Window currentTargetWindow = null;
    private Window originalWindow;
    private WindowLayout windowLayout;
    private Dialog.ModalityType modalityType = Dialog.ModalityType.MODELESS;

    public static boolean isFloating() {
        return isFloating;
    }

    public FloatListener(DockingAPI docking, DisplayPanel panel) {
        this(docking, panel, (JComponent)((Object)panel.getWrapper().getHeaderUI()));
    }

    public FloatListener(DockingAPI docking, DockedTabbedPanel tabs, JComponent dragSource) {
        this(docking, (JPanel)tabs, dragSource);
    }

    private FloatListener(DockingAPI docking, JPanel dockable, JComponent dragSource) {
        this.source = dockable;
        this.docking = docking;
        this.draggedObject = dragSource;
        if (this.draggedObject != null) {
            this.dragSource.addDragSourceMotionListener(this);
            this.dragSource.createDefaultDragGestureRecognizer(dragSource, 2, dge -> {
                if (isFloating) {
                    return;
                }
                try {
                    if (this.source instanceof DockedTabbedPanel) {
                        Point mousePos = new Point(dge.getDragOrigin());
                        SwingUtilities.convertPointToScreen(mousePos, this.draggedObject);
                        DockedTabbedPanel tabs = (DockedTabbedPanel)this.source;
                        if (tabs.getDockables().isEmpty()) {
                            this.removeListeners();
                            return;
                        }
                        int targetTabIndex = tabs.getTargetTabIndex(mousePos);
                        if (targetTabIndex != -1) {
                            this.floatingPanel = tabs.getDockables().get(targetTabIndex).getDisplayPanel();
                        } else if (tabs.isDraggingFromTabGutter(mousePos)) {
                            this.floatingPanel = tabs;
                        } else {
                            DockingHeaderUI headerUI = tabs.getDockables().get(tabs.getSelectedTabIndex()).getHeaderUI();
                            JPanel panel = (JPanel)((Object)headerUI);
                            if (panel.contains(mousePos)) {
                                this.floatingPanel = tabs.getDockables().get(tabs.getSelectedTabIndex()).getDisplayPanel();
                            } else {
                                return;
                            }
                        }
                    }
                    this.dragSource.startDrag(dge, Cursor.getPredefinedCursor(13), new StringSelection(""), this);
                }
                catch (InvalidDnDOperationException ignored) {
                    return;
                }
                this.mouseDragStarted(dge.getDragOrigin());
                if (this.originalWindow instanceof JDialog) {
                    this.modalityType = ((JDialog)this.originalWindow).getModalityType();
                    ((JDialog)this.originalWindow).setModalityType(Dialog.ModalityType.MODELESS);
                    SwingUtilities.invokeLater(() -> {
                        if (this.floatingFrame != null) {
                            this.floatingFrame.toFront();
                        }
                    });
                    SwingUtilities.invokeLater(() -> {
                        if (this.activeUtilsFrame != null) {
                            this.activeUtilsFrame.toFront();
                        }
                    });
                }
            });
        }
    }

    public void removeListeners() {
        this.dragSource.removeDragSourceMotionListener(this);
    }

    public static void registerDockingWindow(DockingAPI docking, Window window, RootDockingPanelAPI root) {
        utilFrames.put(window, new DockingUtilsFrame(docking, window, root));
    }

    public static void deregisterDockingWindow(Window window) {
        utilFrames.remove(window);
    }

    private void updateFramePosition(Point mousePosOnScreen) {
        boolean isModal;
        Point framePos = new Point(mousePosOnScreen.x - this.dragOffset.x, mousePosOnScreen.y - this.dragOffset.y);
        this.floatingFrame.setLocation(framePos);
        Window frame = DockingComponentUtils.findRootAtScreenPos(this.docking, mousePosOnScreen);
        if (this.currentTopWindow != null && this.currentTopWindow.getBounds().contains(mousePosOnScreen)) {
            frame = this.currentTopWindow;
        }
        boolean bl = isModal = this.modalityType == Dialog.ModalityType.TOOLKIT_MODAL || this.modalityType == Dialog.ModalityType.APPLICATION_MODAL;
        if (frame != this.currentTargetWindow && !isModal) {
            this.currentTargetWindow = frame;
            this.currentTopWindow = frame;
            this.changeFrameOverlays(frame);
        }
        Dockable dockable = DockingComponentUtils.findDockableAtScreenPos(mousePosOnScreen, this.currentTopWindow);
        if (this.activeUtilsFrame != null) {
            this.activeUtilsFrame.setFloating(this.floatingPanel);
            this.activeUtilsFrame.setTargetDockable(dockable);
            this.activeUtilsFrame.update(mousePosOnScreen);
        }
        CustomTabbedPane tabbedPane = DockingComponentUtils.findTabbedPaneAtPos(mousePosOnScreen, this.currentTopWindow);
        if (this.activeUtilsFrame != null) {
            boolean overTab;
            boolean bl2 = overTab = dockable == null && tabbedPane != null && this.floatingPanel instanceof DisplayPanel;
            if (overTab) {
                Rectangle boundsAt;
                int targetTabIndex = tabbedPane.getTargetTabIndex(mousePosOnScreen, true);
                boolean last = false;
                if (targetTabIndex != -1) {
                    boundsAt = tabbedPane.getBoundsAt(targetTabIndex);
                    Point p = new Point(boundsAt.x, boundsAt.y);
                    SwingUtilities.convertPointToScreen(p, tabbedPane);
                    SwingUtilities.convertPointFromScreen(p, this.activeUtilsFrame);
                    boundsAt.x = p.x;
                    boundsAt.y = p.y;
                    boundsAt.width /= 2;
                } else {
                    boundsAt = tabbedPane.getBoundsAt(tabbedPane.getTabCount() - 1);
                    Point tabPoint = new Point(tabbedPane.getX(), tabbedPane.getY());
                    SwingUtilities.convertPointToScreen(tabPoint, tabbedPane.getParent());
                    Point boundsPoint = new Point(boundsAt.x, boundsAt.y);
                    SwingUtilities.convertPointToScreen(boundsPoint, tabbedPane);
                    int widthToAdd = boundsAt.width;
                    if (boundsPoint.x + boundsAt.width * 2 >= tabPoint.x + tabbedPane.getWidth()) {
                        boundsAt.width = Math.abs(tabPoint.x + tabbedPane.getWidth() - (boundsPoint.x + boundsAt.width));
                    }
                    SwingUtilities.convertPointFromScreen(boundsPoint, this.activeUtilsFrame);
                    boundsAt.x = boundsPoint.x + widthToAdd;
                    boundsAt.y = boundsPoint.y;
                    last = true;
                }
                this.activeUtilsFrame.setOverTab(true, boundsAt, last);
                this.activeUtilsFrame.update(mousePosOnScreen);
                this.floatingFrame.setVisible(false);
            } else if (isOverTab) {
                this.activeUtilsFrame.setOverTab(false, null, false);
                this.floatingFrame.setVisible(true);
                this.reorderWindows();
            }
            isOverTab = overTab;
        }
        if (tabbedPane != null && tabbedPane.getSelectedComponent() instanceof DisplayPanel) {
            DisplayPanel panel = (DisplayPanel)tabbedPane.getSelectedComponent();
            if (this.activeUtilsFrame != null) {
                this.activeUtilsFrame.setFloating(this.floatingPanel);
                this.activeUtilsFrame.setTargetDockable(panel.getWrapper().getDockable());
                this.activeUtilsFrame.update(mousePosOnScreen);
            }
        }
    }

    private void changeFrameOverlays(Window newWindow) {
        if (this.activeUtilsFrame != null) {
            this.activeUtilsFrame.setActive(false);
            this.activeUtilsFrame = null;
        }
        if (newWindow != null) {
            this.activeUtilsFrame = utilFrames.get(newWindow);
            if (this.currentTopWindow != null && this.floatingFrame != null && this.activeUtilsFrame != null) {
                Point mousePos = MouseInfo.getPointerInfo().getLocation();
                this.activeUtilsFrame.setFloating(this.floatingPanel);
                this.activeUtilsFrame.update(mousePos);
                this.activeUtilsFrame.setActive(true);
                this.reorderWindows();
            }
        }
    }

    private void reorderWindows() {
        SwingUtilities.invokeLater(() -> {
            if (this.currentTopWindow != null) {
                this.currentTopWindow.toFront();
            }
        });
        SwingUtilities.invokeLater(() -> {
            if (this.floatingFrame != null) {
                this.floatingFrame.toFront();
            }
        });
        SwingUtilities.invokeLater(() -> {
            if (this.activeUtilsFrame != null) {
                this.activeUtilsFrame.toFront();
            }
        });
    }

    public void mouseDragStarted(Point point) {
        isFloating = true;
        this.dragOffset = point;
        this.dragOffset.y = Math.max(5, this.dragOffset.y);
        this.dragOffset.x = Math.max(5, this.dragOffset.x);
        this.currentTargetWindow = null;
        Point mousePos = new Point(point);
        SwingUtilities.convertPointToScreen(mousePos, this.draggedObject);
        if (this.source instanceof DisplayPanel) {
            this.originalWindow = ((DisplayPanel)this.source).getWrapper().getWindow();
            this.floatingPanel = this.source;
        } else {
            this.originalWindow = ((DockedTabbedPanel)this.source).getDockables().get(0).getWindow();
        }
        this.windowLayout = this.docking.getDockingState().getWindowLayout(this.originalWindow);
        RootDockingPanelAPI currentRoot = DockingComponentUtils.rootForWindow(this.docking, this.originalWindow);
        if (this.floatingPanel instanceof DisplayPanel) {
            this.floatingFrame = Settings.alwaysDisplayTabsMode(((DisplayPanel)this.floatingPanel).getWrapper().getDockable()) ? new TempFloatingFrame(Collections.singletonList(((DisplayPanel)this.floatingPanel).getWrapper()), 0, this.source, this.floatingPanel.getSize()) : new TempFloatingFrame(((DisplayPanel)this.floatingPanel).getWrapper(), this.source, this.floatingPanel.getSize());
            this.docking.undock(((DisplayPanel)this.floatingPanel).getWrapper().getDockable());
        } else {
            DockedTabbedPanel tabs = (DockedTabbedPanel)this.floatingPanel;
            ArrayList<DockableWrapper> wrappers = new ArrayList<DockableWrapper>(tabs.getDockables());
            this.floatingFrame = new TempFloatingFrame(wrappers, tabs.getSelectedTabIndex(), this.source, this.floatingPanel.getSize());
            for (DockableWrapper wrapper : wrappers) {
                this.docking.undock(wrapper.getDockable());
            }
        }
        DockingComponentUtils.removeIllegalFloats(this.docking, this.originalWindow);
        if (this.originalWindow != null && currentRoot != null && currentRoot.getPanel() == null && this.docking.canDisposeWindow(this.originalWindow)) {
            windowToDispose = this.originalWindow;
            windowToDispose.setVisible(false);
        }
        if (this.originalWindow != windowToDispose) {
            this.currentTopWindow = this.originalWindow;
            this.currentTargetWindow = this.originalWindow;
            this.activeUtilsFrame = utilFrames.get(this.originalWindow);
        }
        if (this.activeUtilsFrame != null) {
            this.activeUtilsFrame.setFloating(this.floatingPanel);
            this.activeUtilsFrame.update(mousePos);
            this.activeUtilsFrame.setActive(true);
            this.activeUtilsFrame.toFront();
        }
        this.docking.getAppState().setPaused(true);
    }

    private void dropFloatingPanel() {
        DockingRegion region;
        this.docking.getAppState().setPaused(false);
        Point mousePos = MouseInfo.getPointerInfo().getLocation();
        Point point = MouseInfo.getPointerInfo().getLocation();
        RootDockingPanelAPI root = this.currentTopWindow == null ? null : DockingComponentUtils.rootForWindow(this.docking, this.currentTopWindow);
        DockingPanel dockingPanel = DockingComponentUtils.findDockingPanelAtScreenPos(point, this.currentTopWindow);
        Dockable dockableAtPos = DockingComponentUtils.findDockableAtScreenPos(point, this.currentTopWindow);
        DockingRegion dockingRegion = region = this.activeUtilsFrame != null ? this.activeUtilsFrame.getRegion(mousePos) : DockingRegion.CENTER;
        if (this.floatingPanel instanceof DisplayPanel) {
            DockableWrapper floatingDockable = ((DisplayPanel)this.floatingPanel).getWrapper();
            if (this.activeUtilsFrame != null && this.activeUtilsFrame.isDockingToPin()) {
                this.docking.unpinDockable(floatingDockable.getDockable(), this.activeUtilsFrame.getToolbarLocation(), this.currentTopWindow, root);
            } else if (root != null && this.activeUtilsFrame != null && this.activeUtilsFrame.isDockingToRoot()) {
                this.docking.dock(floatingDockable.getDockable(), this.currentTopWindow, region, 0.25);
            } else if (floatingDockable.getDockable().isLimitedToRoot() && floatingDockable.getRoot() != root) {
                this.docking.getDockingState().restoreWindowLayout(this.originalWindow, this.windowLayout);
            } else if (dockableAtPos != null && this.currentTopWindow != null && dockingPanel != null && this.activeUtilsFrame != null && this.activeUtilsFrame.isDockingToDockable()) {
                this.docking.dock(floatingDockable.getDockable(), dockableAtPos, region);
            } else if (root != null && region != DockingRegion.CENTER && this.activeUtilsFrame == null) {
                this.docking.dock(floatingDockable.getDockable(), this.currentTopWindow, region);
            } else if (!floatingDockable.getDockable().isFloatingAllowed()) {
                this.docking.getDockingState().restoreWindowLayout(this.originalWindow, this.windowLayout);
            } else if (dockableAtPos == null && root != null) {
                CustomTabbedPane tabbedPane = DockingComponentUtils.findTabbedPaneAtPos(point, this.currentTopWindow);
                if (tabbedPane != null) {
                    DockedTabbedPanel parent = (DockedTabbedPanel)tabbedPane.getParent();
                    int targetTabIndex = tabbedPane.getTargetTabIndex(point, true);
                    if (targetTabIndex != -1) {
                        Rectangle boundsAt = tabbedPane.getBoundsAt(targetTabIndex);
                        Point p = new Point(boundsAt.x, boundsAt.y);
                        SwingUtilities.convertPointToScreen(p, tabbedPane);
                        SwingUtilities.convertPointFromScreen(p, this.activeUtilsFrame);
                        boundsAt.x = p.x;
                        boundsAt.y = p.y;
                        boundsAt.width /= 2;
                    } else {
                        Rectangle boundsAt = tabbedPane.getBoundsAt(tabbedPane.getTabCount() - 1);
                        Point p = new Point(boundsAt.x, boundsAt.y);
                        SwingUtilities.convertPointToScreen(p, tabbedPane);
                        SwingUtilities.convertPointFromScreen(p, this.activeUtilsFrame);
                        boundsAt.x = p.x;
                        boundsAt.y = p.y;
                        boundsAt.x += boundsAt.width;
                    }
                    parent.dockAtIndex(floatingDockable.getDockable(), targetTabIndex);
                }
            } else {
                new FloatingFrame(this.docking, floatingDockable.getDockable(), this.floatingFrame);
            }
        } else {
            ArrayList<DockableWrapper> dockables = new ArrayList<DockableWrapper>(this.floatingFrame.getDockables());
            boolean first = true;
            Dockable firstDockable = null;
            for (DockableWrapper dockable : dockables) {
                if (first) {
                    if (dockableAtPos != null && this.currentTopWindow != null && dockingPanel != null && this.activeUtilsFrame != null && this.activeUtilsFrame.isDockingToDockable()) {
                        this.docking.dock(dockable.getDockable(), dockableAtPos, region);
                    } else {
                        new FloatingFrame(this.docking, dockable.getDockable(), this.floatingFrame);
                    }
                    firstDockable = dockable.getDockable();
                } else {
                    this.docking.dock(dockable.getDockable(), firstDockable, DockingRegion.CENTER);
                }
                first = false;
            }
            this.docking.bringToFront(((DockableWrapper)dockables.get(this.floatingFrame.getSelectedIndex())).getDockable());
        }
        this.docking.getAppState().persist();
        if (this.source instanceof DockedTabbedPanel && ((DockedTabbedPanel)this.source).getDockables().isEmpty()) {
            this.removeListeners();
        }
        if (this.originalWindow instanceof JDialog) {
            ((JDialog)this.originalWindow).setModalityType(this.modalityType);
        }
        this.originalWindow = null;
        if (windowToDispose != null) {
            this.docking.deregisterDockingPanel(windowToDispose);
            windowToDispose.dispose();
            windowToDispose = null;
        }
        this.floatingFrame.dispose();
        this.floatingFrame = null;
        if (this.activeUtilsFrame != null) {
            this.activeUtilsFrame.setTargetDockable(null);
            this.activeUtilsFrame.setFloating(null);
            this.activeUtilsFrame.setActive(false);
            this.activeUtilsFrame = null;
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (!isFloating) {
            return;
        }
        this.dropFloatingPanel();
        isFloating = false;
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dsde) {
        if (!isFloating) {
            return;
        }
        this.updateFramePosition(dsde.getLocation());
    }
}

