/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class CustomTabbedPane
extends JTabbedPane {
    public CustomTabbedPane() {
        this.setFocusable(false);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(37, 512), "press-left");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(39, 512), "press-right");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(37, 8704), "press-left");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(39, 8704), "press-right");
        this.getActionMap().put("press-left", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newIndex = CustomTabbedPane.this.getSelectedIndex() - 1;
                if (newIndex < 0) {
                    newIndex = CustomTabbedPane.this.getTabCount() - 1;
                }
                CustomTabbedPane.this.setSelectedIndex(newIndex);
            }
        });
        this.getActionMap().put("press-right", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newIndex = CustomTabbedPane.this.getSelectedIndex() + 1;
                if (newIndex >= CustomTabbedPane.this.getTabCount()) {
                    newIndex = 0;
                }
                CustomTabbedPane.this.setSelectedIndex(newIndex);
            }
        });
    }

    public int getTargetTabIndex(Point mousePosOnScreen, boolean ignoreY) {
        SwingUtilities.convertPointFromScreen(mousePosOnScreen, this);
        Point d = CustomTabbedPane.isTopBottomTabPlacement(this.getTabPlacement()) ? new Point(1, 0) : new Point(0, 1);
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle tab = this.getBoundsAt(i);
            if (ignoreY) {
                mousePosOnScreen.y = tab.y;
            }
            if (!tab.contains(mousePosOnScreen)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isTopBottomTabPlacement(int tabPlacement) {
        return tabPlacement == 1 || tabPlacement == 3;
    }
}

