/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.internal.DisplayPanel;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockedSplitPanel;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.internal.DockingInternal;
import ModernDocking.internal.DockingListeners;
import ModernDocking.internal.DockingPanel;
import ModernDocking.settings.Settings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.UIManager;

public class DockedSimplePanel
extends DockingPanel {
    private final DockableWrapper dockable;
    private final DockingAPI docking;
    private DockingPanel parent;

    public DockedSimplePanel(DockingAPI docking, DockableWrapper dockable) {
        this(docking, dockable, dockable.getDisplayPanel());
    }

    public DockedSimplePanel(DockingAPI docking, DockableWrapper dockable, DisplayPanel displayPanel) {
        this.setLayout(new BorderLayout());
        this.setNotSelectedBorder();
        dockable.setParent(this);
        this.dockable = dockable;
        this.docking = docking;
        this.add((Component)displayPanel, "Center");
    }

    public DockableWrapper getWrapper() {
        return this.dockable;
    }

    @Override
    public void setParent(DockingPanel parent) {
        this.parent = parent;
    }

    @Override
    public void dock(Dockable dockable, DockingRegion region, double dividerProportion) {
        DockableWrapper wrapper = DockingInternal.get(this.docking).getWrapper(dockable);
        wrapper.setWindow(this.dockable.getWindow());
        if (this.getParent() instanceof DockedTabbedPanel) {
            ((DockedTabbedPanel)this.parent).addPanel(wrapper);
        } else if (region == DockingRegion.CENTER) {
            DockedTabbedPanel tabbedPanel = new DockedTabbedPanel(this.docking, this.dockable);
            tabbedPanel.addPanel(wrapper);
            DockingListeners.fireHiddenEvent(this.dockable.getDockable());
            this.parent.replaceChild(this, tabbedPanel);
        } else {
            DockedSplitPanel split = new DockedSplitPanel(this.docking, this.dockable.getWindow());
            this.parent.replaceChild(this, split);
            DockingPanel newPanel = Settings.alwaysDisplayTabsMode(wrapper.getDockable()) ? new DockedTabbedPanel(this.docking, wrapper) : new DockedSimplePanel(this.docking, wrapper);
            if (region == DockingRegion.EAST || region == DockingRegion.SOUTH) {
                split.setLeft(this);
                split.setRight(newPanel);
                dividerProportion = 1.0 - dividerProportion;
            } else {
                split.setLeft(newPanel);
                split.setRight(this);
            }
            if (region == DockingRegion.EAST || region == DockingRegion.WEST) {
                split.setOrientation(1);
            } else {
                split.setOrientation(0);
            }
            split.setDividerLocation(dividerProportion);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void undock(Dockable dockable) {
        if (this.dockable.getDockable() == dockable) {
            this.remove(this.dockable.getDisplayPanel());
            this.parent.removeChild(this);
            this.dockable.setParent(null);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void replaceChild(DockingPanel child, DockingPanel newChild) {
    }

    @Override
    public void removeChild(DockingPanel child) {
    }

    private void setNotSelectedBorder() {
        Color color = UIManager.getColor("Component.borderColor");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(color, 1)));
    }
}

