/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.floating.TempFloatingFrame;
import ModernDocking.internal.DisplayPanel;
import ModernDocking.internal.DockingInternal;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

public class FloatingFrame
extends JFrame {
    private final DockingAPI docking;

    public FloatingFrame(DockingAPI docking) {
        this.docking = docking;
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        RootDockingPanelAPI root = new RootDockingPanelAPI(docking, this){};
        root.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.add((Component)root, "Center");
        docking.configurePinning(this, JLayeredPane.MODAL_LAYER, true);
        this.setVisible(true);
        this.pack();
    }

    public FloatingFrame(DockingAPI docking, Point location, Dimension size, int state) {
        this.docking = docking;
        this.setLocation(location);
        this.setSize(size);
        this.setExtendedState(state);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        RootDockingPanelAPI root = new RootDockingPanelAPI(docking, this){};
        root.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.add((Component)root, "Center");
        docking.configurePinning(this, JLayeredPane.MODAL_LAYER, true);
        this.setVisible(true);
    }

    public FloatingFrame(DockingAPI docking, Dockable dockable, Point location, Dimension size, int state) {
        this.docking = docking;
        this.setLocation(location);
        this.setSize(size);
        this.setExtendedState(state);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        RootDockingPanelAPI root = new RootDockingPanelAPI(docking, this){};
        root.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.add((Component)root, "Center");
        docking.configurePinning(this, JLayeredPane.MODAL_LAYER, true);
        this.setVisible(true);
        this.finalizeSize(dockable, location, size);
    }

    public FloatingFrame(DockingAPI docking, Dockable dockable, TempFloatingFrame floatingFrame) {
        this.docking = docking;
        this.setLayout(new BorderLayout());
        Dimension size = DockingInternal.get(docking).getWrapper(dockable).getDisplayPanel().getSize();
        this.setSize(size);
        this.setDefaultCloseOperation(2);
        this.setLocation(floatingFrame.getLocation());
        RootDockingPanelAPI root = new RootDockingPanelAPI(docking, this){};
        this.add((Component)root, "Center");
        docking.configurePinning(this, JLayeredPane.MODAL_LAYER, true);
        docking.dock(dockable, (Window)this);
        this.setVisible(true);
        Point onScreenPoint = floatingFrame.getLocation();
        Dimension onScreenSize = floatingFrame.getSize();
        this.finalizeSize(dockable, onScreenPoint, onScreenSize);
    }

    private void finalizeSize(Dockable dockable, Point onScreenPoint, Dimension onScreenSize) {
        SwingUtilities.invokeLater(() -> {
            DisplayPanel displayPanel = DockingInternal.get(this.docking).getWrapper(dockable).getDisplayPanel();
            Point point = displayPanel.getLocation();
            SwingUtilities.convertPointToScreen(point, displayPanel.getParent());
            Point finalPoint = new Point(this.getX() - (point.x - onScreenPoint.x), this.getY() - (point.y - onScreenPoint.y));
            finalPoint.y = Math.max(0, finalPoint.y);
            this.setLocation(finalPoint);
            Dimension currentPanelSize = displayPanel.getSize();
            Dimension currentFrameSize = this.getSize();
            Dimension newSize = new Dimension(currentFrameSize.width - currentPanelSize.width + onScreenSize.width, currentFrameSize.height - currentPanelSize.height + onScreenSize.height);
            this.setSize(newSize);
        });
    }

    @Override
    public void dispose() {
        this.docking.deregisterDockingPanel(this);
        super.dispose();
    }
}

