/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.layouts;

import ModernDocking.layouts.WindowLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ApplicationLayout {
    private final List<FrameLayout> layouts = new ArrayList<FrameLayout>();

    public ApplicationLayout() {
    }

    public ApplicationLayout(WindowLayout mainFrame) {
        this.layouts.add(new FrameLayout(mainFrame, true));
    }

    public void setMainFrame(WindowLayout layout) {
        for (FrameLayout frameLayout : this.layouts) {
            if (!frameLayout.isMainFrame) continue;
            this.layouts.remove(frameLayout);
            break;
        }
        this.layouts.add(new FrameLayout(layout, true));
    }

    public void addFrame(WindowLayout layout) {
        this.layouts.add(new FrameLayout(layout, layout.isMainFrame()));
    }

    public WindowLayout getMainFrameLayout() {
        for (FrameLayout frameLayout : this.layouts) {
            if (!frameLayout.isMainFrame) continue;
            return frameLayout.layout;
        }
        return null;
    }

    public List<WindowLayout> getFloatingFrameLayouts() {
        return this.layouts.stream().filter(layout -> !((FrameLayout)layout).isMainFrame).map(layout -> ((FrameLayout)layout).layout).collect(Collectors.toList());
    }

    private static class FrameLayout {
        private final WindowLayout layout;
        private final boolean isMainFrame;

        private FrameLayout(WindowLayout layout, boolean isMainFrame) {
            this.layout = layout;
            this.isMainFrame = isMainFrame;
        }
    }
}

