/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.persist;

import ModernDocking.Dockable;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.internal.DockedSimplePanel;
import ModernDocking.internal.DockedSplitPanel;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.persist.DockableState;
import ModernDocking.persist.PanelState;
import ModernDocking.persist.SplitState;
import ModernDocking.persist.TabState;

public class RootDockState {
    private final DockableState state;

    public RootDockState(RootDockingPanelAPI panel) {
        if (panel.getPanel() instanceof DockedSimplePanel) {
            Dockable dockable = ((DockedSimplePanel)panel.getPanel()).getWrapper().getDockable();
            this.state = new PanelState(dockable.getPersistentID(), dockable.getClass().getCanonicalName());
        } else if (panel.getPanel() instanceof DockedSplitPanel) {
            this.state = new SplitState((DockedSplitPanel)panel.getPanel());
        } else if (panel.getPanel() instanceof DockedTabbedPanel) {
            this.state = new TabState((DockedTabbedPanel)panel.getPanel());
        } else {
            throw new RuntimeException("Unknown panel");
        }
    }

    public DockableState getState() {
        return this.state;
    }
}

