/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.persist;

import ModernDocking.Dockable;
import ModernDocking.internal.DockedSimplePanel;
import ModernDocking.internal.DockedSplitPanel;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.persist.DockableState;
import ModernDocking.persist.PanelState;
import ModernDocking.persist.TabState;
import javax.swing.JSplitPane;

public class SplitState
implements DockableState {
    private final DockableState left;
    private final DockableState right;
    private final int orientation;
    private final double dividerProportion;
    private final double resizeWeight;

    public SplitState(DockedSplitPanel panel) {
        Dockable dockable;
        JSplitPane splitPane = panel.getSplitPane();
        this.orientation = splitPane.getOrientation();
        this.resizeWeight = panel.getSplitPane().getResizeWeight();
        int height = splitPane.getHeight();
        int dividerSize = splitPane.getDividerSize();
        int dividerLocation = splitPane.getDividerLocation();
        int width = splitPane.getWidth();
        double d = this.dividerProportion = this.orientation == 0 ? (double)((float)dividerLocation / (float)(height - dividerSize)) : (double)((float)dividerLocation / (float)(width - dividerSize));
        if (panel.getLeft() instanceof DockedTabbedPanel) {
            this.left = new TabState((DockedTabbedPanel)panel.getLeft());
        } else if (panel.getLeft() instanceof DockedSimplePanel) {
            dockable = ((DockedSimplePanel)panel.getLeft()).getWrapper().getDockable();
            this.left = new PanelState(dockable.getPersistentID(), dockable.getClass().getCanonicalName());
        } else if (panel.getLeft() instanceof DockedSplitPanel) {
            this.left = new SplitState((DockedSplitPanel)panel.getLeft());
        } else {
            throw new RuntimeException("Unknown panel");
        }
        if (panel.getRight() instanceof DockedTabbedPanel) {
            this.right = new TabState((DockedTabbedPanel)panel.getRight());
        } else if (panel.getRight() instanceof DockedSimplePanel) {
            dockable = ((DockedSimplePanel)panel.getRight()).getWrapper().getDockable();
            this.right = new PanelState(dockable.getPersistentID(), dockable.getClass().getCanonicalName());
        } else if (panel.getRight() instanceof DockedSplitPanel) {
            this.right = new SplitState((DockedSplitPanel)panel.getRight());
        } else {
            throw new RuntimeException("Unknown panel");
        }
    }

    public DockableState getLeft() {
        return this.left;
    }

    public DockableState getRight() {
        return this.right;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public double getDividerProprtion() {
        return this.dividerProportion;
    }

    public double getResizeWeight() {
        return this.resizeWeight;
    }
}

