/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.ui;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import ModernDocking.event.DockingEvent;
import ModernDocking.event.DockingListener;
import ModernDocking.event.MaximizeListener;
import ModernDocking.internal.DockingListeners;
import ModernDocking.ui.DockingHeaderUI;
import ModernDocking.ui.HeaderModel;

public class HeaderController
implements MaximizeListener,
DockingListener {
    private final Dockable dockable;
    private final DockingAPI docking;
    private final HeaderModel model;
    private DockingHeaderUI ui;

    public HeaderController(Dockable dockable, DockingAPI docking, HeaderModel model) {
        this.dockable = dockable;
        this.docking = docking;
        this.model = model;
        DockingListeners.addMaximizeListener(this);
        DockingListeners.addDockingListener(this);
    }

    public void setUI(DockingHeaderUI ui) {
        this.ui = ui;
    }

    public void removeListeners() {
        DockingListeners.removeMaximizeListener(this);
        DockingListeners.removeDockingListener(this);
    }

    public void pinDockable() {
        this.docking.pinDockable(this.dockable);
    }

    public void unpinDockable() {
        this.docking.unpinDockable(this.dockable);
    }

    public void newWindow() {
        this.docking.newWindow(this.dockable);
    }

    public void minimize() {
        this.docking.minimize(this.dockable);
    }

    public void maximize() {
        this.docking.maximize(this.dockable);
    }

    public void close() {
        this.docking.undock(this.dockable);
    }

    @Override
    public void maximized(Dockable dockable, boolean maximized) {
        this.ui.update();
    }

    @Override
    public void dockingChange(DockingEvent e) {
        this.ui.update();
    }
}

