/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrewauclair.moderndocking.app;

import io.github.andrewauclair.moderndocking.app.DockingState;
import io.github.andrewauclair.moderndocking.layouts.ApplicationLayout;
import io.github.andrewauclair.moderndocking.layouts.DockingLayouts;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class ApplicationLayoutMenuItem
extends JMenuItem
implements ActionListener {
    private final String layoutName;

    public ApplicationLayoutMenuItem(String layoutName) {
        super(layoutName);
        this.layoutName = layoutName;
        this.addActionListener(this);
    }

    public ApplicationLayoutMenuItem(String layoutName, String text) {
        super(text);
        this.layoutName = layoutName;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ApplicationLayout layout = DockingLayouts.getLayout((String)this.layoutName);
        if (layout == null) {
            JOptionPane.showMessageDialog(this, "Layout " + this.layoutName + " does not exist.");
        } else {
            DockingState.restoreApplicationLayout(layout);
        }
    }
}

