/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrewauclair.moderndocking.app;

import io.github.andrewauclair.moderndocking.Dockable;
import io.github.andrewauclair.moderndocking.DockingRegion;
import io.github.andrewauclair.moderndocking.api.DockingAPI;
import io.github.andrewauclair.moderndocking.api.RootDockingPanelAPI;
import io.github.andrewauclair.moderndocking.event.DockingListener;
import io.github.andrewauclair.moderndocking.event.MaximizeListener;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class Docking {
    private static DockingAPI instance;

    public static void initialize(Window mainWindow) {
        if (instance == null) {
            instance = new DockingAPI(mainWindow){};
        }
    }

    public static void uninitialize() {
        instance.uninitialize();
        instance = null;
    }

    public static Map<Window, RootDockingPanelAPI> getRootPanels() {
        return instance.getRootPanels();
    }

    public static Window getMainWindow() {
        return instance.getMainWindow();
    }

    public static void registerDockable(Dockable dockable) {
        instance.registerDockable(dockable);
    }

    public static boolean isDockableRegistered(String persistentID) {
        return instance.isDockableRegistered(persistentID);
    }

    public static void deregisterDockable(Dockable dockable) {
        instance.deregisterDockable(dockable);
    }

    public static void deregisterAllDockables() {
        instance.deregisterAllDockables();
    }

    public static List<Dockable> getDockables() {
        return instance.getDockables();
    }

    public static void registerDockingPanel(RootDockingPanelAPI panel, JFrame parent) {
        instance.registerDockingPanel(panel, parent);
    }

    public static void registerDockingPanel(RootDockingPanelAPI panel, JDialog parent) {
        instance.registerDockingPanel(panel, parent);
    }

    public static void deregisterDockingPanel(Window parent) {
        instance.deregisterDockingPanel(parent);
    }

    public static void deregisterAllDockingPanels() {
        instance.deregisterAllDockingPanels();
    }

    public static void configurePinning(Window window, int layer, boolean allow) {
        instance.configurePinning(window, layer, allow);
    }

    public static boolean pinningAllowed(Dockable dockable) {
        return instance.pinningAllowed(dockable);
    }

    public static void dock(String persistentID, Window window) {
        instance.dock(persistentID, window);
    }

    public static void dock(Dockable dockable, Window window) {
        instance.dock(dockable, window);
    }

    public static void dock(String persistentID, Window window, DockingRegion region) {
        instance.dock(persistentID, window, region);
    }

    public static void dock(Dockable dockable, Window window, DockingRegion region) {
        instance.dock(dockable, window, region);
    }

    public static void dock(String persistentID, Window window, DockingRegion region, double dividerProportion) {
        instance.dock(persistentID, window, region, dividerProportion);
    }

    public static void dock(Dockable dockable, Window window, DockingRegion region, double dividerProportion) {
        instance.dock(dockable, window, region, dividerProportion);
    }

    public static void dock(String sourcePersistentID, String targetPersistentID, DockingRegion region) {
        instance.dock(sourcePersistentID, targetPersistentID, region);
    }

    public static void dock(String sourcePersistentID, Dockable target, DockingRegion region) {
        instance.dock(sourcePersistentID, target, region);
    }

    public static void dock(Dockable source, String targetPersistentID, DockingRegion region) {
        instance.dock(source, targetPersistentID, region);
    }

    public static void dock(Dockable source, Dockable target, DockingRegion region) {
        instance.dock(source, target, region);
    }

    public static void dock(String sourcePersistentID, String targetPersistentID, DockingRegion region, double dividerProportion) {
        instance.dock(sourcePersistentID, targetPersistentID, region, dividerProportion);
    }

    public static void dock(Dockable source, Dockable target, DockingRegion region, double dividerProportion) {
        instance.dock(source, target, region, dividerProportion);
    }

    public static void newWindow(String persistentID) {
        instance.newWindow(persistentID);
    }

    public static void newWindow(Dockable dockable) {
        instance.newWindow(dockable);
    }

    public static void newWindow(String persistentID, Point location, Dimension size) {
        instance.newWindow(persistentID, location, size);
    }

    public static void newWindow(Dockable dockable, Point location, Dimension size) {
        instance.newWindow(dockable, location, size);
    }

    public static void bringToFront(Dockable dockable) {
        instance.bringToFront(dockable);
    }

    public static void undock(String persistentID) {
        instance.undock(persistentID);
    }

    public static void undock(Dockable dockable) {
        instance.undock(dockable);
    }

    public static boolean isDocked(String persistentID) {
        return instance.isDocked(persistentID);
    }

    public static boolean isDocked(Dockable dockable) {
        return instance.isDocked(dockable);
    }

    public static boolean isUnpinned(String persistentID) {
        return instance.isHidden(persistentID);
    }

    public static boolean isUnpinned(Dockable dockable) {
        return instance.isHidden(dockable);
    }

    public static boolean isHidden(String persistentID) {
        return instance.isHidden(persistentID);
    }

    public static boolean isHidden(Dockable dockable) {
        return instance.isHidden(dockable);
    }

    public static boolean canDisposeWindow(Window window) {
        return instance.canDisposeWindow(window);
    }

    public static boolean isMaximized(Dockable dockable) {
        return instance.isMaximized(dockable);
    }

    public static void maximize(Dockable dockable) {
        instance.maximize(dockable);
    }

    public static void minimize(Dockable dockable) {
        instance.minimize(dockable);
    }

    public static void pinDockable(Dockable dockable) {
        instance.pinDockable(dockable);
    }

    public static void unpinDockable(Dockable dockable) {
        instance.unpinDockable(dockable);
    }

    public static void display(String persistentID) {
        instance.display(persistentID);
    }

    public static void display(Dockable dockable) {
        instance.display(dockable);
    }

    public static void updateTabInfo(String persistentID) {
        instance.updateTabInfo(persistentID);
    }

    public static void updateTabInfo(Dockable dockable) {
        instance.updateTabInfo(dockable);
    }

    public static void addMaximizeListener(MaximizeListener listener) {
        instance.addMaximizeListener(listener);
    }

    public static void removeMaximizeListener(MaximizeListener listener) {
        instance.removeMaximizeListener(listener);
    }

    public static void addDockingListener(DockingListener listener) {
        instance.addDockingListener(listener);
    }

    public static void removeDockingListener(DockingListener listener) {
        instance.removeDockingListener(listener);
    }

    public static DockingAPI getSingleInstance() {
        if (instance == null) {
            throw new RuntimeException("No docking instance available.");
        }
        return instance;
    }
}

