/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.ext.ui;

import ModernDocking.ext.ui.FlatLafHeaderUI;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.internal.DockingInternal;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DockingUI {
    private static boolean initialized = false;
    private static PropertyChangeListener propertyChangeListener;
    private static FlatSVGIcon settingsIcon;

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        DockingInternal.createHeaderUI = FlatLafHeaderUI::new;
        if (!settingsIcon.hasFound()) {
            throw new RuntimeException("settings.svg icon not found");
        }
        DockedTabbedPanel.setSettingsIcon((Icon)settingsIcon);
        Color foreground = UIManager.getColor("TableHeader.foreground");
        settingsIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> foreground));
        propertyChangeListener = e -> {
            if ("lookAndFeel".equals(e.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    Color newForeground = UIManager.getColor("TableHeader.foreground");
                    settingsIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> newForeground));
                });
            }
        };
        UIManager.addPropertyChangeListener(propertyChangeListener);
    }

    public static void setSettingsIconColorProperty(String property) {
        if (!initialized) {
            return;
        }
        Color foreground = UIManager.getColor(property);
        if (foreground == null) {
            throw new RuntimeException("Color for UI property '" + property + "' not found");
        }
        settingsIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> foreground));
        UIManager.removePropertyChangeListener(propertyChangeListener);
        propertyChangeListener = e -> {
            if ("lookAndFeel".equals(e.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    Color newForeground = UIManager.getColor("TableHeader.foreground");
                    settingsIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> newForeground));
                });
            }
        };
        UIManager.addPropertyChangeListener(propertyChangeListener);
    }

    static {
        settingsIcon = new FlatSVGIcon(DockingUI.class.getResource("/ui_ext_icons/settings.svg"));
    }
}

