/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrewauclair.moderndocking.ext.ui;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import io.github.andrewauclair.moderndocking.ui.DefaultHeaderUI;
import io.github.andrewauclair.moderndocking.ui.DockingHeaderUI;
import io.github.andrewauclair.moderndocking.ui.DockingSettings;
import io.github.andrewauclair.moderndocking.ui.HeaderController;
import io.github.andrewauclair.moderndocking.ui.HeaderModel;
import java.awt.Color;
import javax.swing.Icon;

public class FlatLafHeaderUI
extends DefaultHeaderUI
implements DockingHeaderUI {
    private final FlatSVGIcon settingsIcon = new FlatSVGIcon(FlatLafHeaderUI.class.getResource("/ui_ext_icons/settings.svg"));
    private final FlatSVGIcon closeIcon = new FlatSVGIcon(FlatLafHeaderUI.class.getResource("/ui_ext_icons/close.svg"));

    public FlatLafHeaderUI(HeaderController headerController, HeaderModel headerModel) {
        super(headerController, headerModel);
        if (!this.settingsIcon.hasFound()) {
            throw new RuntimeException("settings.svg icon not found");
        }
        if (!this.closeIcon.hasFound()) {
            throw new RuntimeException("close.svg icon not found");
        }
        this.setBackground(DockingSettings.getHeaderBackground());
        Color foreground = DockingSettings.getHeaderForeground();
        this.settingsIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> foreground));
        this.closeIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> foreground));
    }

    protected void init() {
        super.init();
        this.settings.setIcon((Icon)this.settingsIcon);
        this.close.setIcon((Icon)this.closeIcon);
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.settingsIcon != null) {
            this.settingsIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> fg));
        }
        if (this.closeIcon != null) {
            this.closeIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> fg));
        }
    }
}

