/*
 * Decompiled with CFR 0.152.
 */
package io.androidpoet.drafter.bars.renderer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import io.androidpoet.drafter.bars.BarChartDataRenderer;
import io.androidpoet.drafter.bars.model.StackedBarChartData;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016JP\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lio/androidpoet/drafter/bars/renderer/StackedBarChartRenderer;", "Lio/androidpoet/drafter/bars/BarChartDataRenderer;", "data", "Lio/androidpoet/drafter/bars/model/StackedBarChartData;", "<init>", "(Lio/androidpoet/drafter/bars/model/StackedBarChartData;)V", "getData", "()Lio/androidpoet/drafter/bars/model/StackedBarChartData;", "getLabels", "", "", "barsPerGroup", "", "calculateMaxValue", "", "calculateBarAndSpacing", "Lkotlin/Pair;", "chartWidth", "dataSize", "calculateGroupWidth", "barWidth", "drawBars", "", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "index", "left", "groupSpacing", "chartBottom", "chartHeight", "maxValue", "animationProgress", "drafter_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStackedBarChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackedBarChartRenderer.kt\nio/androidpoet/drafter/bars/renderer/StackedBarChartRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1#2:120\n1872#3,3:121\n*S KotlinDebug\n*F\n+ 1 StackedBarChartRenderer.kt\nio/androidpoet/drafter/bars/renderer/StackedBarChartRenderer\n*L\n99#1:121,3\n*E\n"})
public final class StackedBarChartRenderer
implements BarChartDataRenderer {
    @NotNull
    private final StackedBarChartData data;
    public static final int $stable = 8;

    public StackedBarChartRenderer(@NotNull StackedBarChartData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
    }

    @NotNull
    public final StackedBarChartData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public List<String> getLabels() {
        return this.data.getLabelsList();
    }

    @Override
    public int barsPerGroup() {
        return 1;
    }

    @Override
    public float calculateMaxValue() {
        Iterator iterator = ((Iterable)this.data.getStacks()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        List it = (List)iterator.next();
        boolean bl = false;
        float f = CollectionsKt.sumOfFloat((Iterable)it);
        while (iterator.hasNext()) {
            List it2 = (List)iterator.next();
            $i$a$-maxOf-StackedBarChartRenderer$calculateMaxValue$1 = false;
            float f2 = CollectionsKt.sumOfFloat((Iterable)it2);
            f = Math.max(f, f2);
        }
        return f;
    }

    @Override
    @NotNull
    public Pair<Float, Float> calculateBarAndSpacing(float chartWidth, int dataSize, int barsPerGroup) {
        if (dataSize <= 0) {
            return new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }
        float totalGapSpace = chartWidth * 0.2f;
        float groupSpacing = totalGapSpace / (float)(dataSize + 1);
        float availableWidth = chartWidth - totalGapSpace;
        float barWidth = RangesKt.coerceAtLeast((float)(availableWidth / (float)dataSize), (float)0.0f);
        return new Pair((Object)Float.valueOf(barWidth), (Object)Float.valueOf(groupSpacing));
    }

    @Override
    public float calculateGroupWidth(float barWidth, int barsPerGroup) {
        return barWidth;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawBars(@NotNull DrawScope drawScope, int index, float left, float barWidth, float groupSpacing, float chartBottom, float chartHeight, float maxValue, float animationProgress) {
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        if (index >= this.data.getStacks().size()) {
            return;
        }
        float currentBottom = 0.0f;
        currentBottom = chartBottom;
        List<Float> stackValues = this.data.getStacks().get(index);
        Iterable $this$forEachIndexed$iv = stackValues;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Color color;
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            float f = ((Number)item$iv).floatValue();
            int stackIndex = n;
            boolean bl = false;
            float safeMaxValue = RangesKt.coerceAtLeast((float)maxValue, (float)1.0E-6f);
            void barHeight = value / safeMaxValue * chartHeight * animationProgress;
            List<Color> list = this.data.getColors();
            boolean bl2 = 0 <= stackIndex ? stackIndex < list.size() : false;
            if (bl2) {
                color = list.get(stackIndex);
            } else {
                int it = stackIndex;
                boolean bl3 = false;
                color = Color.box-impl((long)Color.Companion.getGray-0d7_KjU());
            }
            long barColor = color.unbox-impl();
            DrawScope.drawRect-n-J9OG0$default((DrawScope)drawScope, (long)barColor, (long)OffsetKt.Offset((float)left, (float)(currentBottom - barHeight)), (long)SizeKt.Size((float)barWidth, (float)barHeight), (float)0.0f, null, null, (int)0, (int)120, null);
            currentBottom -= barHeight;
        }
    }
}

