/*
 * Decompiled with CFR 0.152.
 */
package io.androidpoet.drafter.lines.renderer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import io.androidpoet.drafter.lines.LineChartDataRenderer;
import io.androidpoet.drafter.lines.model.GroupedLineChartData;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J@\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/androidpoet/drafter/lines/renderer/GroupedLineChartRenderer;", "Lio/androidpoet/drafter/lines/LineChartDataRenderer;", "data", "Lio/androidpoet/drafter/lines/model/GroupedLineChartData;", "<init>", "(Lio/androidpoet/drafter/lines/model/GroupedLineChartData;)V", "getLabels", "", "", "calculateMaxValue", "", "drawLines", "", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "chartLeft", "chartTop", "chartWidth", "chartHeight", "maxValue", "animationProgress", "drafter_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGroupedLineChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupedLineChartRenderer.kt\nio/androidpoet/drafter/lines/renderer/GroupedLineChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1872#2,2:102\n1863#2,2:105\n1874#2:107\n1#3:104\n*S KotlinDebug\n*F\n+ 1 GroupedLineChartRenderer.kt\nio/androidpoet/drafter/lines/renderer/GroupedLineChartRenderer\n*L\n47#1:102,2\n67#1:105,2\n47#1:107\n*E\n"})
public final class GroupedLineChartRenderer
implements LineChartDataRenderer {
    @NotNull
    private final GroupedLineChartData data;
    public static final int $stable = 8;

    public GroupedLineChartRenderer(@NotNull GroupedLineChartData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
    }

    @Override
    @NotNull
    public List<String> getLabels() {
        return this.data.getLabels();
    }

    @Override
    public float calculateMaxValue() {
        Float f = CollectionsKt.maxOrNull((Iterable)CollectionsKt.flatten((Iterable)this.data.getGroupedValues()));
        return f != null ? f.floatValue() : 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawLines(@NotNull DrawScope drawScope, float chartLeft, float chartTop, float chartWidth, float chartHeight, float maxValue, float animationProgress) {
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        int numPoints = this.data.getLabels().size();
        ArrayList<Float> arrayList = new ArrayList<Float>(numPoints);
        int n = 0;
        while (n < numPoints) {
            void index;
            int n2;
            int n3 = n2 = n++;
            ArrayList<Float> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(Float.valueOf(chartLeft + (float)index * (chartWidth / (float)(numPoints - 1))));
        }
        List xPositions = arrayList;
        Iterable $this$forEachIndexed$iv = this.data.getItemNames();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            long end;
            long start;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String cfr_ignored_0 = (String)item$iv;
            int itemIndex = n4;
            boolean bl = false;
            ArrayList<Offset> arrayList3 = new ArrayList<Offset>(numPoints);
            int n5 = 0;
            while (n5 < numPoints) {
                void index;
                int n6;
                int n7 = n6 = n5++;
                ArrayList<Offset> arrayList4 = arrayList3;
                boolean bl2 = false;
                float value = ((Number)this.data.getGroupedValues().get((int)index).get(itemIndex)).floatValue();
                float x = ((Number)xPositions.get((int)index)).floatValue();
                float y = chartTop + chartHeight - value / maxValue * chartHeight;
                arrayList4.add(Offset.box-impl((long)OffsetKt.Offset((float)x, (float)y)));
            }
            List points = arrayList3;
            Iterable iterable = CollectionsKt.zipWithNext((Iterable)points);
            double d = 0.0;
            for (Object value : iterable) {
                Pair pair = (Pair)value;
                double d2 = d;
                boolean bl3 = false;
                start = ((Offset)pair.component1()).unbox-impl();
                end = ((Offset)pair.component2()).unbox-impl();
                float dx = Offset.getX-impl((long)end) - Offset.getX-impl((long)start);
                float dy = Offset.getY-impl((long)end) - Offset.getY-impl((long)start);
                double d3 = Math.sqrt(dx * dx + dy * dy);
                d = d2 + d3;
            }
            float totalLength = (float)d;
            float currentLength = 0.0f;
            Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)points);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DrawScope drawScope2;
                Pair pair = (Pair)element$iv;
                boolean bl4 = false;
                start = ((Offset)pair.component1()).unbox-impl();
                end = ((Offset)pair.component2()).unbox-impl();
                float segmentLength = (float)Math.sqrt((float)Math.pow(Offset.getX-impl((long)end) - Offset.getX-impl((long)start), 2) + (float)Math.pow(Offset.getY-impl((long)end) - Offset.getY-impl((long)start), 2));
                float segmentProgress = (currentLength + segmentLength) / totalLength;
                if (segmentProgress <= animationProgress) {
                    Color color;
                    DrawScope drawScope3 = drawScope;
                    List<Color> list = this.data.getColors();
                    boolean bl5 = 0 <= itemIndex ? itemIndex < list.size() : false;
                    if (bl5) {
                        color = list.get(itemIndex);
                    } else {
                        int n8 = itemIndex;
                        drawScope2 = drawScope3;
                        boolean bl6 = false;
                        color = Color.box-impl((long)Color.Companion.getGray-0d7_KjU());
                        drawScope3 = drawScope2;
                    }
                    DrawScope.drawLine-NGM6Ib0$default((DrawScope)drawScope3, (long)color.unbox-impl(), (long)start, (long)end, (float)2.0f, (int)0, null, (float)0.0f, null, (int)0, (int)496, null);
                } else if (currentLength / totalLength <= animationProgress) {
                    Color color;
                    float remainingProgress = (animationProgress - currentLength / totalLength) / (segmentLength / totalLength);
                    long partialEnd = OffsetKt.Offset((float)(Offset.getX-impl((long)start) + (Offset.getX-impl((long)end) - Offset.getX-impl((long)start)) * remainingProgress), (float)(Offset.getY-impl((long)start) + (Offset.getY-impl((long)end) - Offset.getY-impl((long)start)) * remainingProgress));
                    DrawScope drawScope4 = drawScope;
                    List<Color> list = this.data.getColors();
                    boolean bl7 = 0 <= itemIndex ? itemIndex < list.size() : false;
                    if (bl7) {
                        color = list.get(itemIndex);
                    } else {
                        int n9 = itemIndex;
                        drawScope2 = drawScope4;
                        boolean bl8 = false;
                        color = Color.box-impl((long)Color.Companion.getGray-0d7_KjU());
                        drawScope4 = drawScope2;
                    }
                    DrawScope.drawLine-NGM6Ib0$default((DrawScope)drawScope4, (long)color.unbox-impl(), (long)start, (long)partialEnd, (float)2.0f, (int)0, null, (float)0.0f, null, (int)0, (int)496, null);
                }
                currentLength += segmentLength;
            }
        }
    }
}

