/*
 * Decompiled with CFR 0.152.
 */
package io.androidpoet.drafter.lines.renderer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import io.androidpoet.drafter.lines.LineChartDataRenderer;
import io.androidpoet.drafter.lines.model.SimpleLineChartData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J@\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/androidpoet/drafter/lines/renderer/LineChartRenderer;", "Lio/androidpoet/drafter/lines/LineChartDataRenderer;", "data", "Lio/androidpoet/drafter/lines/model/SimpleLineChartData;", "<init>", "(Lio/androidpoet/drafter/lines/model/SimpleLineChartData;)V", "getLabels", "", "", "calculateMaxValue", "", "drawLines", "", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "chartLeft", "chartTop", "chartWidth", "chartHeight", "maxValue", "animationProgress", "drafter_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLineChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineChartRenderer.kt\nio/androidpoet/drafter/lines/renderer/LineChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1567#2:94\n1598#2,4:95\n1863#2,2:100\n1#3:99\n*S KotlinDebug\n*F\n+ 1 LineChartRenderer.kt\nio/androidpoet/drafter/lines/renderer/LineChartRenderer\n*L\n41#1:94\n41#1:95,4\n59#1:100,2\n*E\n"})
public final class LineChartRenderer
implements LineChartDataRenderer {
    @NotNull
    private final SimpleLineChartData data;
    public static final int $stable = 8;

    public LineChartRenderer(@NotNull SimpleLineChartData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
    }

    @Override
    @NotNull
    public List<String> getLabels() {
        return this.data.getLabels();
    }

    @Override
    public float calculateMaxValue() {
        Float f = CollectionsKt.maxOrNull((Iterable)this.data.getValues());
        return f != null ? f.floatValue() : 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawLines(@NotNull DrawScope drawScope, float chartLeft, float chartTop, float chartWidth, float chartHeight, float maxValue, float animationProgress) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        Iterable $this$mapIndexed$iv = this.data.getValues();
        boolean $i$f$mapIndexed22 = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void value;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            float f = ((Number)item$iv$iv).floatValue();
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            float x = chartLeft + (float)index * (chartWidth / (float)(this.data.getValues().size() - 1));
            float y = chartTop + chartHeight - value / maxValue * chartHeight;
            collection.add(Offset.box-impl((long)OffsetKt.Offset((float)x, (float)y)));
        }
        List points = (List)destination$iv$iv;
        Iterable $i$f$mapIndexed22 = CollectionsKt.zipWithNext((Iterable)points);
        double d = 0.0;
        for (Object t : $i$f$mapIndexed22) {
            Pair pair = (Pair)t;
            double d2 = d;
            boolean bl = false;
            long start = ((Offset)pair.component1()).unbox-impl();
            long end = ((Offset)pair.component2()).unbox-impl();
            float dx = Offset.getX-impl((long)end) - Offset.getX-impl((long)start);
            float dy = Offset.getY-impl((long)end) - Offset.getY-impl((long)start);
            double d3 = Math.sqrt(dx * dx + dy * dy);
            d = d2 + d3;
        }
        float totalLength = (float)d;
        float currentLength = 0.0f;
        long lastDrawnPoint = 0L;
        lastDrawnPoint = ((Offset)CollectionsKt.first((List)points)).unbox-impl();
        Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)points);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            long start = ((Offset)pair.component1()).unbox-impl();
            long end = ((Offset)pair.component2()).unbox-impl();
            float segmentLength = (float)Math.sqrt((float)Math.pow(Offset.getX-impl((long)end) - Offset.getX-impl((long)start), 2) + (float)Math.pow(Offset.getY-impl((long)end) - Offset.getY-impl((long)start), 2));
            float segmentProgress = (currentLength + segmentLength) / totalLength;
            if (segmentProgress <= animationProgress) {
                DrawScope.drawLine-NGM6Ib0$default((DrawScope)drawScope, (long)this.data.getColor-0d7_KjU(), (long)start, (long)end, (float)2.0f, (int)0, null, (float)0.0f, null, (int)0, (int)496, null);
                lastDrawnPoint = end;
            } else if (currentLength / totalLength <= animationProgress) {
                float remainingProgress = (animationProgress - currentLength / totalLength) / (segmentLength / totalLength);
                long partialEnd = OffsetKt.Offset((float)(Offset.getX-impl((long)start) + (Offset.getX-impl((long)end) - Offset.getX-impl((long)start)) * remainingProgress), (float)(Offset.getY-impl((long)start) + (Offset.getY-impl((long)end) - Offset.getY-impl((long)start)) * remainingProgress));
                DrawScope.drawLine-NGM6Ib0$default((DrawScope)drawScope, (long)this.data.getColor-0d7_KjU(), (long)start, (long)partialEnd, (float)2.0f, (int)0, null, (float)0.0f, null, (int)0, (int)496, null);
            }
            currentLength += segmentLength;
        }
    }
}

