/*
 * Decompiled with CFR 0.152.
 */
package io.androidpoet.drafter.bars.renderer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import io.androidpoet.drafter.bars.BarChartDataRenderer;
import io.androidpoet.drafter.bars.model.GroupedBarChartData;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016JP\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lio/androidpoet/drafter/bars/renderer/GroupedBarChartRenderer;", "Lio/androidpoet/drafter/bars/BarChartDataRenderer;", "data", "Lio/androidpoet/drafter/bars/model/GroupedBarChartData;", "<init>", "(Lio/androidpoet/drafter/bars/model/GroupedBarChartData;)V", "getData", "()Lio/androidpoet/drafter/bars/model/GroupedBarChartData;", "getLabels", "", "", "barsPerGroup", "", "calculateMaxValue", "", "calculateBarAndSpacing", "Lkotlin/Pair;", "chartWidth", "dataSize", "calculateGroupWidth", "barWidth", "drawBars", "", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "index", "left", "groupSpacing", "chartBottom", "chartHeight", "maxValue", "animationProgress", "drafter_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGroupedBarChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupedBarChartRenderer.kt\nio/androidpoet/drafter/bars/renderer/GroupedBarChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1872#2,2:129\n1874#2:132\n1#3:131\n*S KotlinDebug\n*F\n+ 1 GroupedBarChartRenderer.kt\nio/androidpoet/drafter/bars/renderer/GroupedBarChartRenderer\n*L\n114#1:129,2\n114#1:132\n*E\n"})
public final class GroupedBarChartRenderer
implements BarChartDataRenderer {
    @NotNull
    private final GroupedBarChartData data;
    public static final int $stable = 8;

    public GroupedBarChartRenderer(@NotNull GroupedBarChartData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
    }

    @NotNull
    public final GroupedBarChartData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public List<String> getLabels() {
        return this.data.getLabelsList();
    }

    @Override
    public int barsPerGroup() {
        return this.data.getItemNames().size();
    }

    @Override
    public float calculateMaxValue() {
        Float f = CollectionsKt.maxOrNull((Iterable)CollectionsKt.flatten((Iterable)this.data.getGroupedValues()));
        return f != null ? f.floatValue() : 0.0f;
    }

    @Override
    @NotNull
    public Pair<Float, Float> calculateBarAndSpacing(float chartWidth, int dataSize, int barsPerGroup) {
        float totalGroupSpacing = chartWidth * 0.1f;
        float groupSpacing = totalGroupSpacing / (float)(dataSize + 1);
        float availableWidth = chartWidth - totalGroupSpacing;
        float totalBarSpacingPerGroup = (float)(barsPerGroup - 1) * 4.0f;
        float barWidth = (availableWidth / (float)dataSize - totalBarSpacingPerGroup) / (float)barsPerGroup;
        return new Pair((Object)Float.valueOf(barWidth), (Object)Float.valueOf(groupSpacing));
    }

    @Override
    public float calculateGroupWidth(float barWidth, int barsPerGroup) {
        float totalBarSpacingPerGroup = (float)(barsPerGroup - 1) * 4.0f;
        return barWidth * (float)barsPerGroup + totalBarSpacingPerGroup;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawBars(@NotNull DrawScope drawScope, int index, float left, float barWidth, float groupSpacing, float chartBottom, float chartHeight, float maxValue, float animationProgress) {
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        List<Float> groupValues = this.data.getGroupedValues().get(index);
        float barSpacing = 4.0f;
        float currentLeft = 0.0f;
        currentLeft = left;
        Iterable $this$forEachIndexed$iv = groupValues;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Color color;
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            float f = ((Number)item$iv).floatValue();
            int barIndex = n;
            boolean bl = false;
            void barHeight = value / maxValue * chartHeight * animationProgress;
            List<Color> list = this.data.getColors();
            boolean bl2 = 0 <= barIndex ? barIndex < list.size() : false;
            if (bl2) {
                color = list.get(barIndex);
            } else {
                int it = barIndex;
                boolean bl3 = false;
                color = Color.box-impl((long)Color.Companion.getGray-0d7_KjU());
            }
            long barColor = color.unbox-impl();
            DrawScope.drawRect-n-J9OG0$default((DrawScope)drawScope, (long)barColor, (long)OffsetKt.Offset((float)currentLeft, (float)(chartBottom - barHeight)), (long)SizeKt.Size((float)barWidth, (float)barHeight), (float)0.0f, null, null, (int)0, (int)120, null);
            currentLeft += barWidth + barSpacing;
        }
    }
}

