/*
 * Decompiled with CFR 0.152.
 */
package io.androidpoet.drafter.bars.renderer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import io.androidpoet.drafter.bars.BarChartDataRenderer;
import io.androidpoet.drafter.bars.model.HistogramData;
import io.androidpoet.drafter.bars.renderer.HistogramRendererKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0016JP\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0016J-\u0010\"\u001a\u00020\f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b#\u0010$R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/androidpoet/drafter/bars/renderer/HistogramRenderer;", "Lio/androidpoet/drafter/bars/BarChartDataRenderer;", "dataPoints", "", "", "binCount", "", "color", "Landroidx/compose/ui/graphics/Color;", "<init>", "(Ljava/util/List;IJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "histogramData", "Lio/androidpoet/drafter/bars/model/HistogramData;", "getLabels", "", "barsPerGroup", "calculateMaxValue", "calculateBarAndSpacing", "Lkotlin/Pair;", "chartWidth", "dataSize", "calculateGroupWidth", "barWidth", "drawBars", "", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "index", "left", "groupSpacing", "chartBottom", "chartHeight", "maxValue", "animationProgress", "createHistogramData", "createHistogramData-mxwnekA", "(Ljava/util/List;IJ)Lio/androidpoet/drafter/bars/model/HistogramData;", "drafter_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHistogramRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistogramRenderer.kt\nio/androidpoet/drafter/bars/renderer/HistogramRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1#2:183\n1863#3,2:184\n*S KotlinDebug\n*F\n+ 1 HistogramRenderer.kt\nio/androidpoet/drafter/bars/renderer/HistogramRenderer\n*L\n154#1:184,2\n*E\n"})
public final class HistogramRenderer
implements BarChartDataRenderer {
    @NotNull
    private final HistogramData histogramData;
    public static final int $stable = 8;

    private HistogramRenderer(List<Float> dataPoints, int binCount, long color) {
        Intrinsics.checkNotNullParameter(dataPoints, (String)"dataPoints");
        this.histogramData = this.createHistogramData-mxwnekA(dataPoints, binCount, color);
    }

    public /* synthetic */ HistogramRenderer(List list, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = Color.Companion.getBlue-0d7_KjU();
        }
        this(list, n, l, null);
    }

    @Override
    @NotNull
    public List<String> getLabels() {
        return this.histogramData.getLabels();
    }

    @Override
    public int barsPerGroup() {
        return 1;
    }

    @Override
    public float calculateMaxValue() {
        Float f = CollectionsKt.maxOrNull((Iterable)this.histogramData.getFrequencies());
        float maxFreq = f != null ? f.floatValue() : 0.0f;
        return maxFreq > 0.0f ? maxFreq : 1.0f;
    }

    @Override
    @NotNull
    public Pair<Float, Float> calculateBarAndSpacing(float chartWidth, int dataSize, int barsPerGroup) {
        if (dataSize <= 0 || chartWidth <= 0.0f) {
            return TuplesKt.to((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }
        float totalSpacing = chartWidth * 0.1f;
        float rawGroupSpacing = totalSpacing / (float)(dataSize + 1);
        float availableWidth = chartWidth - totalSpacing;
        float rawBarWidth = availableWidth / (float)dataSize;
        float safeBarWidth = RangesKt.coerceAtLeast((float)rawBarWidth, (float)0.0f);
        float safeGroupSpacing = RangesKt.coerceAtLeast((float)rawGroupSpacing, (float)0.0f);
        return TuplesKt.to((Object)Float.valueOf(safeBarWidth), (Object)Float.valueOf(safeGroupSpacing));
    }

    @Override
    public float calculateGroupWidth(float barWidth, int barsPerGroup) {
        return barWidth;
    }

    @Override
    public void drawBars(@NotNull DrawScope drawScope, int index, float left, float barWidth, float groupSpacing, float chartBottom, float chartHeight, float maxValue, float animationProgress) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        float freq = ((Number)this.histogramData.getFrequencies().get(index)).floatValue();
        float safeMax = Math.max(maxValue, 1.0f);
        float barHeight = freq / safeMax * chartHeight * animationProgress;
        List<Color> list = this.histogramData.getColors();
        boolean bl = 0 <= index ? index < list.size() : false;
        if (bl) {
            color = list.get(index);
        } else {
            int it = index;
            boolean bl2 = false;
            color = Color.box-impl((long)Color.Companion.getBlue-0d7_KjU());
        }
        long barColor = color.unbox-impl();
        DrawScope.drawRect-n-J9OG0$default((DrawScope)drawScope, (long)barColor, (long)OffsetKt.Offset((float)left, (float)(chartBottom - barHeight)), (long)SizeKt.Size((float)barWidth, (float)barHeight), (float)0.0f, null, null, (int)0, (int)120, null);
    }

    private final HistogramData createHistogramData-mxwnekA(List<Float> dataPoints, int binCount, long color) {
        int n;
        int it;
        int n2;
        ArrayList<Object> arrayList;
        int n3;
        Float f = CollectionsKt.minOrNull((Iterable)dataPoints);
        float minVal = f != null ? f.floatValue() : 0.0f;
        Float f2 = CollectionsKt.maxOrNull((Iterable)dataPoints);
        float maxVal = f2 != null ? f2.floatValue() : minVal;
        float binSize = maxVal > minVal ? (maxVal - minVal) / (float)binCount : 1.0f;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(binCount);
        int n4 = 0;
        while (n4 < binCount) {
            int n5 = n3 = n4++;
            arrayList = arrayList2;
            n2 = 0;
            arrayList.add(Float.valueOf(0.0f));
        }
        List frequencies = arrayList2;
        ArrayList arrayList3 = new ArrayList(binCount);
        n3 = 0;
        while (n3 < binCount) {
            n2 = it = n3++;
            arrayList = arrayList3;
            n = 0;
            arrayList.add("");
        }
        List labels = arrayList3;
        ArrayList arrayList4 = new ArrayList(binCount);
        it = 0;
        while (it < binCount) {
            int it2;
            n = it2 = it++;
            arrayList = arrayList4;
            boolean bl = false;
            arrayList.add(Color.box-impl((long)color));
        }
        List colors = arrayList4;
        Iterable $this$forEach$iv = dataPoints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            float point = ((Number)element$iv).floatValue();
            boolean bl = false;
            int binIndex = RangesKt.coerceIn((int)((int)((point - minVal) / binSize)), (int)0, (int)(binCount - 1));
            frequencies.set(binIndex, Float.valueOf(((Number)frequencies.get(binIndex)).floatValue() + 1.0f));
        }
        for (int i = 0; i < binCount; ++i) {
            float start = minVal + (float)i * binSize;
            float end = start + binSize;
            labels.set(i, HistogramRendererKt.access$formatToOneDecimal(start) + '-' + HistogramRendererKt.access$formatToOneDecimal(end));
        }
        return new HistogramData(labels, frequencies, colors);
    }

    public /* synthetic */ HistogramRenderer(List dataPoints, int binCount, long color, DefaultConstructorMarker $constructor_marker) {
        this(dataPoints, binCount, color);
    }
}

