/*
 * Decompiled with CFR 0.152.
 */
package io.androidpoet.drafter.bars.renderer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import io.androidpoet.drafter.bars.BarChartDataRenderer;
import io.androidpoet.drafter.bars.model.WaterfallChartData;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016JP\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lio/androidpoet/drafter/bars/renderer/WaterfallChartRenderer;", "Lio/androidpoet/drafter/bars/BarChartDataRenderer;", "data", "Lio/androidpoet/drafter/bars/model/WaterfallChartData;", "<init>", "(Lio/androidpoet/drafter/bars/model/WaterfallChartData;)V", "getData", "()Lio/androidpoet/drafter/bars/model/WaterfallChartData;", "getLabels", "", "", "barsPerGroup", "", "calculateMaxValue", "", "calculateBarAndSpacing", "Lkotlin/Pair;", "chartWidth", "dataSize", "calculateGroupWidth", "barWidth", "drawBars", "", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "index", "left", "groupSpacing", "chartBottom", "chartHeight", "maxValue", "animationProgress", "drafter_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWaterfallChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaterfallChartRenderer.kt\nio/androidpoet/drafter/bars/renderer/WaterfallChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1863#2,2:155\n1863#2,2:157\n1#3:159\n*S KotlinDebug\n*F\n+ 1 WaterfallChartRenderer.kt\nio/androidpoet/drafter/bars/renderer/WaterfallChartRenderer\n*L\n55#1:155,2\n125#1:157,2\n*E\n"})
public final class WaterfallChartRenderer
implements BarChartDataRenderer {
    @NotNull
    private final WaterfallChartData data;
    public static final int $stable = 8;

    public WaterfallChartRenderer(@NotNull WaterfallChartData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
    }

    @NotNull
    public final WaterfallChartData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public List<String> getLabels() {
        return this.data.getLabelsList();
    }

    @Override
    public int barsPerGroup() {
        return 1;
    }

    @Override
    public float calculateMaxValue() {
        List cumulativeValues = new ArrayList();
        float sum = 0.0f;
        sum = this.data.getInitialValue();
        cumulativeValues.add(Float.valueOf(sum));
        Iterable $this$forEach$iv = this.data.getValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            float value = ((Number)element$iv).floatValue();
            boolean bl = false;
            cumulativeValues.add(Float.valueOf(sum += value));
        }
        Float f = CollectionsKt.maxOrNull((Iterable)cumulativeValues);
        float max = f != null ? Math.abs(f.floatValue()) : 0.0f;
        Float f2 = CollectionsKt.minOrNull((Iterable)cumulativeValues);
        float min = f2 != null ? Math.abs(f2.floatValue()) : 0.0f;
        return Math.max(max, min);
    }

    @Override
    @NotNull
    public Pair<Float, Float> calculateBarAndSpacing(float chartWidth, int dataSize, int barsPerGroup) {
        float totalSpacing = chartWidth * 0.1f;
        float groupSpacing = totalSpacing / (float)(dataSize + 1);
        float availableWidth = chartWidth - totalSpacing;
        float barWidth = availableWidth / (float)dataSize;
        return new Pair((Object)Float.valueOf(barWidth), (Object)Float.valueOf(groupSpacing));
    }

    @Override
    public float calculateGroupWidth(float barWidth, int barsPerGroup) {
        return barWidth;
    }

    @Override
    public void drawBars(@NotNull DrawScope drawScope, int index, float left, float barWidth, float groupSpacing, float chartBottom, float chartHeight, float maxValue, float animationProgress) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        if (index >= this.data.getValues().size()) {
            return;
        }
        List cumulativeValues = new ArrayList();
        float sum = 0.0f;
        sum = this.data.getInitialValue();
        cumulativeValues.add(Float.valueOf(sum));
        Iterable $this$forEach$iv = this.data.getValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            float value = ((Number)element$iv).floatValue();
            boolean bl = false;
            cumulativeValues.add(Float.valueOf(sum += value));
        }
        float startValue = ((Number)cumulativeValues.get(index)).floatValue();
        float endValue = ((Number)cumulativeValues.get(index + 1)).floatValue();
        float yStart = chartBottom - startValue / maxValue * chartHeight;
        float yEnd = chartBottom - endValue / maxValue * chartHeight;
        float top = Math.min(yStart, yEnd);
        float height = Math.abs(yEnd - yStart) * animationProgress;
        List<Color> list = this.data.getColors();
        boolean bl = 0 <= index ? index < list.size() : false;
        if (bl) {
            color = list.get(index);
        } else {
            int it = index;
            boolean bl2 = false;
            color = Color.box-impl((long)Color.Companion.getGray-0d7_KjU());
        }
        long barColor = color.unbox-impl();
        DrawScope.drawRect-n-J9OG0$default((DrawScope)drawScope, (long)barColor, (long)OffsetKt.Offset((float)left, (float)top), (long)SizeKt.Size((float)barWidth, (float)height), (float)0.0f, null, null, (int)0, (int)120, null);
        if (index > 0) {
            float prevYEnd = ((Number)cumulativeValues.get(index)).floatValue();
            float previousYCoord = chartBottom - prevYEnd / maxValue * chartHeight;
            DrawScope.drawLine-NGM6Ib0$default((DrawScope)drawScope, (long)Color.Companion.getBlack-0d7_KjU(), (long)OffsetKt.Offset((float)(left - barWidth - groupSpacing), (float)previousYCoord), (long)OffsetKt.Offset((float)left, (float)yStart), (float)2.0f, (int)0, null, (float)0.0f, null, (int)0, (int)496, null);
        }
    }
}

