/*
 * Decompiled with CFR 0.152.
 */
package io.androidpoet.drafter.radar.renderer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Fill;
import androidx.compose.ui.graphics.drawscope.Stroke;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextMeasurer;
import androidx.compose.ui.text.TextPainterKt;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.TextUnitKt;
import io.androidpoet.drafter.radar.RadarChartDataRenderer;
import io.androidpoet.drafter.radar.model.RadarChartData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ@\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016JF\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JG\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006!"}, d2={"Lio/androidpoet/drafter/radar/renderer/RadarChartRenderer;", "Lio/androidpoet/drafter/radar/RadarChartDataRenderer;", "data", "", "Lio/androidpoet/drafter/radar/model/RadarChartData;", "colors", "Landroidx/compose/ui/graphics/Color;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getData", "()Ljava/util/List;", "getColors", "drawChart", "", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "centerX", "", "centerY", "radius", "textMeasurer", "Landroidx/compose/ui/text/TextMeasurer;", "animationProgress", "isSystemInDarkTheme", "", "drawBackgroundAndAxes", "axisLabels", "", "drawDataPolygon", "color", "progress", "drawDataPolygon-hftG7rw", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;FFFLio/androidpoet/drafter/radar/model/RadarChartData;JF)V", "drafter_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRadarChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadarChartRenderer.kt\nio/androidpoet/drafter/radar/renderer/RadarChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1872#2,3:160\n1567#2:163\n1598#2,4:164\n1863#2,2:168\n*S KotlinDebug\n*F\n+ 1 RadarChartRenderer.kt\nio/androidpoet/drafter/radar/renderer/RadarChartRenderer\n*L\n59#1:160,3\n132#1:163\n132#1:164,4\n142#1:168,2\n*E\n"})
public final class RadarChartRenderer
implements RadarChartDataRenderer {
    @NotNull
    private final List<RadarChartData> data;
    @NotNull
    private final List<Color> colors;
    public static final int $stable = 8;

    public RadarChartRenderer(@NotNull List<RadarChartData> data, @NotNull List<Color> colors) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.data = data;
        this.colors = colors;
    }

    @NotNull
    public final List<RadarChartData> getData() {
        return this.data;
    }

    @NotNull
    public final List<Color> getColors() {
        return this.colors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawChart(@NotNull DrawScope drawScope, float centerX, float centerY, float radius, @NotNull TextMeasurer textMeasurer, float animationProgress, boolean isSystemInDarkTheme) {
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        this.drawBackgroundAndAxes(drawScope, centerX, centerY, radius, textMeasurer, CollectionsKt.toList((Iterable)((RadarChartData)CollectionsKt.first(this.data)).getValues().keySet()), isSystemInDarkTheme);
        Iterable $this$forEachIndexed$iv = this.data;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void chartData;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RadarChartData radarChartData = (RadarChartData)item$iv;
            int index = n;
            boolean bl = false;
            this.drawDataPolygon-hftG7rw(drawScope, centerX, centerY, radius, (RadarChartData)chartData, this.colors.get(index).unbox-impl(), animationProgress);
        }
    }

    private final void drawBackgroundAndAxes(DrawScope drawScope, float centerX, float centerY, float radius, TextMeasurer textMeasurer, List<String> axisLabels, boolean isSystemInDarkTheme) {
        int i;
        int numberOfAxes = axisLabels.size();
        for (i = 1; i < 11; ++i) {
            long l = isSystemInDarkTheme ? Color.Companion.getWhite-0d7_KjU() : Color.Companion.getBlack-0d7_KjU();
            long l2 = OffsetKt.Offset((float)centerX, (float)centerY);
            float f = radius * (float)i / (float)10;
            Stroke stroke = new Stroke(1.0f, 0.0f, 0, 0, null, 30, null);
            DrawScope.drawCircle-VaOC9Bg$default((DrawScope)drawScope, (long)l, (float)f, (long)l2, (float)0.0f, (DrawStyle)((DrawStyle)stroke), null, (int)0, (int)104, null);
        }
        for (i = 0; i < numberOfAxes; ++i) {
            double angle = (double)(i * 2) * Math.PI / (double)numberOfAxes - 1.5707963267948966;
            float endX = centerX + radius * (float)Math.cos(angle);
            float endY = centerY + radius * (float)Math.sin(angle);
            DrawScope.drawLine-NGM6Ib0$default((DrawScope)drawScope, (long)(isSystemInDarkTheme ? Color.Companion.getWhite-0d7_KjU() : Color.Companion.getBlack-0d7_KjU()), (long)OffsetKt.Offset((float)centerX, (float)centerY), (long)OffsetKt.Offset((float)endX, (float)endY), (float)1.0f, (int)0, null, (float)0.0f, null, (int)0, (int)496, null);
            TextLayoutResult textLayoutResult = TextMeasurer.measure-wNUYSr0$default((TextMeasurer)textMeasurer, (String)axisLabels.get(i), (TextStyle)new TextStyle(isSystemInDarkTheme ? Color.Companion.getWhite-0d7_KjU() : Color.Companion.getBlack-0d7_KjU(), TextUnitKt.getSp((int)12), null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFFFFC, null), (int)0, (boolean)false, (int)0, (long)0L, null, null, null, (boolean)false, (int)1020, null);
            TextPainterKt.drawText-d8-rzKo$default((DrawScope)drawScope, (TextLayoutResult)textLayoutResult, (long)0L, (long)OffsetKt.Offset((float)(endX - (float)(IntSize.getWidth-impl((long)textLayoutResult.getSize-YbymL2g()) / 2)), (float)(endY - (float)(IntSize.getHeight-impl((long)textLayoutResult.getSize-YbymL2g()) / 2))), (float)0.0f, null, null, null, (int)0, (int)250, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawDataPolygon-hftG7rw(DrawScope drawScope, float centerX, float centerY, float radius, RadarChartData data, long color, float progress) {
        Path path;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = data.getValues().values();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void value;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            float f = ((Number)item$iv$iv).floatValue();
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double angle = (double)(index * 2) * Math.PI / (double)data.getValues().size() - 1.5707963267948966;
            float x = centerX + radius * value * progress * (float)Math.cos(angle);
            float y = centerY + radius * value * progress * (float)Math.sin(angle);
            collection.add(Offset.box-impl((long)OffsetKt.Offset((float)x, (float)y)));
        }
        List points = (List)destination$iv$iv;
        Path $this$drawDataPolygon_hftG7rw_u24lambda_u243 = path = AndroidPath_androidKt.Path();
        boolean bl = false;
        $this$drawDataPolygon_hftG7rw_u24lambda_u243.moveTo(Offset.getX-impl((long)((Offset)CollectionsKt.first((List)points)).unbox-impl()), Offset.getY-impl((long)((Offset)CollectionsKt.first((List)points)).unbox-impl()));
        Iterable $this$forEach$iv = points;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Offset)element$iv).unbox-impl();
            boolean bl2 = false;
            $this$drawDataPolygon_hftG7rw_u24lambda_u243.lineTo(Offset.getX-impl((long)it), Offset.getY-impl((long)it));
        }
        $this$drawDataPolygon_hftG7rw_u24lambda_u243.close();
        Path path2 = path;
        DrawScope.drawPath-LG529CI$default((DrawScope)drawScope, (Path)path2, (long)Color.copy-wmQWz5c$default((long)color, (float)(0.5f * progress), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null), (float)0.0f, (DrawStyle)((DrawStyle)Fill.INSTANCE), null, (int)0, (int)52, null);
        DrawScope.drawPath-LG529CI$default((DrawScope)drawScope, (Path)path2, (long)Color.copy-wmQWz5c$default((long)color, (float)progress, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null), (float)0.0f, (DrawStyle)((DrawStyle)new Stroke(2.0f, 0.0f, 0, 0, null, 30, null)), null, (int)0, (int)52, null);
    }
}

