/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jdbc.ds;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DriverManagerDataSource
implements DataSource {
    private String driverClassName;
    private String url;
    private String user;
    private String password;
    private static boolean driverRegistered = false;

    public DriverManagerDataSource(String driverClassName, String url, String user, String password) {
        this.driverClassName = driverClassName;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public static DriverManagerDataSource instance(String driverClassName, String url, String user, String password) {
        DriverManagerDataSource ds = new DriverManagerDataSource(driverClassName, url, user, password);
        return ds;
    }

    private static void registerDriver(String clazz) throws SQLException {
        if (driverRegistered) {
            return;
        }
        try {
            if (clazz != null) {
                Class.forName(clazz);
            }
        }
        catch (Exception e) {
            throw new SQLException("Unable to register driver " + clazz);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        DriverManagerDataSource.registerDriver(this.driverClassName);
        Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
        conn.setAutoCommit(false);
        return conn;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        DriverManagerDataSource.registerDriver(this.driverClassName);
        Connection conn = DriverManager.getConnection(this.url, username, password);
        conn.setAutoCommit(false);
        return conn;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

