/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jdbc.util;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;

public class SqlToHtml {
    private Connection conn;
    private String sql;
    private List<Column> columns = new ArrayList<Column>();
    private int page = 0;
    private int pagelen = 0;
    private String dateFormat = "yyyy.MM.dd";
    private SimpleDateFormat dateFormatter = null;
    private String datetimeFormat = "yyyy.MM.dd HH:mm:ss";
    private SimpleDateFormat datetimeFormatter = null;
    private Function<Row, String> rowStyleResolver;
    private Function<Row, String> rowClassResolver;
    private StringBuilder sb = new StringBuilder();

    public SqlToHtml(Connection conn) {
        this.conn = conn;
    }

    public static SqlToHtml instance(Connection conn) {
        return new SqlToHtml(conn);
    }

    public SqlToHtml sql(String value) {
        this.sql = value;
        return this;
    }

    public String sql() {
        return this.sql;
    }

    public Column addColumn(String value) {
        Column col = Column.instance(this).header(value);
        this.columns.add(col);
        return col;
    }

    public SqlToHtml page(int value) {
        this.page = value;
        return this;
    }

    public int page() {
        return this.page;
    }

    public SqlToHtml pagelen(int value) {
        this.pagelen = value;
        return this;
    }

    public int pagelen() {
        return this.pagelen;
    }

    public SqlToHtml rowStyleResolver(Function<Row, String> value) {
        this.rowStyleResolver = value;
        return this;
    }

    public SqlToHtml rowClassResolver(Function<Row, String> value) {
        this.rowClassResolver = value;
        return this;
    }

    private SimpleDateFormat dateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(this.dateFormat);
        }
        return this.dateFormatter;
    }

    public SqlToHtml dateFormat(String value) {
        this.dateFormat = value;
        return this;
    }

    private SimpleDateFormat datetimeFormatter() {
        if (this.datetimeFormatter == null) {
            this.datetimeFormatter = new SimpleDateFormat(this.datetimeFormat);
        }
        return this.datetimeFormatter;
    }

    public SqlToHtml datetimeFormat(String value) {
        this.datetimeFormat = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table build() {
        Table table = new Table();
        if (this.sql == null) {
            table.error = "no sql";
            return table;
        }
        this.sql = this.clearSql(this.sql);
        if (this.pagelen < 1) {
            this.page = 0;
        }
        if (this.sql.toLowerCase().trim().startsWith("select")) {
            this.sb.append("<table class=\"sqlreport\">\n");
            ResultSet rs = null;
            Statement stmt = null;
            try {
                stmt = this.conn.createStatement();
                rs = stmt.executeQuery(this.sql);
                ResultSetMetaData md = rs.getMetaData();
                int columnCount = md.getColumnCount();
                if (this.columns.isEmpty()) {
                    for (int i = 0; i < columnCount; ++i) {
                        String label = md.getColumnLabel(i + 1);
                        int rownum = i;
                        if (label == null) {
                            label = "";
                        }
                        this.columns.add(Column.instance(this).header(label).valueResolver(row -> row.column(rownum)));
                    }
                }
                this.rowStart(null, "sqlheader");
                for (Column col : this.columns) {
                    this.coll(col, null, col.header());
                }
                this.rowEnd();
                boolean paggig = this.page > -1 && this.pagelen > 0;
                int startindex = this.page * this.pagelen;
                int endindex = startindex + this.pagelen;
                int index = -1;
                int size = 0;
                while (rs.next()) {
                    ++index;
                    if (paggig) {
                        if (index < startindex) continue;
                        if (index >= endindex) break;
                    }
                    ++size;
                    Row row2 = Row.instance(index);
                    for (int i = 0; i < columnCount; ++i) {
                        String value = null;
                        int type = md.getColumnType(i + 1);
                        value = type == 93 ? SqlToHtml.formatDate(this.datetimeFormatter(), rs.getTimestamp(i + 1)) : (type == 91 ? SqlToHtml.formatDate(this.dateFormatter(), rs.getDate(i + 1)) : rs.getString(i + 1));
                        row2.add(value);
                    }
                    this.rowStart(row2);
                    for (Column col : this.columns) {
                        this.coll(col, row2, col.value(row2));
                    }
                    this.rowEnd();
                }
                this.sb.append("</table>\n");
                table.size = size;
                table.html = this.sb.toString();
                Table table2 = table;
                return table2;
            }
            catch (Exception e) {
                table.error = e.toString();
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        table.error = "no select present";
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table buildPairs() {
        Table table = new Table();
        if (this.sql == null) {
            table.error = "no sql";
            return table;
        }
        this.sql = this.clearSql(this.sql);
        if (this.pagelen < 1) {
            this.page = 0;
        }
        if (this.sql.toLowerCase().trim().startsWith("select")) {
            this.sb.append("<table class=\"sqlreport\">\n");
            ResultSet rs = null;
            Statement stmt = null;
            try {
                stmt = this.conn.createStatement();
                rs = stmt.executeQuery(this.sql);
                ResultSetMetaData md = rs.getMetaData();
                int columnCount = md.getColumnCount();
                if (this.columns.isEmpty()) {
                    for (int i = 0; i < columnCount; ++i) {
                        String label = md.getColumnLabel(i + 1);
                        int rownum = i;
                        if (label == null) {
                            label = "";
                        }
                        this.columns.add(Column.instance(this).header(label).valueResolver(row -> row.column(rownum)));
                    }
                }
                boolean paggig = this.page > -1 && this.pagelen > 0;
                int startindex = this.page * this.pagelen;
                int endindex = startindex + this.pagelen;
                int index = -1;
                int size = 0;
                while (rs.next()) {
                    ++index;
                    if (paggig) {
                        if (index < startindex) continue;
                        if (index >= endindex) break;
                    }
                    ++size;
                    Row row2 = Row.instance(index);
                    for (int i = 0; i < columnCount; ++i) {
                        String value = null;
                        int type = md.getColumnType(i + 1);
                        value = type == 93 ? SqlToHtml.formatDate(this.datetimeFormatter(), rs.getTimestamp(i + 1)) : (type == 91 ? SqlToHtml.formatDate(this.dateFormatter(), rs.getDate(i + 1)) : rs.getString(i + 1));
                        row2.add(value);
                    }
                    this.rowStart(row2);
                    this.sb.append("  <td></td>");
                    this.sb.append("  <td>-------------------------------------</td>");
                    this.rowEnd();
                    for (Column col : this.columns) {
                        this.rowStart(row2);
                        this.coll(col, null, col.header());
                        this.coll(col, row2, col.value(row2));
                        this.rowEnd();
                    }
                }
                this.sb.append("</table>\n");
                table.size = size;
                table.html = this.sb.toString();
                Table table2 = table;
                return table2;
            }
            catch (Exception e) {
                table.error = e.toString();
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        table.error = "no select present";
        return table;
    }

    private String clearSql(String sql) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(sql, "\n\r");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line == null || (line = line.trim()).startsWith("--")) continue;
            sb.append(' ').append(line).append(' ');
        }
        return sb.toString().trim();
    }

    private static boolean isNumberType(int type) {
        if (type == -5) {
            return true;
        }
        if (type == 8) {
            return true;
        }
        if (type == 6) {
            return true;
        }
        if (type == 4) {
            return true;
        }
        if (type == 2) {
            return true;
        }
        if (type == 7) {
            return true;
        }
        if (type == 5) {
            return true;
        }
        return type == -6;
    }

    private static String formatDate(SimpleDateFormat df, Date value) {
        if (value == null) {
            return null;
        }
        if (df == null) {
            return value.toString();
        }
        return df.format(value);
    }

    private static String formatDate(SimpleDateFormat df, Timestamp value) {
        if (value == null) {
            return null;
        }
        if (df == null) {
            return value.toString();
        }
        return df.format(value);
    }

    private void rowEnd() {
        this.sb.append("</tr>\n");
    }

    private void rowStart(Row row) {
        this.rowStart(row, null);
    }

    private void rowStart(Row row, String classes) {
        String style;
        this.sb.append(" <tr");
        classes = SqlToHtml.combineClasses(classes, this.rowClassResolver == null || row == null ? null : this.rowClassResolver.apply(row));
        if (classes != null) {
            this.sb.append(" class=\"").append(classes).append("\"");
        }
        String string = style = this.rowStyleResolver == null || row == null ? null : this.rowStyleResolver.apply(row);
        if (style != null) {
            this.sb.append(" style=\"").append(style).append("\"");
        }
        this.sb.append(">\n");
    }

    private void coll(Column col, Row row, String value) {
        this.coll(col, row, value, null);
    }

    private void coll(Column col, Row row, String value, String classes) {
        String style;
        this.sb.append("  <td");
        classes = SqlToHtml.combineClasses(classes, col.classResolver == null || row == null ? null : (String)col.classResolver.apply(row));
        if (classes != null) {
            this.sb.append(" class=\"").append(classes).append("\"");
        }
        String string = style = col.styleResolver == null || row == null ? null : (String)col.styleResolver.apply(row);
        if (style != null) {
            this.sb.append(" style=\"").append(style).append("\"");
        }
        this.sb.append(">");
        if (value != null) {
            this.sb.append(value);
        }
        this.sb.append("</td>\n");
    }

    private static String combineClasses(String cl1, String cl2) {
        StringBuilder sb = new StringBuilder();
        String cl = cl1;
        if (cl != null && (cl = cl.trim()).length() > 0) {
            sb.append(" ").append(cl);
        }
        if ((cl = cl2) != null && (cl = cl.trim()).length() > 0) {
            sb.append(" ").append(cl);
        }
        return sb.isEmpty() ? null : sb.toString().trim();
    }

    public static class Column {
        private SqlToHtml parent;
        private String header = "";
        private Function<Row, String> valueResolver;
        private Function<Row, String> styleResolver;
        private Function<Row, String> classResolver;

        private Column(SqlToHtml parent) {
            this.parent = parent;
        }

        private static Column instance(SqlToHtml parent) {
            return new Column(parent);
        }

        private String header() {
            return this.header;
        }

        public Column header(String value) {
            this.header = value;
            return this;
        }

        public Column valueResolver(Function<Row, String> value) {
            this.valueResolver = value;
            return this;
        }

        public Column styleResolver(Function<Row, String> value) {
            this.styleResolver = value;
            return this;
        }

        public Column classResolver(Function<Row, String> value) {
            this.classResolver = value;
            return this;
        }

        private String value(Row row) {
            if (this.valueResolver == null) {
                return "";
            }
            return this.valueResolver.apply(row);
        }

        public SqlToHtml columnDone() {
            return this.parent;
        }
    }

    public static class Table {
        String html;
        String error;
        int size;

        public String getError() {
            return this.error;
        }

        public String getHtml() {
            return this.html;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static class Row {
        private int row;
        private int size;
        private List<String> columns = new ArrayList<String>();

        private Row(int row) {
            this.row = row;
        }

        private static Row instance(int row) {
            return new Row(row);
        }

        private void add(String value) {
            this.row = this.columns.size();
            ++this.size;
            this.columns.add(value == null ? "" : value);
        }

        public int row() {
            return this.row;
        }

        public int size() {
            return this.size;
        }

        public String column(int i) {
            if (i < 0) {
                return "";
            }
            if (i >= this.size) {
                return "";
            }
            return this.columns.get(i);
        }
    }
}

