/*
 * Decompiled with CFR 0.152.
 */
package io.github.aparnachaudhary.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.github.aparnachaudhary.metrics.model.BaseEntity;
import io.github.aparnachaudhary.metrics.model.CounterEntity;
import io.github.aparnachaudhary.metrics.model.GaugeEntity;
import io.github.aparnachaudhary.metrics.model.HistogramEntity;
import io.github.aparnachaudhary.metrics.model.MeteredEntity;
import io.github.aparnachaudhary.metrics.model.TimerEntity;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDBReporter.class);
    private final ServerAddress[] serverAddresses;
    private final MongoCredential[] mongoCredentials;
    private final MongoClientOptions mongoClientOptions;
    private final String databaseName;
    private final Clock clock;
    private final String prefix;
    private final MongoDatabase mongoDatabase;
    private Map<String, Object> additionalFields;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public MongoDBReporter(MetricRegistry registry, String databaseName, ServerAddress[] serverAddresses, MongoCredential[] mongoCredentials, MongoClientOptions mongoClientOptions, Clock clock, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, Map<String, Object> additionalFields) {
        super(registry, "mongodb-reporter", filter, rateUnit, durationUnit);
        this.databaseName = databaseName;
        this.serverAddresses = serverAddresses;
        this.mongoCredentials = mongoCredentials;
        this.mongoClientOptions = mongoClientOptions;
        this.clock = clock;
        this.prefix = prefix;
        this.additionalFields = additionalFields;
        this.mongoDatabase = this.getDB();
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (gauges.isEmpty() && counters.isEmpty() && histograms.isEmpty() && meters.isEmpty() && timers.isEmpty()) {
            LOGGER.info("All metrics empty, nothing to report");
            return;
        }
        Date reportingTime = Date.from(ZonedDateTime.now(ZoneOffset.UTC).toInstant());
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            if (entry.getValue().getValue() == null) continue;
            this.reportGauge(entry.getKey(), entry.getValue(), reportingTime);
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.reportCounter(entry.getKey(), (Counter)entry.getValue(), reportingTime);
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.reportHistogram(entry.getKey(), (Histogram)entry.getValue(), reportingTime);
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.reportMetered(entry.getKey(), (Metered)entry.getValue(), reportingTime);
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.reportTimer(entry.getKey(), (Timer)entry.getValue(), reportingTime);
        }
    }

    private void reportGauge(String name, Gauge gauge, Date timestamp) {
        MongoCollection coll = this.mongoDatabase.getCollection("gauge");
        Object value = gauge.getValue();
        GaugeEntity entity = new GaugeEntity();
        entity.setName(MetricRegistry.name((String)this.prefix, (String[])new String[]{name}));
        entity.setTimestamp(timestamp);
        entity.setValue(value);
        try {
            this.storeInMongo(coll, entity);
        }
        catch (MongoException e) {
            LOGGER.warn("Unable to report gauge {}", (Object)name, (Object)e);
        }
    }

    private void reportCounter(String name, Counter counter, Date timestamp) {
        MongoCollection coll = this.mongoDatabase.getCollection("counter");
        CounterEntity entity = new CounterEntity();
        entity.setName(MetricRegistry.name((String)this.prefix, (String[])new String[]{name}));
        entity.setCount(counter.getCount());
        entity.setTimestamp(timestamp);
        try {
            this.storeInMongo(coll, entity);
        }
        catch (MongoException e) {
            LOGGER.warn("Unable to report counter {}", (Object)name, (Object)e);
        }
    }

    private void reportHistogram(String name, Histogram histogram, Date timestamp) {
        MongoCollection coll = this.mongoDatabase.getCollection("histogram");
        Snapshot snapshot = histogram.getSnapshot();
        HistogramEntity entity = new HistogramEntity(snapshot);
        entity.setName(MetricRegistry.name((String)this.prefix, (String[])new String[]{name}));
        entity.setCount(histogram.getCount());
        entity.setTimestamp(timestamp);
        try {
            this.storeInMongo(coll, entity);
        }
        catch (MongoException e) {
            LOGGER.warn("Unable to report histogram {}", (Object)name, (Object)e);
        }
    }

    private void reportMetered(String name, Metered meter, Date timestamp) {
        MongoCollection coll = this.mongoDatabase.getCollection("metered");
        MeteredEntity entity = new MeteredEntity(meter);
        entity.setName(MetricRegistry.name((String)this.prefix, (String[])new String[]{name}));
        entity.setTimestamp(timestamp);
        try {
            this.storeInMongo(coll, entity);
        }
        catch (MongoException e) {
            LOGGER.warn("Unable to report meter {}", (Object)name, (Object)e);
        }
    }

    private void reportTimer(String name, Timer timer, Date timestamp) {
        MongoCollection coll = this.mongoDatabase.getCollection("timer");
        TimerEntity entity = new TimerEntity(timer);
        entity.setName(MetricRegistry.name((String)this.prefix, (String[])new String[]{name}));
        entity.setTimestamp(timestamp);
        try {
            this.storeInMongo(coll, entity);
        }
        catch (MongoException e) {
            LOGGER.warn("Unable to report timer {}", (Object)name, (Object)e);
        }
    }

    private void storeInMongo(MongoCollection coll, BaseEntity entity) {
        Document document = new Document((Map)entity);
        if (this.additionalFields != null) {
            for (Map.Entry<String, Object> field : this.additionalFields.entrySet()) {
                document.putIfAbsent((Object)field.getKey(), field.getValue());
            }
        }
        coll.insertOne((Object)document);
    }

    private MongoDatabase getDB() {
        MongoClient mongoClient = null;
        mongoClient = this.mongoCredentials == null ? new MongoClient(Arrays.asList(this.serverAddresses), this.mongoClientOptions) : new MongoClient(Arrays.asList(this.serverAddresses), Arrays.asList(this.mongoCredentials), this.mongoClientOptions);
        return mongoClient.getDatabase(this.databaseName);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private ServerAddress[] serverAddresses = new ServerAddress[]{new ServerAddress("localhost", 27017)};
        private MongoCredential[] mongoCredentials;
        private MongoClientOptions mongoClientOptions;
        private String databaseName = "metricstore";
        private Map<String, Object> additionalFields;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.mongoClientOptions = new MongoClientOptions.Builder().build();
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder serverAddresses(ServerAddress[] serverAddresses) {
            this.serverAddresses = serverAddresses;
            return this;
        }

        public Builder mongoClientOptions(MongoClientOptions mongoClientOptions) {
            this.mongoClientOptions = mongoClientOptions;
            return this;
        }

        public Builder mongoCredentials(MongoCredential[] mongoCredentials) {
            this.mongoCredentials = mongoCredentials;
            return this;
        }

        public Builder additionalFields(Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        public MongoDBReporter build() {
            return new MongoDBReporter(this.registry, this.databaseName, this.serverAddresses, this.mongoCredentials, this.mongoClientOptions, this.clock, this.prefix, this.rateUnit, this.durationUnit, this.filter, this.additionalFields);
        }
    }
}

