/*
 * Decompiled with CFR 0.152.
 */
package com.nawforce.apexlink.types.apex;

import com.nawforce.apexlink.api.DependentSummary;
import com.nawforce.apexlink.api.FieldDependentSummary;
import com.nawforce.apexlink.api.MethodDependentSummary;
import com.nawforce.apexlink.api.TypeDependentSummary;
import com.nawforce.apexlink.finding.TypeError;
import com.nawforce.apexlink.finding.TypeResolver$;
import com.nawforce.apexlink.org.OPM;
import com.nawforce.apexlink.types.apex.ApexClassDeclaration;
import com.nawforce.apexlink.types.apex.SummaryDeclaration;
import com.nawforce.apexlink.types.core.Dependent;
import com.nawforce.apexlink.types.core.FieldDeclaration;
import com.nawforce.apexlink.types.core.MethodDeclaration;
import com.nawforce.apexlink.types.core.TypeDeclaration;
import com.nawforce.apexlink.types.core.TypeId;
import com.nawforce.apexlink.types.other.ComponentDeclaration;
import com.nawforce.apexlink.types.other.InterviewDeclaration;
import com.nawforce.apexlink.types.other.LabelDeclaration;
import com.nawforce.apexlink.types.other.PageDeclaration;
import com.nawforce.apexlink.types.schema.SObjectDeclaration;
import com.nawforce.pkgforce.diagnostics.LoggerOps$;
import com.nawforce.pkgforce.names.Name;
import com.nawforce.pkgforce.names.TypeIdentifier;
import com.nawforce.pkgforce.names.TypeName;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class DependentValidation$ {
    public static final DependentValidation$ MODULE$ = new DependentValidation$();

    public boolean areTypeDependenciesValid(DependentSummary[] dependents, OPM.Module module, HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        boolean bl;
        Object object = new Object();
        try {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])dependents), (Function1 & Serializable)dependent -> {
                DependentValidation$.$anonfun$areTypeDependenciesValid$1(module, typeCache, object, dependent);
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private Option<TypeDeclaration> findValidTypeDependent(TypeDependentSummary dependent, OPM.Module module, HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        return this.convertToTypeId(module, dependent.typeId()).flatMap((Function1 & Serializable)typeId -> this.findSummaryType$1((TypeId)typeId, (HashMap)typeCache).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DependentValidation$.$anonfun$findValidTypeDependent$4(dependent, x0$1))));
    }

    public Dependent[] getDependents(DependentSummary[] dependents, OPM.Module module, HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        return (Dependent[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])dependents), (Function1 & Serializable)dependent -> {
            Option<Dependent> dep;
            block0: {
                dep = MODULE$.findDependent((DependentSummary)dependent, module, typeCache);
                if (!dep.isEmpty()) break block0;
                LoggerOps$.MODULE$.debug(new StringBuilder(26).append("Rejected other dependency ").append(dependent).toString());
            }
            return dep;
        }, ClassTag$.MODULE$.apply(Dependent.class));
    }

    private Option<Dependent> findDependent(DependentSummary dependent, OPM.Module module, HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        DependentSummary dependentSummary = dependent;
        if (dependentSummary instanceof TypeDependentSummary) {
            TypeDependentSummary typeDependentSummary = (TypeDependentSummary)dependentSummary;
            return this.findDependent(typeDependentSummary, module, typeCache);
        }
        if (dependentSummary instanceof FieldDependentSummary) {
            FieldDependentSummary fieldDependentSummary = (FieldDependentSummary)dependentSummary;
            return this.findDependent(fieldDependentSummary, module, typeCache);
        }
        if (dependentSummary instanceof MethodDependentSummary) {
            MethodDependentSummary methodDependentSummary = (MethodDependentSummary)dependentSummary;
            return this.findDependent(methodDependentSummary, module, typeCache);
        }
        return None$.MODULE$;
    }

    private Option<TypeDeclaration> findDependent(TypeDependentSummary dependent, OPM.Module module, HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        return this.convertToTypeId(module, dependent.typeId()).flatMap((Function1 & Serializable)typeId -> MODULE$.findDependentType(typeId.typeName(), typeId.module(), typeCache));
    }

    private Option<FieldDeclaration> findDependent(FieldDependentSummary dependent, OPM.Module module, HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        Name name = new Name(dependent.name());
        return this.convertToTypeId(module, dependent.typeId()).flatMap((Function1 & Serializable)typeId -> MODULE$.findExactDependentType(typeId.typeName(), typeId.module(), typeCache).flatMap((Function1 & Serializable)x$2 -> x$2.fields().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DependentValidation$.$anonfun$findDependent$4(name, x$3)))));
    }

    private Option<MethodDeclaration> findDependent(MethodDependentSummary dependent, OPM.Module module, HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        Name name = new Name(dependent.name());
        return this.convertToTypeId(module, dependent.typeId()).flatMap((Function1 & Serializable)typeId -> MODULE$.findExactDependentType(typeId.typeName(), typeId.module(), typeCache).flatMap((Function1 & Serializable)x0$1 -> {
            TypeDeclaration typeDeclaration = x0$1;
            if (typeDeclaration instanceof ApexClassDeclaration) {
                ApexClassDeclaration apexClassDeclaration = (ApexClassDeclaration)typeDeclaration;
                return apexClassDeclaration.methodMap().findMethod(name, dependent.parameterTypes());
            }
            if (typeDeclaration != null) {
                TypeDeclaration typeDeclaration2 = typeDeclaration;
                return typeDeclaration2.methods().find((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)DependentValidation$.$anonfun$findDependent$7(name, dependent, m)));
            }
            throw new MatchError((Object)typeDeclaration);
        }));
    }

    private Option<TypeDeclaration> findExactDependentType(TypeName typeName, OPM.Module module, HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        return this.findDependentType(typeName, module, typeCache).flatMap((Function1 & Serializable)td -> {
            TypeName typeName = td.typeName();
            TypeName typeName2 = typeName;
            if (typeName == null ? typeName2 != null : !((Object)typeName).equals(typeName2)) {
                return td.nestedTypes().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DependentValidation$.$anonfun$findExactDependentType$2(typeName, x$5)));
            }
            return new Some(td);
        });
    }

    private Option<TypeDeclaration> findDependentType(TypeName typeName, OPM.Module module, HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        TypeDeclaration d;
        TypeDeclaration d2;
        TypeDeclaration d3;
        TypeDeclaration d4;
        TypeDeclaration d5;
        Either response = (Either)typeCache.getOrElseUpdate((Object)new Tuple2((Object)typeName, (Object)module), (Function0 & Serializable)() -> TypeResolver$.MODULE$.apply(typeName, module));
        boolean bl = false;
        Right right = null;
        Either either = response;
        if (either instanceof Left) {
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            TypeDeclaration d6 = (TypeDeclaration)right.value();
            if (d6 instanceof ApexClassDeclaration) {
                ApexClassDeclaration apexClassDeclaration = (ApexClassDeclaration)d6;
                return new Some((Object)apexClassDeclaration);
            }
        }
        if (bl && (d5 = (TypeDeclaration)right.value()) instanceof LabelDeclaration) {
            LabelDeclaration labelDeclaration = (LabelDeclaration)d5;
            return new Some((Object)labelDeclaration);
        }
        if (bl && (d4 = (TypeDeclaration)right.value()) instanceof InterviewDeclaration) {
            InterviewDeclaration interviewDeclaration = (InterviewDeclaration)d4;
            return new Some((Object)interviewDeclaration);
        }
        if (bl && (d3 = (TypeDeclaration)right.value()) instanceof PageDeclaration) {
            PageDeclaration pageDeclaration = (PageDeclaration)d3;
            return new Some((Object)pageDeclaration);
        }
        if (bl && (d2 = (TypeDeclaration)right.value()) instanceof ComponentDeclaration) {
            ComponentDeclaration componentDeclaration = (ComponentDeclaration)d2;
            return new Some((Object)componentDeclaration);
        }
        if (bl && (d = (TypeDeclaration)right.value()) instanceof SObjectDeclaration) {
            SObjectDeclaration sObjectDeclaration = (SObjectDeclaration)d;
            return new Some((Object)sObjectDeclaration);
        }
        if (bl) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)either);
    }

    private Option<TypeId> convertToTypeId(OPM.Module module, TypeIdentifier typeIdentifier) {
        TypeName typeName = typeIdentifier.typeName();
        Option<Name> option = typeIdentifier.namespace();
        Option<Name> option2 = module.namespace();
        if (!(option != null ? !option.equals(option2) : option2 != null)) {
            return new Some((Object)new TypeId(module, typeName));
        }
        Option pkg = module.pkg().org().packagesByNamespace().get(typeIdentifier.namespace());
        return pkg.flatMap((Function1 & Serializable)x$6 -> x$6.orderedModules().headOption()).map((Function1 & Serializable)x$7 -> new TypeId((OPM.Module)x$7, typeName));
    }

    public static final /* synthetic */ void $anonfun$areTypeDependenciesValid$1(OPM.Module module$1, HashMap typeCache$1, Object nonLocalReturnKey1$1, DependentSummary dependent) {
        DependentSummary dependentSummary = dependent;
        if (dependentSummary instanceof TypeDependentSummary) {
            TypeDependentSummary typeDependentSummary = (TypeDependentSummary)dependentSummary;
            Option<TypeDeclaration> td = MODULE$.findValidTypeDependent(typeDependentSummary, module$1, (HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>>)typeCache$1);
            if (td.isEmpty()) {
                LoggerOps$.MODULE$.debug(new StringBuilder(25).append("Rejected type dependency ").append(dependent).toString());
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
            }
            return;
        }
    }

    private final Option findSummaryType$1(TypeId typeId, HashMap typeCache$2) {
        return this.findDependentType(typeId.typeName(), typeId.module(), (HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>>)typeCache$2).orElse((Function0 & Serializable)() -> typeId.typeName().outer().flatMap((Function1 & Serializable)x$1 -> MODULE$.findDependentType((TypeName)x$1, typeId.module(), (HashMap<Tuple2<TypeName, OPM.Module>, Either<TypeError, TypeDeclaration>>)typeCache$2)));
    }

    public static final /* synthetic */ boolean $anonfun$findValidTypeDependent$4(TypeDependentSummary dependent$1, TypeDeclaration x0$1) {
        TypeDeclaration typeDeclaration = x0$1;
        if (typeDeclaration instanceof SummaryDeclaration) {
            SummaryDeclaration summaryDeclaration = (SummaryDeclaration)typeDeclaration;
            return summaryDeclaration.sourceHash() == dependent$1.sourceHash();
        }
        if (typeDeclaration instanceof LabelDeclaration) {
            LabelDeclaration labelDeclaration = (LabelDeclaration)typeDeclaration;
            return labelDeclaration.sourceHash() == dependent$1.sourceHash();
        }
        if (typeDeclaration instanceof InterviewDeclaration) {
            InterviewDeclaration interviewDeclaration = (InterviewDeclaration)typeDeclaration;
            return interviewDeclaration.sourceHash() == dependent$1.sourceHash();
        }
        if (typeDeclaration instanceof PageDeclaration) {
            PageDeclaration pageDeclaration = (PageDeclaration)typeDeclaration;
            return pageDeclaration.sourceHash() == dependent$1.sourceHash();
        }
        if (typeDeclaration instanceof ComponentDeclaration) {
            ComponentDeclaration componentDeclaration = (ComponentDeclaration)typeDeclaration;
            return componentDeclaration.sourceHash() == dependent$1.sourceHash();
        }
        if (typeDeclaration instanceof SObjectDeclaration) {
            SObjectDeclaration sObjectDeclaration = (SObjectDeclaration)typeDeclaration;
            return sObjectDeclaration.sourceHash() == dependent$1.sourceHash();
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$findDependent$4(Name name$1, FieldDeclaration x$3) {
        Name name = x$3.name();
        Name name2 = name$1;
        return !(name != null ? !((Object)name).equals(name2) : name2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findDependent$7(Name name$2, MethodDependentSummary dependent$2, MethodDeclaration m) {
        Name name = m.name();
        Name name2 = name$2;
        if (name == null) {
            if (name2 != null) {
                return false;
            }
        } else if (!((Object)name).equals(name2)) return false;
        ArraySeq arraySeq = m.parameters().map((Function1 & Serializable)x$4 -> x$4.typeName());
        ArraySeq<TypeName> arraySeq2 = dependent$2.parameterTypes();
        if (arraySeq == null) {
            if (arraySeq2 == null) return true;
            return false;
        } else {
            if (!arraySeq.equals(arraySeq2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$findExactDependentType$2(TypeName typeName$1, TypeDeclaration x$5) {
        TypeName typeName = x$5.typeName();
        TypeName typeName2 = typeName$1;
        return !(typeName != null ? !((Object)typeName).equals(typeName2) : typeName2 != null);
    }

    private DependentValidation$() {
    }
}

