/*
 * Decompiled with CFR 0.152.
 */
package com.nawforce.pkgforce.names;

import com.nawforce.pkgforce.names.Name;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;

public final class Identifier$ {
    public static final Identifier$ MODULE$ = new Identifier$();
    private static Set<Name> reservedIdentifiers;
    private static Set<Name> methodNotReservedIdentifiers;
    private static volatile byte bitmap$0;

    public Option<String> isLegalIdentifier(Name name) {
        String value = name.value();
        Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value)));
        if (value.startsWith("__sfdc_trigger")) {
            if (!value.matches("^((__sfdc_trigger)/[0-9a-zA-Z_]+)(/[0-9a-zA-Z_]+)?$")) {
                return new Some((Object)"can only be in the format '__sfdc_trigger/namespace/name' or '__sfdc_trigger/name'");
            }
            return None$.MODULE$;
        }
        if (!value.matches("^[0-9a-zA-Z_]*$")) {
            return new Some((Object)"can only use characters A-Z, a-z, 0-9 or _");
        }
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), 0) >= '0' && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), 0) <= '9') {
            return new Some((Object)"can not start with a digit");
        }
        if (StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(value)) == '_' || StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(value)) == '_') {
            return new Some((Object)"can not start or end with '_'");
        }
        if (value.contains("__")) {
            return new Some((Object)"can not use '__'");
        }
        return None$.MODULE$;
    }

    public boolean isReservedIdentifier(Name name) {
        return this.reservedIdentifiers().contains((Object)name);
    }

    public boolean isReservedMethodIdentifier(Name name) {
        return !this.methodNotReservedIdentifiers().contains((Object)name) && this.reservedIdentifiers().contains((Object)name);
    }

    private Set<Name> reservedIdentifiers$lzycompute() {
        Identifier$ identifier$ = this;
        synchronized (identifier$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                reservedIdentifiers = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Name[]{new Name("abstract"), new Name("activate"), new Name("and"), new Name("any"), new Name("array"), new Name("as"), new Name("asc"), new Name("autonomous"), new Name("begin"), new Name("bigdecimal"), new Name("blob"), new Name("boolean"), new Name("break"), new Name("bulk"), new Name("by"), new Name("byte"), new Name("case"), new Name("cast"), new Name("catch"), new Name("char"), new Name("class"), new Name("collect"), new Name("commit"), new Name("const"), new Name("continue"), new Name("currency"), new Name("date"), new Name("datetime"), new Name("decimal"), new Name("default"), new Name("delete"), new Name("desc"), new Name("do"), new Name("double"), new Name("else"), new Name("end"), new Name("enum"), new Name("exception"), new Name("exit"), new Name("export"), new Name("extends"), new Name("false"), new Name("final"), new Name("finally"), new Name("float"), new Name("for"), new Name("from"), new Name("global"), new Name("goto"), new Name("group"), new Name("having"), new Name("hint"), new Name("if"), new Name("implements"), new Name("import"), new Name("in"), new Name("inner"), new Name("insert"), new Name("instanceof"), new Name("int"), new Name("integer"), new Name("interface"), new Name("into"), new Name("join"), new Name("like"), new Name("limit"), new Name("list"), new Name("long"), new Name("loop"), new Name("map"), new Name("merge"), new Name("new"), new Name("not"), new Name("null"), new Name("nulls"), new Name("number"), new Name("object"), new Name("of"), new Name("on"), new Name("or"), new Name("outer"), new Name("override"), new Name("package"), new Name("parallel"), new Name("pragma"), new Name("private"), new Name("protected"), new Name("public"), new Name("retrieve"), new Name("return"), new Name("rollback"), new Name("select"), new Name("set"), new Name("short"), new Name("sobject"), new Name("sort"), new Name("static"), new Name("string"), new Name("super"), new Name("switch"), new Name("synchronized"), new Name("system"), new Name("testmethod"), new Name("then"), new Name("this"), new Name("throw"), new Name("time"), new Name("transaction"), new Name("trigger"), new Name("true"), new Name("try"), new Name("undelete"), new Name("update"), new Name("upsert"), new Name("using"), new Name("virtual"), new Name("void"), new Name("webservice"), new Name("when"), new Name("where"), new Name("while")}));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return reservedIdentifiers;
    }

    private Set<Name> reservedIdentifiers() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.reservedIdentifiers$lzycompute();
        }
        return reservedIdentifiers;
    }

    private Set<Name> methodNotReservedIdentifiers$lzycompute() {
        Identifier$ identifier$ = this;
        synchronized (identifier$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                methodNotReservedIdentifiers = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Name[]{new Name("activate"), new Name("any"), new Name("array"), new Name("autonomous"), new Name("begin"), new Name("bigdecimal"), new Name("blob"), new Name("boolean"), new Name("byte"), new Name("case"), new Name("cast"), new Name("char"), new Name("collect"), new Name("const"), new Name("currency"), new Name("date"), new Name("datetime"), new Name("decimal"), new Name("default"), new Name("double"), new Name("end"), new Name("exception"), new Name("exit"), new Name("export"), new Name("float"), new Name("goto"), new Name("group"), new Name("hint"), new Name("import"), new Name("inner"), new Name("integer"), new Name("int"), new Name("into"), new Name("join"), new Name("long"), new Name("loop"), new Name("number"), new Name("object"), new Name("of"), new Name("outer"), new Name("package"), new Name("parallel"), new Name("pragma"), new Name("retrieve"), new Name("rollback"), new Name("set"), new Name("short"), new Name("sobject"), new Name("sort"), new Name("string"), new Name("switch"), new Name("synchronized"), new Name("system"), new Name("then"), new Name("time"), new Name("transaction"), new Name("void"), new Name("when")}));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return methodNotReservedIdentifiers;
    }

    private Set<Name> methodNotReservedIdentifiers() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.methodNotReservedIdentifiers$lzycompute();
        }
        return methodNotReservedIdentifiers;
    }

    private Identifier$() {
    }
}

