/*
 * Decompiled with CFR 0.152.
 */
package com.nawforce.pkgforce.sfdx;

import com.nawforce.pkgforce.diagnostics.IssueLogger;
import com.nawforce.pkgforce.path.Location$;
import com.nawforce.pkgforce.path.PathLike;
import com.nawforce.pkgforce.sfdx.PositionParser$;
import com.nawforce.pkgforce.sfdx.SFDXProject;
import com.nawforce.pkgforce.sfdx.SFDXProjectError;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SFDXProject$ {
    public static final SFDXProject$ MODULE$ = new SFDXProject$();

    public Option<SFDXProject> apply(PathLike path, IssueLogger logger) {
        PathLike projectFile = path.join((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sfdx-project.json"}));
        if (!projectFile.isFile()) {
            logger.logError(projectFile, Location$.MODULE$.empty(), new StringBuilder(34).append("Missing sfdx-project.json file at ").append(projectFile).toString());
            return None$.MODULE$;
        }
        Either<String, String> either = projectFile.read();
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            logger.logError(projectFile, Location$.MODULE$.empty(), err);
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            Some some;
            Right right = (Right)either;
            String data = (String)right.value();
            try {
                some = new Some((Object)new SFDXProject(path, PositionParser$.MODULE$.parse(data)));
            }
            catch (SFDXProjectError ex) {
                logger.logError(projectFile, Location$.MODULE$.apply(ex.line(), ex.offset()), ex.getMessage());
                some = None$.MODULE$;
            }
            catch (Throwable ex) {
                logger.logError(projectFile, Location$.MODULE$.empty(), new StringBuilder(18).append("Failed to parse - ").append(ex.toString()).toString());
                some = None$.MODULE$;
            }
            return some;
        }
        throw new MatchError(either);
    }

    private SFDXProject$() {
    }
}

